package com.digiwin.athena.adt.sse.dto;

import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.sse.domain.EventData;
import lombok.Data;
import okhttp3.sse.EventSource;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import java.util.List;

/**
 * SSE基础时间
 */
@Data
public class SSEBaseEvent {

    /**
     * 推送消息唯一ID
     * 同消息ID
     */
    private String id;

    /**
     * 当前对话是否结束
     */
    private Boolean isOver;

    /**
     * 语义监听事件
     */
    private EventSource scrumEventSource;

    /**
     * 语义回答结果
     */
    private List<EventData> scrumEventDatas;

    /**
     * 语义对话是否结束
     */
    private Boolean isScrumOver;

    /**
     * 多语言标识
     */
    private String lang;

    /**
     * 娜娜SSE容器
     */
    private SseEmitter aniaEmitter;

    /**
     * 语义策略标识
     */
    private String schemaEnum;

    /**
     * adt 上下文
     */
    private AthenaMessageEvent event;

    public static void builderSchemaEvent(AthenaMessageEvent event, SSEBaseEvent sseBaseEvent) {
        sseBaseEvent.setId("");
        sseBaseEvent.setIsOver(false);
        sseBaseEvent.setIsScrumOver(false);
        sseBaseEvent.setLang(event.getLang());
        sseBaseEvent.setEvent(event);
    }
}
