package com.digiwin.athena.adt.sse.listener;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.config.AgileDataHandlerProcessor;
import com.digiwin.athena.adt.agileReport.config.SchemaDataHandlerProcessor;
import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.constant.BusinessConstants;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateCostService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.domain.dto.autoData.AgileDataAutoDataDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.sse.domain.EventData;
import com.digiwin.athena.adt.sse.domain.SseAniaEventEnum;
import com.digiwin.athena.adt.sse.domain.SseScrumEventEnum;
import com.digiwin.athena.adt.sse.dto.SSEBaseEvent;
import com.digiwin.athena.adt.sse.service.SSEOnEventService;
import com.digiwin.athena.adt.sse.utils.SseEmitterUtils;
import com.digiwin.athena.adt.sse.utils.SseEventUtils;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.util.SpringUtil;
import lombok.extern.slf4j.Slf4j;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import javax.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 语义事件监听
 */
@Slf4j
public class SSEScrumListener extends SSEBaseListener {

    private final SSEBaseEvent sseBaseEvent;

    private final SchemaDataHandlerProcessor schemaDataHandlerProcessor;

    private final AgileDataCalculateCostService agileDataCalculateCostService;

    private final AgileDataHandlerProcessor agileDataHandlerProcessor;

    private final  AbsAgileDataProcess absAgileDataProcess;

    private final EchoService echoService;

    public SSEScrumListener(SSEBaseEvent sseBaseEvent,
                            SchemaDataHandlerProcessor schemaDataHandlerProcessor,
                            AgileDataCalculateCostService agileDataCalculateCostService,
                            AgileDataHandlerProcessor agileDataHandlerProcessor,
                            AbsAgileDataProcess absAgileDataProcess,
                            EchoService echoService) {
        this.sseBaseEvent = sseBaseEvent;
        this.schemaDataHandlerProcessor = schemaDataHandlerProcessor;
        this.agileDataCalculateCostService = agileDataCalculateCostService;
        this.agileDataHandlerProcessor = agileDataHandlerProcessor;
        this.absAgileDataProcess = absAgileDataProcess;
        this.echoService = echoService;
    }

    /**
     * 通道连接成功事件
     * @param eventSource event
     * @param response res
     */
    @Override
    public void onOpen(EventSource eventSource, Response response) {
        sseBaseEvent.setScrumEventSource(eventSource);
    }

    /**
     * 监听语义推送事件
     * @param eventSource event
     * @param id id
     * @param type type
     * @param data data
     */
    @Override
    public void onEvent(EventSource eventSource, @Nullable String id, @Nullable String type, String data) {
        if(StringUtils.isEmpty(data)){
            return;
        }
        //入口
        String skillType = sseBaseEvent.getEvent().getSkillType();
        if(StringUtils.isEmpty(skillType)){
            skillType = "0";
        }
        SSEOnEventService sseOnEventService = SpringUtil.getBean(skillType + "_sseOnEvent",SSEOnEventService.class);
        sseOnEventService.onEvent(sseBaseEvent,eventSource,type,data,schemaDataHandlerProcessor,agileDataCalculateCostService,agileDataHandlerProcessor,absAgileDataProcess);
    }


    /**
     * 管道关闭事件
     * @param eventSource event
     */
    @Override
    public void onClosed(EventSource eventSource) {
        //标记语义对话结束
        sseBaseEvent.setIsScrumOver(true);
        //语义是否推送存在结束信息
        if(!SseEventUtils.noScrumTerminate(sseBaseEvent.getScrumEventDatas())){
            SseEmitterUtils.sendChatErrorComplete(sseBaseEvent.getAniaEmitter());
            SseEmitterUtils.sendAnswerDone(sseBaseEvent.getAniaEmitter(),false);
            sseBaseEvent.getAniaEmitter().complete();
        }

    }

    /**
     * 监听通道异常事件
     * @param eventSource event
     * @param t t
     * @param response res
     */
    @Override
    public void onFailure(EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
        log.info("语义监听出现异常，异常信息:{}",t.getMessage());
        sseBaseEvent.setIsScrumOver(true);
        String answer;
        String errorMsg = MessageUtil.getMessageByLanguage("message.system.schema.error",sseBaseEvent.getLang());
        if (Objects.isNull(response) || !response.isSuccessful()) {
            answer = errorMsg;
        } else {
            if (t instanceof IllegalStateException && t.getMessage().startsWith("ResponseBodyEmitter has already completed")) {
                return;
            }
            answer = errorMsg;
        }
        if (StringUtils.isNotBlank(answer)) {
            EventData eventData = new EventData(SseAniaEventEnum.MESSAGE_DELTA.getEvent());
            eventData.setData(new EventData.EventMessage(SseAniaEventEnum.SseEventDataTypeEnum.ANSWER.getType(), SseAniaEventEnum.EventDataMessageEnum.TEXT.getMessageType(), answer));
            SseEmitterUtils.sendChatErrorComplete(sseBaseEvent.getAniaEmitter());
            SseEmitterUtils.sendAnswerDone(sseBaseEvent.getAniaEmitter(),false);
            sseBaseEvent.getAniaEmitter().complete();
        }
    }

}
