package com.digiwin.athena.adt.sse.service;


import com.digiwin.athena.adt.agileReport.config.AgileDataHandlerProcessor;
import com.digiwin.athena.adt.agileReport.config.SchemaDataHandlerProcessor;
import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateCostService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.sse.domain.EventData;
import com.digiwin.athena.adt.sse.dto.SSEBaseEvent;
import com.digiwin.athena.adt.sse.utils.SseEmitterUtils;
import okhttp3.sse.EventSource;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import java.util.Objects;


public abstract class SSEOnEventService {

    public abstract void onEvent(SSEBaseEvent sseBaseEvent,EventSource eventSource, String type, String data,
                                 SchemaDataHandlerProcessor schemaDataHandlerProcessor,
                                 AgileDataCalculateCostService agileDataCalculateCostService,
                                 AgileDataHandlerProcessor agileDataHandlerProcessor,
                                 AbsAgileDataProcess absAgileDataProcess);

    /**
     * 发送娜娜消息
     * @param sendEvent 发送事件名称
     * @param sseEmitter sse链接
     * @param eventMessage 发送消息体
     */
    public void sendEventDataMessage(String sendEvent, SseEmitter sseEmitter, EventData.EventMessage eventMessage){
        EventData eventData = new EventData(sendEvent,eventMessage);
        if (Objects.nonNull(sseEmitter)) {
            SseEmitterUtils.send(sseEmitter, eventData);
        }
    }

}
