package com.digiwin.athena.adt.sse.service.impl.onEvent;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.config.AgileDataHandlerProcessor;
import com.digiwin.athena.adt.agileReport.config.SchemaDataHandlerProcessor;
import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateCostService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.sse.domain.EventData;
import com.digiwin.athena.adt.sse.domain.SseAniaEventEnum;
import com.digiwin.athena.adt.sse.domain.SseScrumEventEnum;
import com.digiwin.athena.adt.sse.dto.SSEBaseEvent;
import com.digiwin.athena.adt.sse.service.SSEOnEventService;
import com.digiwin.athena.adt.sse.utils.SseEmitterUtils;
import lombok.extern.slf4j.Slf4j;
import okhttp3.sse.EventSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Slf4j
@Service("4_sseOnEvent")
public class SSEOnEventAttributionSummaryServiceImpl extends SSEOnEventService {


    @Override
    public void onEvent(SSEBaseEvent sseBaseEvent, EventSource eventSource, String type, String data, SchemaDataHandlerProcessor schemaDataHandlerProcessor, AgileDataCalculateCostService agileDataCalculateCostService, AgileDataHandlerProcessor agileDataHandlerProcessor, AbsAgileDataProcess absAgileDataProcess) {
        SseEmitter sseEmitter = sseBaseEvent.getAniaEmitter();
        JSONObject res = JSONObject.parseObject(data);
        String message = res.getString("message");
        if (SseScrumEventEnum.SCRUMBI_RESULT.getEvent().equals(type)){
            SseEmitterUtils.sendChatErrorComplete(sseEmitter);
            SseEmitterUtils.sendAnswerDone(sseEmitter,true);
        }else if (SseScrumEventEnum.SCRUMBI_DONE.getEvent().equals(type)){
            eventSource.cancel();
        } else{
            if(StringUtils.isNotEmpty(message)) {
                EventData.EventMessage eventMessage = EventData.EventMessage.builderMessageV2(
                        "function_answer", message, sseBaseEvent.getId());
                this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(), sseEmitter, eventMessage);
            }
        }
    }
}
