package com.digiwin.athena.adt.sse.service.impl.onEvent;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.config.AgileDataHandlerProcessor;
import com.digiwin.athena.adt.agileReport.config.SchemaDataHandlerProcessor;
import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateCostService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.sse.domain.EventData;
import com.digiwin.athena.adt.sse.domain.SseAniaEventEnum;
import com.digiwin.athena.adt.sse.domain.SseScrumEventEnum;
import com.digiwin.athena.adt.sse.dto.SSEBaseEvent;
import com.digiwin.athena.adt.sse.service.SSEOnEventService;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import okhttp3.sse.EventSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import java.util.Map;
import java.util.Objects;

@Slf4j
@Service("2_sseOnEvent")
public class SSEOnEventAutoDataReportServiceImpl extends SSEOnEventService {

    @Override
    public void onEvent(SSEBaseEvent sseBaseEvent, EventSource eventSource, String type, String data, SchemaDataHandlerProcessor schemaDataHandlerProcessor, AgileDataCalculateCostService agileDataCalculateCostService, AgileDataHandlerProcessor agileDataHandlerProcessor, AbsAgileDataProcess absAgileDataProcess) {
        SseEmitter sseEmitter = sseBaseEvent.getAniaEmitter();
        JSONObject res = JSONObject.parseObject(data);
        String message = res.getString("message");
        String status = res.getString("status");
        String messageType = res.getString("type");
        if (SseScrumEventEnum.SCRUMBI_RESULT.getEvent().equals(type)){
            // 3.2 sse 执行后续步骤
            this.sseProcess(res,sseBaseEvent,schemaDataHandlerProcessor,agileDataCalculateCostService,agileDataHandlerProcessor,absAgileDataProcess);
        } else if (SseScrumEventEnum.SCRUMBI_COMPLEATE.getEvent().equals(type)){
            EventData.EventMessage eventMessage = EventData.EventMessage.builderMessageCloseV2(
                    "tool_response",sseBaseEvent.getId(),status);
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(),sseEmitter,eventMessage);
        } else if (SseScrumEventEnum.SCRUMBI_DONE.getEvent().equals(type)){
            eventSource.cancel();
        } else if (SseScrumEventEnum.SCRUMBI_ANALYSIS.getEvent().equals(type)){
            if(StringUtils.isNotEmpty(message)){
                EventData.EventMessage eventMessage = EventData.EventMessage.builderMessageV2(
                        "function_analysic","title",null,sseBaseEvent.getId(),message);
                this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(),sseEmitter,eventMessage);
            }
        } else {
            String functionType = StringUtils.EMPTY;
            if(StringUtils.equals("reportGeneration",messageType)){
                functionType = "function_answer";
            } else {
                functionType = "function_analysic";
            }
            EventData.EventMessage eventMessage = EventData.EventMessage.builderMessageV2(
                    functionType,message,sseBaseEvent.getId());
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(),sseEmitter,eventMessage);
        }
    }

    /**
     * 执行PPT分析规划
     * @param res 语义返回json
     */
    public void sseProcess(JSONObject res,
                           SSEBaseEvent sseBaseEvent,
                           SchemaDataHandlerProcessor schemaDataHandlerProcessor,
                           AgileDataCalculateCostService agileDataCalculateCostService,
                           AgileDataHandlerProcessor agileDataHandlerProcessor,
                           AbsAgileDataProcess absAgileDataProcess) {
        AthenaMessageEvent event = sseBaseEvent.getEvent();
        event.setSseCallId(sseBaseEvent.getId());
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义出参：{},耗时：{}ms", event.getUser().getUserId(),event.getUser().getUserName()
                ,event.getUser().getTenantId(),event.getUser().getTenantName(), event.getQuestion(),
                JsonUtils.objectToString(res),System.currentTimeMillis() - event.getGetQuerySchemaTook());
        if (res == null || Objects.isNull(res.get("message"))){
            return;
        }
        // 3.2.1 执行语义返回校验以及导正或数据组装逻辑
        Pair<Boolean, QuerySchemaResDTO> result = schemaDataHandlerProcessor.getEnumServiceByType(
                SchemaDataEnum.queryTypeEnumByCode(sseBaseEvent.getSchemaEnum()))
                .sseProcess(event, res);
        QuerySchemaResDTO schemaResDTO = result.getRight();
        if (schemaResDTO == null || schemaResDTO.getProcessStreamData() == null){
            absAgileDataProcess.saveQuerySchemaErrorByCode(event,null);
            return;
        }else if (!result.getLeft()){
            return;
        }
        // 计算计费  true 正常取数 false 返回记录日志
//        boolean isGo = agileDataCalculateCostService.calculateCostByCode(event, schemaResDTO);
//        if(!isGo){`
//            return;
//        }
        //数据存储
        String router = String.valueOf(result.getRight().getRoute());
        String serviceName = absAgileDataProcess.getServiceNameByQuerySchema(router);
        agileDataHandlerProcessor.getEnumServiceByType(
                AgileDataEnum.queryTypeEnumByCode(serviceName))
                .process(event, schemaResDTO);
    }
}
