package com.digiwin.athena.adt.sse.service.impl.onEvent;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.config.AgileDataHandlerProcessor;
import com.digiwin.athena.adt.agileReport.config.SchemaDataHandlerProcessor;
import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.constant.BusinessConstants;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateCostService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.sse.domain.EventData;
import com.digiwin.athena.adt.sse.domain.SseAniaEventEnum;
import com.digiwin.athena.adt.sse.domain.SseScrumEventEnum;
import com.digiwin.athena.adt.sse.dto.SSEBaseEvent;
import com.digiwin.athena.adt.sse.service.SSEOnEventService;
import com.digiwin.athena.adt.sse.utils.SseEmitterUtils;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import lombok.extern.slf4j.Slf4j;
import okhttp3.sse.EventSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import javax.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Slf4j
@Service("0_sseOnEvent")
public class SSEOnEventBIServiceImpl extends SSEOnEventService {

    @Override
    public void onEvent(SSEBaseEvent sseBaseEvent,EventSource eventSource, String type, String data,
                        SchemaDataHandlerProcessor schemaDataHandlerProcessor,
                        AgileDataCalculateCostService agileDataCalculateCostService,
                        AgileDataHandlerProcessor agileDataHandlerProcessor,
                        AbsAgileDataProcess absAgileDataProcess) {
        // 3.1 获取语义监听到的sse 根据 类型 发送ania 消息
        String sseProductVersion = sseBaseEvent.getEvent().getSseProductVersion();
        if(BusinessConstants.VERSION_1.equals(sseProductVersion)){
            this.sendEventByV1(sseBaseEvent,eventSource,type,data,schemaDataHandlerProcessor,agileDataCalculateCostService,agileDataHandlerProcessor,absAgileDataProcess);
        }else if (BusinessConstants.VERSION_2.equals(sseProductVersion)){
            this.sendEventByV2(sseBaseEvent,eventSource,type,data,schemaDataHandlerProcessor,agileDataCalculateCostService,agileDataHandlerProcessor,absAgileDataProcess);
        }else{
            this.sendEventByV1(sseBaseEvent,eventSource,type,data,schemaDataHandlerProcessor,agileDataCalculateCostService,agileDataHandlerProcessor,absAgileDataProcess);
        }
    }


    /**
     * 1.0 语义流式输出
     * @param eventSource e
     * @param type t
     * @param data d
     */
    private void sendEventByV1(SSEBaseEvent sseBaseEvent,
                               EventSource eventSource,
                               @Nullable String type,
                               String data,
                               SchemaDataHandlerProcessor schemaDataHandlerProcessor,
                               AgileDataCalculateCostService agileDataCalculateCostService,
                               AgileDataHandlerProcessor agileDataHandlerProcessor,
                               AbsAgileDataProcess absAgileDataProcess) {
        SseEmitter sseEmitter = sseBaseEvent.getAniaEmitter();
        JSONObject res = JSONObject.parseObject(data);
        String message = res.getString("message");
        String status = res.getString("status");
        if(SseScrumEventEnum.SCRUMBI_ANALYSIS.getEvent().equals(type)){
            Map<String ,Object> messageObj = new HashMap<>();
            messageObj.put("name",message);
            messageObj.put("arguments ",new HashMap<>());
            EventData.EventMessage eventMessage = EventData.EventMessage.builderNewEventMessage(
                    "function_call",messageObj,sseBaseEvent.getEvent());
            sseBaseEvent.setId(eventMessage.getExtra_info().getCall_id());
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(),sseEmitter,eventMessage);
        }else if(SseScrumEventEnum.MESSAGE_DETAIL.getEvent().equals(type)){
            EventData.EventMessage eventMessage = EventData.EventMessage.builderMessage(
                    "function_answer",message,sseBaseEvent.getId());
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(),sseEmitter,eventMessage);
        }else if (SseScrumEventEnum.SCRUMBI_COMPLEATE.getEvent().equals(type)){
            EventData.EventMessage eventMessage = EventData.EventMessage.builderMessageClose(
                    "tool_response",sseBaseEvent.getId(),status);
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(),sseEmitter,eventMessage);
        }else if (SseScrumEventEnum.SCRUMBI_RESULT.getEvent().equals(type)){
            // 3.2 sse 执行后续步骤
            this.sseProcess(res,sseBaseEvent,schemaDataHandlerProcessor,agileDataCalculateCostService,agileDataHandlerProcessor,absAgileDataProcess);
        }else if (SseScrumEventEnum.SCRUMBI_DONE.getEvent().equals(type)){
            eventSource.cancel();
        }
    }

    /**
     * 2.0 娜娜标准流式输出
     * @param eventSource e
     * @param type t
     * @param data d
     */
    private void sendEventByV2(SSEBaseEvent sseBaseEvent,
                               EventSource eventSource,
                               @Nullable String type,
                               String data,
                               SchemaDataHandlerProcessor schemaDataHandlerProcessor,
                               AgileDataCalculateCostService agileDataCalculateCostService,
                               AgileDataHandlerProcessor agileDataHandlerProcessor,
                               AbsAgileDataProcess absAgileDataProcess) {
        SseEmitter sseEmitter = sseBaseEvent.getAniaEmitter();
        JSONObject res = JSONObject.parseObject(data);
        String message = res.getString("message");
        String status = res.getString("status");
        if(SseScrumEventEnum.SCRUMBI_ANALYSIS.getEvent().equals(type)){
            EventData.EventMessage eventMessage = EventData.EventMessage.builderNewEventMessageV2(
                    "function_call",message,sseBaseEvent.getEvent());
            String callId = this.getV2CallId(eventMessage.getMessage());
            sseBaseEvent.setId(callId);
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(),sseEmitter,eventMessage);
        }else if(SseScrumEventEnum.MESSAGE_DETAIL.getEvent().equals(type)){
            EventData.EventMessage eventMessage = EventData.EventMessage.builderMessageV2(
                    "function_answer",message,sseBaseEvent.getId());
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(),sseEmitter,eventMessage);
        }else if (SseScrumEventEnum.SCRUMBI_COMPLEATE.getEvent().equals(type)){
            EventData.EventMessage eventMessage = EventData.EventMessage.builderMessageCloseV2(
                    "tool_response",sseBaseEvent.getId(),status);
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(),sseEmitter,eventMessage);
        }else if (SseScrumEventEnum.SCRUMBI_RESULT.getEvent().equals(type)){
            // 3.2 sse 执行后续步骤
            this.sseProcess(res,sseBaseEvent,schemaDataHandlerProcessor,agileDataCalculateCostService,agileDataHandlerProcessor,absAgileDataProcess);
        }else if (SseScrumEventEnum.SCRUMBI_DONE.getEvent().equals(type)){
            eventSource.cancel();
        }

    }



    /**
     * sse 问句
     * @param res 语义返回json
     */
    public void sseProcess(JSONObject res,
                           SSEBaseEvent sseBaseEvent,
                           SchemaDataHandlerProcessor schemaDataHandlerProcessor,
                           AgileDataCalculateCostService agileDataCalculateCostService,
                           AgileDataHandlerProcessor agileDataHandlerProcessor,
                           AbsAgileDataProcess absAgileDataProcess) {
        MDC.put("traceId", sseBaseEvent.getEvent().getPtxId());
        MDC.put("PtxId", sseBaseEvent.getEvent().getPtxId());
        JaMDC.put(sseBaseEvent.getEvent().getPtxId());
        AthenaMessageEvent event = sseBaseEvent.getEvent();
        event.setSseCallId(sseBaseEvent.getId());
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义出参：{},耗时：{}ms", event.getUser().getUserId(),event.getUser().getUserName()
                ,event.getUser().getTenantId(),event.getUser().getTenantName(), event.getQuestion(),
                JsonUtils.objectToString(res),System.currentTimeMillis() - event.getGetQuerySchemaTook());
        if (res == null || Objects.isNull(res.get("message"))){
            return;
        }
        // 3.2.1 执行语义返回校验以及导正或数据组装逻辑
        Pair<Boolean, QuerySchemaResDTO> result = schemaDataHandlerProcessor.getEnumServiceByType(
                SchemaDataEnum.queryTypeEnumByCode(sseBaseEvent.getSchemaEnum()))
                .sseProcess(event, res);
        QuerySchemaResDTO schemaResDTO = result.getRight();
        if (schemaResDTO == null || StringUtils.isEmpty(schemaResDTO.getData().getMethod())){
            absAgileDataProcess.saveQuerySchemaErrorByCode(event,null);
            return;
        }else if (!result.getLeft()){
            return;
        }
        // 计算计费  true 正常取数 false 返回记录日志
        boolean isGo = agileDataCalculateCostService.calculateCostByCode(event, schemaResDTO);
        if(!isGo){
            return;
        }
        String router = String.valueOf(result.getRight().getRoute());
        // ADE策略类型
        String serviceName = absAgileDataProcess.getServiceNameByQuerySchema(router);
        agileDataHandlerProcessor.getEnumServiceByType(
                AgileDataEnum.queryTypeEnumByCode(serviceName))
                .process(event, schemaResDTO);
    }

    public String getV2CallId(Object message) {
        Map<String, Object> messageMap = (Map<String, Object>) message;
        Map<String, Object> extraInfo = CommonUtil.convertObjectToMap(messageMap.get("extra_info"));

        return String.valueOf(extraInfo.get("call_id"));
    }

}
