package com.digiwin.athena.adt.sse.service.impl.process;

import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataMessageService;
import com.digiwin.athena.adt.domain.dto.autoData.AgileDataAutoDataDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.sse.domain.EventStreamClient;
import com.digiwin.athena.adt.sse.dto.SSEBaseEvent;
import com.digiwin.athena.adt.sse.listener.SSEScrumListener;
import com.digiwin.athena.adt.sse.service.SSEProcessService;
import com.digiwin.athena.adt.util.MessageUtil;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.jws.Oneway;
import java.util.Map;

/**
 * 分析师入口
 */
@Service("2_sseProcess")
public class SSEProcessAutoDataReportServiceImpl implements SSEProcessService {

    @Autowired
    private EchoService echoService;

    @Autowired
    private SemcService semcService;

    @Autowired
    private MessageUtil messageUtil;

    @Autowired
    private AgileDataMessageService agileDataMessageService;
    @Override
    public void process(SSEScrumListener sseScrumListener, AthenaMessageEvent event, String url, Map<String, Object> req, SSEBaseEvent sseBaseEvent) {


        String action = event.getAction();
        if(StringUtils.isEmpty(action)){
            return;
        }
        switch (action){
            // auto data question
            case "0":
                agileDataMessageService.processAutoData(event,url,req,sseBaseEvent);
                break;
            // auto data report
            case "1":
                //更新状态
                AgileDataAutoDataDTO agileDataAutoDataDTO = this.buildAutoDataReport(event);
                if(agileDataAutoDataDTO == null){
                    Map<String,Object> msgBody = event.getMsgBody();
                    msgBody.put("prompt",messageUtil.getMessageByLangNameWithFormat("message.adt.getReport.error",event.getLang()));
                    semcService.sendMessageToGpt(event,req);
                    return;
                }
                echoService.updateAutoDataReport(event.getUser(),agileDataAutoDataDTO);
                EventStreamClient.executeSSE(event,url,sseScrumListener,
                        new com.alibaba.fastjson.JSONObject(req), sseBaseEvent);
                break;
            default:
                break;
        }
    }

    private AgileDataAutoDataDTO buildAutoDataReport(AthenaMessageEvent event) {
        AgileDataAutoDataDTO autoDataDTO = new AgileDataAutoDataDTO();
        Map<String,Object> msgExt = event.getMsgExt();
        Long messageId = MapUtils.getLong(msgExt,"autoDataMessageId");
        if(messageId == null){
            return null;
        }
        autoDataDTO.setMessageId(messageId);
        autoDataDTO.setStatus("2");
        return autoDataDTO;
    }

}
