package com.digiwin.athena.adt.sse.service.impl.process;

import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.domain.dto.echo.AgileDataFileDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.sse.domain.EventStreamClient;
import com.digiwin.athena.adt.sse.dto.SSEBaseEvent;
import com.digiwin.athena.adt.sse.listener.SSEScrumListener;
import com.digiwin.athena.adt.sse.service.SSEProcessService;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.google.common.collect.Maps;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service("1_sseProcess")
public class SSEProcessPPTServiceImpl implements SSEProcessService {

    @Autowired
    private EchoService echoService;

    @Autowired
    private SemcService semcService;

    @Override
    public void process(SSEScrumListener sseScrumListener, AthenaMessageEvent event, String url, Map<String, Object> req, SSEBaseEvent sseBaseEvent) {
        String pptAction = event.getAction();
        if(StringUtils.isEmpty(pptAction)){
            return;
        }
        switch (pptAction){
            //走语义分析规划
            case "0":
                EventStreamClient.executeSSE(event,url,sseScrumListener,
                        new com.alibaba.fastjson.JSONObject(req), sseBaseEvent);
                break;
            //生成指定pptID，将PPTID绑定到指定消息中
            case "1":
                // 问句ID
                Long analyzeMessageId = MapUtils.getLong(event.getMsgExt(),"analyzeMessageId");
                if(analyzeMessageId != null){
                    //生成指定pptID
                    Long generateSerialNo = SnowflakeIdWorker.getInstance().newId();
                    Map<String,Object> params = Maps.newHashMap();
                    params.put("messageId",analyzeMessageId);
                    AgileDataFileDTO agileDataFile = echoService.getAgileDataFile(params,event.getUser().getToken(),event.getUser().getTenantId());
                    if(agileDataFile != null){
                        AgileDataFileDTO.AgileDataFileGenerateDTO pptInfo = agileDataFile.getPptInfo().stream().findFirst().orElse(null);
                        if(pptInfo != null){
                            generateSerialNo = pptInfo.getPptId();
                        }
                    }
                    //将PPTID绑定到指定消息中
                    AgileDataFileDTO agileDataFileDTO = new AgileDataFileDTO();
                    agileDataFileDTO.setMessageId(analyzeMessageId);
                    List<AgileDataFileDTO.AgileDataFileGenerateDTO> pptInfo = Lists.newArrayList();
                    agileDataFileDTO.setPptInfo(pptInfo);
                    AgileDataFileDTO.AgileDataFileGenerateDTO pptGenerateDTO = new AgileDataFileDTO.AgileDataFileGenerateDTO();
                    pptGenerateDTO.setPptId(generateSerialNo);
                    pptInfo.add(pptGenerateDTO);
                    echoService.updateAgileDataFile(agileDataFileDTO, event.getUser().getToken(), event.getUser().getTenantId());
                    //发送指定消息
                    Map<String,Object> msgBody = Maps.newHashMap();
                    msgBody.put("pptId",generateSerialNo);
                    semcService.sendMessageToGpt(event, msgBody);
                } else {
                    semcService.sendMessageToGpt(event, Maps.newHashMap());
                }
                break;
            default:
                break;
        }
    }
}
