package com.digiwin.athena.adt.sse.utils;


import com.digiwin.athena.adt.sse.domain.EventData;
import com.digiwin.athena.adt.sse.domain.SseAniaEventEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;

/**
 * SSE执行动作
 */
@Slf4j
public class SseEmitterUtils {

    private SseEmitterUtils() {
    }

    /**
     * 通过SSE，推送消息
     * @param sseEmitter
     * @param eventData
     */
    public static void send(SseEmitter sseEmitter, EventData eventData){
        try {
            if(Objects.nonNull(eventData.getData())){
                sseEmitter.send(SseEmitter.event().id(eventData.getEventId()).name(eventData.getEvent()).data(eventData.getData()));
            }else {
                sseEmitter.send(SseEmitter.event().id(eventData.getEventId()).name(eventData.getEvent()).data(new HashMap<>(0)));
            }
        } catch (IOException e){
            //捕获异常，断开连接
            log.info("发送娜娜事件，出现异常，异常信息：{}",e.getMessage());
            sseEmitter.complete();
        }

    }

    /**
     * 中止对话
     * @param sseEmitter
     */
    public static void sendChatErrorComplete(SseEmitter sseEmitter) {
        EventData completed = new EventData(SseAniaEventEnum.CHAT_COMPLETED.getEvent(), null);
        SseEmitterUtils.send(sseEmitter, completed);
    }

    /**
     * 完成对话
     * @param sseEmitter
     * @param success
     */
    public static void sendAnswerDone(SseEmitter sseEmitter,boolean success){
        EventData eventData = new EventData(success ? SseAniaEventEnum.CHAT_DONE.getEvent() : SseAniaEventEnum.CHAT_FAILED.getEvent(), null);
        SseEmitterUtils.send(sseEmitter, eventData);
    }



}
