package com.digiwin.athena.adt.util;

import lombok.extern.slf4j.Slf4j;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author: SunHong
 * @Date: 2024/5/20 15:02
 * @Description: 转换类
 */
@Slf4j
public class CommonUtil {

    /**
     * java对象转 map
     * @param obj 入参
     * @return  Map<String, Object>
     */
    public static Map<String, Object> convertObjectToMap(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            Map<String, Object> map = new java.util.HashMap<>();
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (PropertyDescriptor property : propertyDescriptors) {
                String key = property.getName();
                if (!key.equals("class")) {
                    Object value = property.getReadMethod().invoke(obj);
                    map.put(key, value);
                }
            }
            return map;
        } catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("CommonUtil convertObjectToMap 转换错误 ");
        }
    }

    /**
     * java list 对象转 List<Map<String, Object>>
     * @param obj 入参
     * @return  List<Map<String, Object>>
     */
    public static List<Map<String, Object>> convertListToMapList(Object obj) {
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof List)) {
            return null;
        }
        List<?> list = (List<?>) obj;
        return list.stream()
                .map(CommonUtil::convertObjectToMap)
                .collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }


    /**
     * map 转 java 对象
     * @param map 入参 clazz 转换类
     * @return  T
     */
    public static <T> T mapToObject(Map<String, Object> map, Class<T> clazz) {
        if (map == null || clazz == null) {
            return null;
        }
        try {
            T obj = clazz.getDeclaredConstructor().newInstance();
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (PropertyDescriptor property : propertyDescriptors) {
                String key = property.getName();
                if (map.containsKey(key)) {
                    property.getWriteMethod().invoke(obj, map.get(key));
                }
            }
            return obj;
        } catch (IntrospectionException | IllegalAccessException | InstantiationException | InvocationTargetException | NoSuchMethodException e) {
            throw new IllegalArgumentException("CommonUtil mapToObject 转换错误 ");
        }
    }

    /**
     * mapList 转 java list  对象
     * @param mapList 入参 clazz 转换类
     * @return  T
     */
    public static <T> List<T> mapListToObjectList(List<Map<String, Object>> mapList, Class<T> clazz) {
        if (mapList == null || clazz == null) {
            return null;
        }
        return mapList.stream()
                .map(map -> CommonUtil.mapToObject(map, clazz))
                .collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    /**
     * object to list string
     * @param value object
     * @return List<String>
     */
    public static List<String> objConvertListString(Object value) {
        if (Objects.isNull(value)) {
            return Collections.emptyList();
        }
        if (value instanceof List) {
            return ((List<?>) value).stream()
                    .map(Object::toString)
                    .collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

}
