package com.digiwin.athena.adt.util;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Optional;

/**
 * @Author: SunHong
 * @Date: 2024/5/8 17:24
 * @Description: 时间日期转换公共类
 */
public class DateUtils {

    /**
     * 转换时间差保留3位毫秒
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @return 秒 + 毫秒
     */
    public static String  calculateAndSetDuration(LocalDateTime startTime, LocalDateTime endTime) {
        Optional<LocalDateTime> askTimeOptional = Optional.ofNullable(startTime);
        Optional<LocalDateTime> answerTimeOptional = Optional.ofNullable(endTime);
        if (askTimeOptional.isPresent() && answerTimeOptional.isPresent()) {
            Duration duration = Duration.between(askTimeOptional.get(), answerTimeOptional.get());
            long seconds = duration.getSeconds();
            long millis = duration.toMillis() % 1000;
           return seconds + "." + millis;
        }
        return "startTime or endTime is null";
    }
}
