package com.digiwin.athena.adt.util.agileData;

import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.schema.SchemaMetricShowDefine;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class AgileDataSnapShotUtils {

    public static String getTile(SnapShotDTO snapShotDTO){
        AtomicReference<String> title = new AtomicReference<>("");
        if(snapShotDTO.getContext() != null && snapShotDTO.getContext().getBizParams().getShowDefine() != null){
            Map<String,Object> showMap = snapShotDTO.getContext().getBizParams().getShowDefine();
            List<Map<String,Object>> showList = (List<Map<String,Object>>) showMap.get("showType");
            if(CollectionUtils.isEmpty(showList)){
                return title.get();
            }
            showList.stream().forEach(show -> {
                List<Map<String,Object>> showTypeList = (List<Map<String,Object>>) showMap.get("showType");
                if(CollectionUtils.isEmpty(showTypeList)){
                    return;
                }
                showTypeList.stream().forEach(showType -> {
                    List<Map<String,Object>> typeList = (List<Map<String,Object>>) showType.get("type");
                    if(CollectionUtils.isEmpty(typeList)){
                        return;
                    }
                    typeList.stream().forEach(type -> title.set(MapUtils.getString(type, "title")));
                });


            });
        }

        return title.get();
    }

    public static String getTile(SchemaMetricShowDefine showDefine){
        AtomicReference<String> title = new AtomicReference<>("");
        if(showDefine != null){
            List<SchemaMetricShowDefine.ShowType> showList = showDefine.getShowType();
            if(CollectionUtils.isEmpty(showList)){
                return title.get();
            }
            showList.stream().forEach(show -> {
                List<SchemaMetricShowDefine.ShowType.TypeItem> showTypeList = show.getType();
                if(CollectionUtils.isEmpty(showTypeList)){
                    return;
                }
                showTypeList.stream().forEach(showType -> title.set(showType.getTitle()));
            });
        }
        return title.get();
    }

}
