/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.config;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.dao.AgileDataConfigMapper;
import com.digiwin.athena.adt.agileReport.service.AgileDataProcessService;
import com.digiwin.athena.adt.domain.po.AgileDataConfig;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class AgileDataHandlerProcessor {
    @Autowired
    private ApplicationContext applicationContext;
    @Resource
    private AgileDataConfigMapper agileDataConfigMapper;
    private static final String DESIGNER = "designer";
    private static final String TARGET = "target";
    private static final String TENANT_ID = "tenant_id";
    protected static final Map<AgileDataEnum, Class<AgileDataProcessService>> SERVICE_HAND_MAP = new HashMap(2);

    public AgileDataProcessService getEnumServiceByType(Enum type) {
        Class strategyClass = (Class)SERVICE_HAND_MAP.get(type);
        if (strategyClass == null) {
            throw new IllegalArgumentException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5b9e\u73b0");
        }
        return (AgileDataProcessService)this.applicationContext.getBean(strategyClass);
    }

    public String getAgileDataByUserConfig(AuthoredUser user) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)TENANT_ID, (Object)user.getTenantId());
        AgileDataConfig agileDataConfig = (AgileDataConfig)this.agileDataConfigMapper.selectOne((Wrapper)queryWrapper);
        String serviceName = DESIGNER;
        if (agileDataConfig != null && StringUtils.isNotEmpty((CharSequence)agileDataConfig.getType()) && (TARGET.equals(agileDataConfig.getType()) || DESIGNER.equals(agileDataConfig.getType()))) {
            serviceName = agileDataConfig.getType();
        }
        return serviceName;
    }
}

