/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.controller.assist;

import com.digiwin.athena.adt.agileReport.service.AgileDataAssistTroubleService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.google.common.eventbus.AsyncEventBus;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ai/assist"})
public class AgileDataAssistTroubleController {
    @Autowired
    private AsyncEventBus asyncEventBus;
    @Autowired
    private AgileDataAssistTroubleService agileDataAssistTroubleService;

    @GetMapping(value={"/data/getADEParams/{message}"})
    public ResponseEntity<?> getSnapShotData(HttpServletRequest request, @PathVariable(value="message") String message, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return this.getData(request, message, null, user);
    }

    @Deprecated
    @PostMapping(value={"/data/getADEParams"})
    public ResponseEntity<?> getADEParams(HttpServletRequest request, @RequestBody Map<String, Object> params, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        String message = MapUtils.getString(params, (Object)"message");
        String sceneCode = MapUtils.getString(params, (Object)"sceneCode");
        return this.getData(request, message, sceneCode, user);
    }

    public ResponseEntity<?> getData(HttpServletRequest request, String message, String sceneCode, AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.agileDataAssistTroubleService.getAssistTroubleData(request, message, sceneCode, user));
    }

    @GetMapping(value={"/monitor/eventBus"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> monitorEventBus() {
        HashMap<String, String> monitorMap = new HashMap<String, String>();
        try {
            Field[] fields;
            Field executorField = this.asyncEventBus.getClass().getSuperclass().getDeclaredField("executor");
            executorField.setAccessible(true);
            Executor executor = (Executor)executorField.get(this.asyncEventBus);
            for (Field temp : fields = executor.getClass().getDeclaredFields()) {
                temp.setAccessible(true);
                monitorMap.put(temp.getName(), temp.get(executor).toString());
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return ResponseEntityWrapper.wrapperOk(monitorMap);
    }
}

