/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.controller.dto;

import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnalysisFluctuateReqDTO
implements Serializable {
    private static final Logger log = LogManager.getLogger(AnalysisFluctuateReqDTO.class);
    private String snapshotId;
    private Map<String, Object> processStreamData;
    private String question;
    private List<String> datasetIds;
    private Map<String, Object> metric;
    private List<Map<String, Object>> dimension;
    private String step;
    private Map<String, Object> solutionStep;
    private String appCode;
    private String lang;
    private Map<String, Object> orgOutPutSql;
    private String questionDate;
    private List<Map<String, Object>> pullData;

    public static AnalysisFluctuateReqDTO builderQuery(AnalysisFluctuateReqDTO req, SnapShotDTO orgSnapshotDTO) {
        AnalysisFluctuateReqDTO res = new AnalysisFluctuateReqDTO();
        try {
            Map step = new HashMap();
            if (Objects.nonNull(req.getProcessStreamData()) && Objects.nonNull(req.getProcessStreamData().get("questionWay"))) {
                step = (Map)req.getProcessStreamData().get("questionWay");
            }
            List datasetIdList = orgSnapshotDTO.getContext().getBizParams().getDatasetList().stream().map(map -> String.valueOf(map.get("datasetId"))).collect(Collectors.toList());
            LocalDateTime questionDate = orgSnapshotDTO.getContext().getBizParams().getRequestTime();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            res.setDatasetIds(datasetIdList);
            res.setStep(String.valueOf(step.get("content")));
            res.setQuestion(orgSnapshotDTO.getContext().getBizParams().getQuestion());
            res.setQuestionDate(questionDate.format(formatter));
            res.setOrgOutPutSql(req.getOrgOutPutSql());
            res.setDimension(req.getDimension());
            res.setMetric(req.getMetric());
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u6ce2\u52a8\u8f6c\u6362\u8bed\u4e49\u5165\u53c2\u5931\u8d25:{}", (Object)e.getMessage());
        }
        return res;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public Map<String, Object> getProcessStreamData() {
        return this.processStreamData;
    }

    public String getQuestion() {
        return this.question;
    }

    public List<String> getDatasetIds() {
        return this.datasetIds;
    }

    public Map<String, Object> getMetric() {
        return this.metric;
    }

    public List<Map<String, Object>> getDimension() {
        return this.dimension;
    }

    public String getStep() {
        return this.step;
    }

    public Map<String, Object> getSolutionStep() {
        return this.solutionStep;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public String getLang() {
        return this.lang;
    }

    public Map<String, Object> getOrgOutPutSql() {
        return this.orgOutPutSql;
    }

    public String getQuestionDate() {
        return this.questionDate;
    }

    public List<Map<String, Object>> getPullData() {
        return this.pullData;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public void setProcessStreamData(Map<String, Object> processStreamData) {
        this.processStreamData = processStreamData;
    }

    public void setQuestion(String question2) {
        this.question = question2;
    }

    public void setDatasetIds(List<String> datasetIds) {
        this.datasetIds = datasetIds;
    }

    public void setMetric(Map<String, Object> metric) {
        this.metric = metric;
    }

    public void setDimension(List<Map<String, Object>> dimension) {
        this.dimension = dimension;
    }

    public void setStep(String step) {
        this.step = step;
    }

    public void setSolutionStep(Map<String, Object> solutionStep) {
        this.solutionStep = solutionStep;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void setOrgOutPutSql(Map<String, Object> orgOutPutSql) {
        this.orgOutPutSql = orgOutPutSql;
    }

    public void setQuestionDate(String questionDate) {
        this.questionDate = questionDate;
    }

    public void setPullData(List<Map<String, Object>> pullData) {
        this.pullData = pullData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnalysisFluctuateReqDTO)) {
            return false;
        }
        AnalysisFluctuateReqDTO other = (AnalysisFluctuateReqDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$snapshotId = this.getSnapshotId();
        String other$snapshotId = other.getSnapshotId();
        if (this$snapshotId == null ? other$snapshotId != null : !this$snapshotId.equals(other$snapshotId)) {
            return false;
        }
        Map this$processStreamData = this.getProcessStreamData();
        Map other$processStreamData = other.getProcessStreamData();
        if (this$processStreamData == null ? other$processStreamData != null : !((Object)this$processStreamData).equals(other$processStreamData)) {
            return false;
        }
        String this$question = this.getQuestion();
        String other$question = other.getQuestion();
        if (this$question == null ? other$question != null : !this$question.equals(other$question)) {
            return false;
        }
        List this$datasetIds = this.getDatasetIds();
        List other$datasetIds = other.getDatasetIds();
        if (this$datasetIds == null ? other$datasetIds != null : !((Object)this$datasetIds).equals(other$datasetIds)) {
            return false;
        }
        Map this$metric = this.getMetric();
        Map other$metric = other.getMetric();
        if (this$metric == null ? other$metric != null : !((Object)this$metric).equals(other$metric)) {
            return false;
        }
        List this$dimension = this.getDimension();
        List other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !((Object)this$dimension).equals(other$dimension)) {
            return false;
        }
        String this$step = this.getStep();
        String other$step = other.getStep();
        if (this$step == null ? other$step != null : !this$step.equals(other$step)) {
            return false;
        }
        Map this$solutionStep = this.getSolutionStep();
        Map other$solutionStep = other.getSolutionStep();
        if (this$solutionStep == null ? other$solutionStep != null : !((Object)this$solutionStep).equals(other$solutionStep)) {
            return false;
        }
        String this$appCode = this.getAppCode();
        String other$appCode = other.getAppCode();
        if (this$appCode == null ? other$appCode != null : !this$appCode.equals(other$appCode)) {
            return false;
        }
        String this$lang = this.getLang();
        String other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !this$lang.equals(other$lang)) {
            return false;
        }
        Map this$orgOutPutSql = this.getOrgOutPutSql();
        Map other$orgOutPutSql = other.getOrgOutPutSql();
        if (this$orgOutPutSql == null ? other$orgOutPutSql != null : !((Object)this$orgOutPutSql).equals(other$orgOutPutSql)) {
            return false;
        }
        String this$questionDate = this.getQuestionDate();
        String other$questionDate = other.getQuestionDate();
        if (this$questionDate == null ? other$questionDate != null : !this$questionDate.equals(other$questionDate)) {
            return false;
        }
        List this$pullData = this.getPullData();
        List other$pullData = other.getPullData();
        return !(this$pullData == null ? other$pullData != null : !((Object)this$pullData).equals(other$pullData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnalysisFluctuateReqDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $snapshotId = this.getSnapshotId();
        result = result * 59 + ($snapshotId == null ? 43 : $snapshotId.hashCode());
        Map $processStreamData = this.getProcessStreamData();
        result = result * 59 + ($processStreamData == null ? 43 : ((Object)$processStreamData).hashCode());
        String $question = this.getQuestion();
        result = result * 59 + ($question == null ? 43 : $question.hashCode());
        List $datasetIds = this.getDatasetIds();
        result = result * 59 + ($datasetIds == null ? 43 : ((Object)$datasetIds).hashCode());
        Map $metric = this.getMetric();
        result = result * 59 + ($metric == null ? 43 : ((Object)$metric).hashCode());
        List $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : ((Object)$dimension).hashCode());
        String $step = this.getStep();
        result = result * 59 + ($step == null ? 43 : $step.hashCode());
        Map $solutionStep = this.getSolutionStep();
        result = result * 59 + ($solutionStep == null ? 43 : ((Object)$solutionStep).hashCode());
        String $appCode = this.getAppCode();
        result = result * 59 + ($appCode == null ? 43 : $appCode.hashCode());
        String $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        Map $orgOutPutSql = this.getOrgOutPutSql();
        result = result * 59 + ($orgOutPutSql == null ? 43 : ((Object)$orgOutPutSql).hashCode());
        String $questionDate = this.getQuestionDate();
        result = result * 59 + ($questionDate == null ? 43 : $questionDate.hashCode());
        List $pullData = this.getPullData();
        result = result * 59 + ($pullData == null ? 43 : ((Object)$pullData).hashCode());
        return result;
    }

    public String toString() {
        return "AnalysisFluctuateReqDTO(snapshotId=" + this.getSnapshotId() + ", processStreamData=" + this.getProcessStreamData() + ", question=" + this.getQuestion() + ", datasetIds=" + this.getDatasetIds() + ", metric=" + this.getMetric() + ", dimension=" + this.getDimension() + ", step=" + this.getStep() + ", solutionStep=" + this.getSolutionStep() + ", appCode=" + this.getAppCode() + ", lang=" + this.getLang() + ", orgOutPutSql=" + this.getOrgOutPutSql() + ", questionDate=" + this.getQuestionDate() + ", pullData=" + this.getPullData() + ")";
    }
}

