/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.controller.report;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSendNanaReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSpecialUploadReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSummarizeReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AnalysisAttributionReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AnalysisFluctuateReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AniaAssistantChatReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AthenaMessageDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.ChatReqAIBoardDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.ChatReqPPTReqDTO;
import com.digiwin.athena.adt.agileReport.service.SnapShotCommonService;
import com.digiwin.athena.adt.agileReport.service.impl.process.schema.SchemaDataProcessSpecialLiteServiceImpl;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.report.AgileReportDataService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@RequestMapping(value={"/api/ai/agileData"})
public class AgileReportDataProcessController {
    @Autowired
    private SnapShotCommonService snapShotCommonService;
    @Autowired
    private AgileReportDataService agileReportDataService;
    @Autowired
    private SchemaDataProcessSpecialLiteServiceImpl schemaDataProcessSpecialLiteService;

    @PostMapping(value={"/report/process"})
    public ResponseEntity<?> getSnapShot(@RequestBody SnapShotDTO snapShotDTO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Objects.requireNonNull(snapShotDTO, "\u4f20\u5165\u7684snapShotDTO\u4e3a\u7a7a\uff01");
        String snapDataJsonString = JsonUtils.objectToString((Object)snapShotDTO);
        this.snapShotCommonService.processAndSaveSnapShotData(snapDataJsonString, snapShotDTO, user);
        return ResponseEntityWrapper.wrapperOk((Object)"\u63a5\u6536\u6210\u529f");
    }

    @PostMapping(value={"/snapData/processMessage"})
    public ResponseEntity<?> getResultResponse(HttpServletRequest request, @RequestBody AthenaMessageDTO athenaMessageDTO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Objects.requireNonNull(athenaMessageDTO, "\u4f20\u5165\u7684athenaMessageDTO\u4e3a\u7a7a\uff01");
        return ResponseEntityWrapper.wrapperOk((Object)this.agileReportDataService.processMessage(request, athenaMessageDTO, user));
    }

    @PostMapping(value={"dataPanel/processMessage"})
    public ResponseEntity<?> panelFlagShipProcessMessage(HttpServletRequest request, @RequestBody AthenaMessageDTO req, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Objects.requireNonNull(req, "\u4f20\u5165\u7684agileDataPanelReqDTO\u4e3a\u7a7a\uff01");
        return ResponseEntityWrapper.wrapperOk((Object)this.agileReportDataService.panelProcessMessage(request, req, user));
    }

    @PostMapping(value={"/v2/dataPanel/processMessage"})
    public ResponseEntity<?> panelProcessMessage(HttpServletRequest request, @RequestBody AniaAssistantChatReqDTO req, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Objects.requireNonNull(req, "\u4f20\u5165\u76842.0\u770b\u677f\u8bf7\u6c42\u5165\u53c2\u4e3a\u7a7a\uff01");
        return ResponseEntityWrapper.wrapperOk((Object)this.agileReportDataService.panelFlagShipProcessMessage(request, req, user));
    }

    @PostMapping(value={"/mcp/processMessage"})
    public ResponseEntity<?> mcpProcessMessage(HttpServletRequest request, @RequestBody AniaAssistantChatReqDTO req, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Objects.requireNonNull(req, "\u4f20\u5165\u7684mcp\u6d88\u606f\u5904\u7406\u8bf7\u6c42\u5165\u53c2\u4e3a\u7a7a\uff01");
        return ResponseEntityWrapper.wrapperOk((Object)this.agileReportDataService.mcpProcessMessage(request, req, user));
    }

    @PostMapping(value={"/lite/processMessage"})
    public ResponseEntity<?> liteProcessMessage(@RequestBody AgileDataSpecialUploadReqDTO req, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Objects.requireNonNull(req, "\u4f20\u5165\u7684AgileDataSpecialUploadReqDTO\u4e3a\u7a7a\uff01");
        return ResponseEntityWrapper.wrapperOk((Object)this.schemaDataProcessSpecialLiteService.liteUploadProcessMessage(req, user));
    }

    @PostMapping(value={"/lite/sendNanaMessage"})
    public ResponseEntity<?> sendNanaMessage(@RequestBody AgileDataSendNanaReqDTO req, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Objects.requireNonNull(req, "\u4f20\u5165\u7684AgileDataSendNanaReqDTO\u4e3a\u7a7a\uff01");
        this.schemaDataProcessSpecialLiteService.sendNanaMessage(req, user);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/sse/snapData/processMessage"}, produces={"text/event-stream"})
    public SseEmitter sseProcessMessage(HttpServletRequest request, @RequestBody AthenaMessageDTO athenaMessageDTO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Objects.requireNonNull(athenaMessageDTO, "\u4f20\u5165\u7684athenaMessageDTO\u4e3a\u7a7a\uff01");
        return this.agileReportDataService.sseProcessMessage(request, athenaMessageDTO, user);
    }

    @PostMapping(value={"/assistant/chat"}, produces={"text/event-stream"})
    public SseEmitter sseProcessMessageV2(HttpServletRequest request, @RequestBody AniaAssistantChatReqDTO aniaAssistantChatReqDTO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Objects.requireNonNull(aniaAssistantChatReqDTO, "\u4f20\u5165\u7684aniaAssistantChatReqDTO\u4e3a\u7a7a\uff01");
        return this.agileReportDataService.sseProcessMessageV2(request, aniaAssistantChatReqDTO, user);
    }

    @PostMapping(value={"sse/chat"}, produces={"text/event-stream"})
    public SseEmitter sseAgileData(HttpServletRequest request, @RequestBody AniaAssistantChatReqDTO aniaAssistantChatReqDTO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Objects.requireNonNull(aniaAssistantChatReqDTO, "\u4f20\u5165\u7684aniaAssistantChatReqDTO\u4e3a\u7a7a\uff01");
        return this.agileReportDataService.sseAgileData(request, aniaAssistantChatReqDTO, user);
    }

    @GetMapping(value={"/queryDetail/{snapshotId}"})
    public ResponseEntity<?> getExceptionInfoByMessageId(HttpServletRequest request, @PathVariable(value="snapshotId") String snapshotId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        String locale = request.getHeader("locale");
        return ResponseEntityWrapper.wrapperOk((Object)this.agileReportDataService.getDataDetailUrl(user, snapshotId, locale));
    }

    @PostMapping(value={"/snapData/getAgileDataSummarize"})
    public ResponseEntity<?> getAgileDataSummarize(@RequestBody AgileDataSummarizeReqDTO agileDataSummarizeReqDTO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Objects.requireNonNull(agileDataSummarizeReqDTO, "agileDataSummarizeReqDTO\uff01");
        return ResponseEntityWrapper.wrapperOk((Object)this.agileReportDataService.getAgileDataSummarize(agileDataSummarizeReqDTO, user));
    }

    @GetMapping(value={"/getAppVersion/{appCode}"})
    public ResponseEntity<?> getAppVersion(@PathVariable(value="appCode") String appCode, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.agileReportDataService.getAppVersion(user, appCode));
    }

    @CrossOrigin
    @PostMapping(value={"/v2/filter/processMessage"})
    public ResponseEntity<?> filterProcessMessage(HttpServletRequest request, @RequestBody AniaAssistantChatReqDTO req, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Objects.requireNonNull(req, "\u4e8c\u6b21\u53d6\u6570\u5165\u53c2\u4e3a\u7a7a\uff01");
        return ResponseEntityWrapper.wrapperOk((Object)this.agileReportDataService.filterProcessMessage(request, req, user));
    }

    @CrossOrigin
    @PostMapping(value={"/v2/analysis/fluctuate"})
    public ResponseEntity<?> analysisFluctuateProcess(HttpServletRequest request, @RequestBody AnalysisFluctuateReqDTO req, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Objects.requireNonNull(req, "\u4e8c\u6b21\u53d6\u6570\u5165\u53c2\u4e3a\u7a7a\uff01");
        return ResponseEntityWrapper.wrapperOk((Object)this.agileReportDataService.analysisFluctuateProcess(request, req, user));
    }

    @CrossOrigin
    @PostMapping(value={"/v2/analysis/attribution"})
    public ResponseEntity<?> analysisAttributionProcess(HttpServletRequest request, @RequestBody AnalysisAttributionReqDTO req, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Objects.requireNonNull(req, "\u4e8c\u6b21\u53d6\u6570\u5165\u53c2\u4e3a\u7a7a\uff01");
        return ResponseEntityWrapper.wrapperOk((Object)this.agileReportDataService.analysisAttributionProcess(request, req, user));
    }

    @CrossOrigin
    @PostMapping(value={"/v2/chat/ppt"})
    public ResponseEntity<?> chatPPts(HttpServletRequest request, @RequestBody ChatReqPPTReqDTO req, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Objects.requireNonNull(req, "ppt \u95ee\u53e5\u89e3\u6790 \u5165\u53c2\u4e3a\u7a7a\uff01");
        this.agileReportDataService.chatPPts(request, req, user);
        return ResponseEntityWrapper.wrapperOk();
    }

    @CrossOrigin
    @PostMapping(value={"/v2/chat/aiBoard"})
    public ResponseEntity<?> chatAiBoard(HttpServletRequest request, @RequestBody ChatReqAIBoardDTO req, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Objects.requireNonNull(req, "\u5bf9\u8bdd\u770b\u677f \u95ee\u53e5\u89e3\u6790 \u5165\u53c2\u4e3a\u7a7a\uff01");
        this.agileReportDataService.chatAIBoard(request, req, user);
        return ResponseEntityWrapper.wrapperOk();
    }
}

