/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.event.service.impl;

import com.digiwin.athena.adt.agileReport.event.domain.EventReportDataDTO;
import com.digiwin.athena.adt.agileReport.event.service.EventInterface;
import com.digiwin.athena.adt.agileReport.service.SnapShotDataService;
import com.digiwin.athena.adt.domain.dmc.DmcService;
import com.digiwin.athena.adt.domain.dto.agileReport.PullDataDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.aim.AimBuildReqDTO;
import com.digiwin.athena.adt.domain.po.SnapData;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.adt.util.message.AgileDataMessageUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.restful.aim.AimService;
import com.digiwin.athena.atmc.http.restful.iam.UserService;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportEventImpl
implements EventInterface {
    private static final Logger log = LoggerFactory.getLogger(ReportEventImpl.class);
    @Autowired
    private SnapShotDataService snapShotDataService;
    @Autowired
    private AimService aimService;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private UserService userService;
    @Autowired
    private DmcService dmcService;

    public String modelType() {
        return "athena.event.message.adt";
    }

    public void distributeMessages(String data, Map<String, Object> headers) {
        EventReportDataDTO eventReportDataDTO = (EventReportDataDTO)JsonUtils.jsonToObject((String)data, EventReportDataDTO.class);
        if (eventReportDataDTO != null) {
            this.executeReport(eventReportDataDTO);
        }
    }

    public void executeReport(EventReportDataDTO mqData) {
        log.info("executeReport EventReportDataDTO req : {}", (Object)JsonUtils.objectToString((Object)mqData));
        List snapDataList = this.snapShotDataService.getSnapShotUserList(mqData.getSnapshotId());
        LogDto dataLogDto = new LogDto("\u67e5\u8be2\u5feb\u7167\u6570\u636e\uff1a" + snapDataList);
        log.info(dataLogDto.toString());
        if (CollectionUtils.isEmpty((Collection)snapDataList)) {
            return;
        }
        for (SnapData snapData : snapDataList) {
            AuthoredUser authoredUser = new AuthoredUser();
            authoredUser.setUserName(snapData.getUserName());
            authoredUser.setUserId(snapData.getPerformerId());
            authoredUser.setTenantId(snapData.getTenantId());
            authoredUser.setToken(mqData.getToken());
            SnapShotDTO snapShotDTO = this.dmcService.getAgileDataByToken(snapData.getDmcId(), mqData.getToken());
            if (null == snapShotDTO || StringUtils.isEmpty((CharSequence)snapShotDTO.getContext().getBizParams().getQuestion())) {
                return;
            }
            if (snapData.getEntry() == 0) {
                this.aimService.message(authoredUser, AgileDataMessageUtils.buildDetectionMessage((SnapData)snapData, (AuthoredUser)authoredUser));
                continue;
            }
            if (snapData.getEntry() == 2) {
                AimBuildReqDTO aimBuildReqDTO = AimBuildReqDTO.builderAimReqDTO((AuthoredUser)authoredUser, (SnapData)snapData, (UserService)this.userService, (MessageUtil)this.messageUtil);
                String chartTitle = MapUtils.getString((Map)snapShotDTO.getContext().getBizParams().getParam(), (Object)"chartTitle");
                if (StringUtils.isNotEmpty((CharSequence)chartTitle)) {
                    aimBuildReqDTO.setChartTitle(chartTitle);
                }
                aimBuildReqDTO.setQuestion(snapShotDTO.getContext().getBizParams().getQuestion());
                String method = snapShotDTO.getContext().getBizParams().getMethod();
                if (CollectionUtils.isNotEmpty((Collection)snapShotDTO.getContext().getPullData())) {
                    List metricList = ((PullDataDTO)snapShotDTO.getContext().getPullData().get(0)).getMetricList();
                    aimBuildReqDTO.setMetricList(metricList);
                    List datasetList = ((PullDataDTO)snapShotDTO.getContext().getPullData().get(0)).getDatasetList();
                    aimBuildReqDTO.setDatasetList(datasetList);
                }
                Object undeleteTable = snapShotDTO.getContext().getBizParams().getParam().get("undeletable");
                String isProcessStr = snapShotDTO.getContext().getBizParams().getDataProcessAction();
                String asaCode = MapUtils.getString((Map)snapShotDTO.getContext().getBizParams().getParam(), (Object)"asaCode");
                String ruleId = MapUtils.getString((Map)snapShotDTO.getContext().getBizParams().getParam(), (Object)"ruleId");
                List stepAnalysis = snapShotDTO.getContext().getStepAnalysis();
                List stepFilterAnalysis = snapShotDTO.getContext().getStepFilterAnalysis();
                aimBuildReqDTO.setRuleId(ruleId);
                aimBuildReqDTO.setAsaCode(asaCode);
                aimBuildReqDTO.setStepAnalysis(stepAnalysis);
                aimBuildReqDTO.setStepFilterAnalysis(stepFilterAnalysis);
                Integer interceptionSize = snapShotDTO.getContext().getBizParams().getInterceptSize();
                if (Objects.nonNull(isProcessStr) && "interception".equals(isProcessStr)) {
                    String dataTipMessage = this.messageUtil.getMessageByLangNameWithFormat("message.adt.message.page", aimBuildReqDTO.getUserLang(), new Object[]{interceptionSize});
                    aimBuildReqDTO.setDataTipMessage(dataTipMessage);
                }
                aimBuildReqDTO.setMethod(StringUtils.isEmpty((CharSequence)method) ? "dataflow" : method);
                aimBuildReqDTO.setUndeletable(!Objects.isNull(undeleteTable) && (Boolean)undeleteTable != false);
                List message = AgileDataMessageUtils.buildAgileSubscribeMessage((AimBuildReqDTO)aimBuildReqDTO);
                log.info("aimService.saveNewMessage req : {}", (Object)JsonUtils.objectToString((Object)message));
                this.aimService.saveNewMessage(authoredUser, message);
                continue;
            }
            return;
        }
    }

    public void consumeMessage(String data, Channel channel, long tag) throws IOException {
    }
}

