/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.eventbus.subscriber;

import com.digiwin.athena.adt.agileReport.eventbus.AgileDataLogEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataMessageLogEventService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.google.common.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AgileDataLogEventSubscriber {
    private static final Logger log = LoggerFactory.getLogger(AgileDataLogEventSubscriber.class);
    @Autowired
    private AgileDataMessageLogEventService agileDataMessageLogEventService;

    @Subscribe
    public void subscriber(AgileDataLogEvent event) {
        try {
            AppAuthContextHolder.clearContext();
            this.processEvent(event);
        }
        catch (Exception ex) {
            log.error("\u654f\u6377\u6570\u636e\u65e5\u5fd7\u6267\u884c\u5f02\u5e38 error:{}, stack:{}\uff0cevent:{}", new Object[]{ex, ex.getStackTrace(), event});
        }
        finally {
            AppAuthContextHolder.clearContext();
        }
    }

    private void processEvent(AgileDataLogEvent event) {
        this.agileDataMessageLogEventService.processLog(event);
    }
}

