/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
public class EventBaseService {
    private static final Logger log = LoggerFactory.getLogger(EventBaseService.class);
    @Autowired
    protected RabbitTemplate rabbitTemplate;
    @Autowired
    protected EnvProperties envProperties;
    @Autowired
    @Qualifier(value="mongoTemplate")
    private MongoTemplate apiLogMongoTemplate;
    private static final String MONGODB_COLLECTION_NAME = "AbtEvent_Log";
    private static final String EXECPTION_RETRY_COUNT = "execption-retry-count";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveOrder(String data, String queueName, Channel channel, long tag, Map<String, Object> headers) throws IOException {
        boolean successed;
        log.info("[athena.event.message.adt-data]: queueName = {} , processMessage data = {}", (Object)queueName, (Object)data);
        Integer retryCount = 0;
        try {
            if ("TRADITIONAL_CHINESE".equals(this.envProperties.getDefaultLanguage())) {
                LocaleContextHolder.setLocale((Locale)Locale.TRADITIONAL_CHINESE);
            } else {
                LocaleContextHolder.setLocale((Locale)Locale.SIMPLIFIED_CHINESE);
            }
            this.processMessage(data, queueName, headers);
            successed = true;
        }
        catch (Exception e) {
            log.error("[{}.error] error:{}, stack:{}, data:{}", new Object[]{queueName, e, e.getStackTrace(), data});
            successed = false;
            retryCount = this.retryBpmMessage(data, e);
        }
        finally {
            AppAuthContextHolder.clearContext();
        }
        if (successed || retryCount >= this.envProperties.getBpmMqRetryCount()) {
            channel.basicAck(tag, false);
        } else {
            channel.basicReject(tag, true);
        }
    }

    public void processMessage(String data, String queueName, Map<String, Object> headers) {
    }

    private Integer retryBpmMessage(String data, Exception e) {
        Integer retryCount = 1;
        try {
            String exceptionMessage = e.toString();
            int messageId = data.hashCode();
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"execption-message-id").is((Object)messageId));
            query.fields().include(EXECPTION_RETRY_COUNT);
            Map log = (Map)this.apiLogMongoTemplate.findOne(query, Map.class, MONGODB_COLLECTION_NAME);
            if (log != null) {
                retryCount = (Integer)log.get(EXECPTION_RETRY_COUNT);
                retryCount = retryCount + 1;
                query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is(log.get("_id")));
                Update update = new Update().set("execption-message", (Object)exceptionMessage).set(EXECPTION_RETRY_COUNT, (Object)retryCount).set("execption-modify-time", (Object)LocalDateTime.now());
                this.apiLogMongoTemplate.updateFirst(query, (UpdateDefinition)update, MONGODB_COLLECTION_NAME);
            } else {
                log = (Map)JsonUtils.jsonToObject((String)data, Map.class);
                log.put("execption-message", exceptionMessage);
                log.put("execption-message-id", messageId);
                log.put(EXECPTION_RETRY_COUNT, retryCount);
                log.put("execption-create-time", LocalDateTime.now());
                log.put("execption-modify-time", LocalDateTime.now());
                this.apiLogMongoTemplate.insert((Object)log, MONGODB_COLLECTION_NAME);
            }
        }
        catch (Exception ex) {
            log.error("[athena_event_message_abt_error] error: {}", (Throwable)ex);
            retryCount = this.envProperties.getBpmMqRetryCount() + 1;
        }
        return retryCount;
    }
}

