/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl;

import com.digiwin.athena.adt.agileReport.service.ChartSnapshotService;
import com.digiwin.athena.adt.domain.dto.mongo.AgileDataChartSnapshot;
import com.digiwin.athena.adt.domain.repository.mongo.AgileDataChartSnapshotRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ChartSnapshotServiceImpl
implements ChartSnapshotService {
    @Autowired
    @Qualifier(value="agileDataChartSnapshotRepository")
    private AgileDataChartSnapshotRepository repository;

    public void saveSnapshot(AgileDataChartSnapshot snapshot) {
        if (snapshot == null || StringUtils.isBlank((CharSequence)snapshot.getSnapshotId()) || StringUtils.isBlank((CharSequence)snapshot.getChartType())) {
            throw new IllegalArgumentException("snapshotId/chartType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (snapshot.getSnapshotContent() == null || snapshot.getSnapshotContent().isEmpty()) {
            throw new IllegalArgumentException("snapshotContent\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.repository.saveOrUpdate(snapshot);
    }

    public AgileDataChartSnapshot getBySnapshotId(String snapshotId, String chartType) {
        if (StringUtils.isBlank((CharSequence)snapshotId) || StringUtils.isBlank((CharSequence)chartType)) {
            throw new IllegalArgumentException("snapshotId/chartType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.repository.findBySnapshotIdAndChartType(snapshotId, chartType);
    }
}

