/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.ania;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.service.AniaAssistantService;
import com.digiwin.athena.adt.domain.dto.ania.AniaAssistantReqDTO;
import com.digiwin.athena.adt.domain.dto.ania.AniaAssistantResDTO;
import com.digiwin.athena.adt.domain.dto.ania.AniaVersionReqDTO;
import com.digiwin.athena.adt.domain.dto.ania.AniaVersionResDTO;
import com.digiwin.athena.adt.domain.dto.km.KMCommandIntentionsDTO;
import com.digiwin.athena.adt.domain.dto.km.KMDatasetCommandIntentionsResDTO;
import com.digiwin.athena.adt.domain.dto.mongo.AgileDataCustomConfig;
import com.digiwin.athena.adt.domain.knowledge.KmService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
public class AniaAssistantServiceImpl
implements AniaAssistantService {
    private static final Logger log = LogManager.getLogger(AniaAssistantServiceImpl.class);
    @Autowired
    private KmService kmService;
    @Autowired
    @Qualifier(value="mongoAgileDataLogTemplate")
    private MongoTemplate mongoTemplate;
    @Value(value="${adt.url:}")
    private String adtUrl;

    public AniaAssistantResDTO getPublishedInfo(AniaAssistantReqDTO req, AuthoredUser user) {
        List assistantReq = req.getAssistant();
        AniaAssistantResDTO res = new AniaAssistantResDTO();
        ArrayList<AniaAssistantResDTO.Assistant> assistantList = new ArrayList<AniaAssistantResDTO.Assistant>();
        for (AniaAssistantReqDTO.Assistant dto : assistantReq) {
            String appCode = dto.getAssistantId();
            String version = dto.getVersion();
            String appSystem = "";
            List commandIntentions = new ArrayList();
            List kmCommandIntentions = new ArrayList();
            AgileDataCustomConfig config = new AgileDataCustomConfig();
            KMDatasetCommandIntentionsResDTO cIData = this.kmService.dataSetCommandIntentions(user, appCode, version);
            int appType = 6;
            if (Objects.nonNull(cIData) && Objects.nonNull(cIData.getAppType())) {
                appType = cIData.getAppType();
                appSystem = cIData.getAppSystem();
            }
            AgileDataCustomConfig configReq = new AgileDataCustomConfig();
            configReq.setVersion(appType == 12 ? "V2" : "V1");
            List customConfigs = this.getMongoCustomConfig(configReq, user);
            if (CollectionUtils.isNotEmpty((Collection)customConfigs)) {
                config = (AgileDataCustomConfig)customConfigs.get(0);
            }
            if (6 == appType && AgileDataEnum.DATASET.getCode().equals(appSystem)) {
                kmCommandIntentions = this.kmService.queryCommandIntentions(user);
            } else if (Objects.nonNull(cIData) && CollectionUtils.isNotEmpty((Collection)cIData.getCommandIntentions())) {
                commandIntentions = cIData.getCommandIntentions();
            }
            AniaAssistantResDTO.Assistant assistant = AniaAssistantResDTO.Assistant.builderAssistant((String)version, (String)appCode, (KMDatasetCommandIntentionsResDTO)cIData, (AgileDataCustomConfig)config, (String)this.adtUrl, commandIntentions, kmCommandIntentions);
            assistantList.add(assistant);
        }
        res.setAssistant(assistantList);
        log.info("\u5a1c\u5a1c\u56de\u8c03\u67e5\u8be2\u53d1\u5e03\u51fa\u53c2:{}", (Object)JsonUtils.objectToString((Object)res));
        return res;
    }

    public void saveCustomConfig(AgileDataCustomConfig agileDataCustomConfig, AuthoredUser user) {
        String version = agileDataCustomConfig.getVersion();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        List results = this.mongoTemplate.find(query, AgileDataCustomConfig.class);
        if (CollectionUtils.isNotEmpty((Collection)results)) {
            Update update = new Update();
            update.set("pluginCustoms", (Object)agileDataCustomConfig.getPluginCustoms());
            this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, AgileDataCustomConfig.class);
        } else {
            this.mongoTemplate.insert((Object)agileDataCustomConfig);
        }
    }

    public List<AgileDataCustomConfig> getMongoCustomConfig(AgileDataCustomConfig agileDataCustomConfig, AuthoredUser user) {
        String version = agileDataCustomConfig.getVersion();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        return this.mongoTemplate.find(query, AgileDataCustomConfig.class);
    }

    public AniaVersionResDTO getVersion(AniaVersionReqDTO req, AuthoredUser user) {
        AniaVersionResDTO res = new AniaVersionResDTO();
        ArrayList<AniaAssistantResDTO.Assistant> assistant = new ArrayList<AniaAssistantResDTO.Assistant>();
        String version = this.kmService.getVersion(user);
        if (Objects.nonNull(version)) {
            AniaAssistantResDTO.Assistant versionBean = new AniaAssistantResDTO.Assistant();
            versionBean.setAssistantId(req.getAssistantId());
            versionBean.setVersion(version);
            assistant.add(versionBean);
        }
        res.setAssistant(assistant);
        return res;
    }

    public AniaAssistantResDTO getInspirationPhrases(AniaAssistantReqDTO req, AuthoredUser user) {
        List assistantReq = req.getAssistant();
        AniaAssistantResDTO result = new AniaAssistantResDTO();
        ArrayList<AniaAssistantResDTO.Assistant> assistantList = new ArrayList<AniaAssistantResDTO.Assistant>();
        for (AniaAssistantReqDTO.Assistant dto : assistantReq) {
            AniaAssistantResDTO.Assistant assistant = new AniaAssistantResDTO.Assistant();
            String appCode = dto.getAssistantId();
            KMDatasetCommandIntentionsResDTO cIData = this.kmService.dataSetCommandIntentions(user, appCode, "");
            List commandIntentions = new ArrayList();
            List phrases = new ArrayList();
            if (Objects.nonNull(cIData) && StringUtils.isNotEmpty((CharSequence)cIData.getName())) {
                int appType = cIData.getAppType();
                String appSystem = cIData.getAppSystem();
                if (6 == appType && AgileDataEnum.DATASET.getCode().equals(appSystem)) {
                    List kmCommandIntentions = this.kmService.queryCommandIntentions(user);
                    Map<String, List<KMCommandIntentionsDTO>> kmCommandIntentionMap = kmCommandIntentions.stream().filter(km -> km.getApplicationCode() != null && km.getApplicationCode().equals(appCode)).collect(Collectors.groupingBy(KMCommandIntentionsDTO::getApplicationCode));
                    if (CollectionUtils.isNotEmpty((Collection)kmCommandIntentions)) {
                        List<KMCommandIntentionsDTO> Intentions = kmCommandIntentionMap.get(appCode);
                        phrases = AniaAssistantResDTO.Assistant.InspirationPhrases.builderInspirationPhrasesV1(Intentions);
                    }
                } else {
                    commandIntentions = cIData.getCommandIntentions();
                    phrases = AniaAssistantResDTO.Assistant.InspirationPhrases.builderInspirationPhrases(commandIntentions);
                }
            }
            assistant.setInspirationPhrases(phrases);
            assistant.setAssistantId(appCode);
            assistantList.add(assistant);
        }
        result.setAssistant(assistantList);
        return result;
    }

    public void deleteMongoCustomConfig(AgileDataCustomConfig agileDataCustomConfig, AuthoredUser user) {
        String version = agileDataCustomConfig.getVersion();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        this.mongoTemplate.remove(query, "agile_data_custom_config");
    }
}

