/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.apc;

import com.digiwin.athena.adt.agileReport.controller.dto.AthenaApcMessageReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AthenaApcMessageResDTO;
import com.digiwin.athena.adt.agileReport.service.AgileApcDataService;
import com.digiwin.athena.adt.agileReport.service.AgileDataCostDetailService;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.apc.AgileAdeApcReqDTO;
import com.digiwin.athena.adt.domain.dto.km.KMApplicationApcResDTO;
import com.digiwin.athena.adt.domain.knowledge.KmService;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgileApcDataServiceImpl
implements AgileApcDataService {
    private static final Logger log = LoggerFactory.getLogger(AgileApcDataServiceImpl.class);
    @Resource
    private ADEService adeService;
    @Autowired
    private AgileDataCostDetailService agileDataCostDetailService;
    @Autowired
    private KmService kmService;

    public AthenaApcMessageResDTO processMessage(HttpServletRequest request, AthenaApcMessageReqDTO req, AuthoredUser user, String local) {
        AthenaApcMessageResDTO resDTO = new AthenaApcMessageResDTO();
        long getQuerySchemaTook = System.currentTimeMillis();
        log.error("apc \u5927\u5c4f \u67e5\u8be2\u5165\u53c2 \uff1a{},{},{},{},{}", new Object[]{user.getUserId(), user.getUserName(), user.getTenantId(), user.getTenantName(), JsonUtils.objectToString((Object)req)});
        LogDto logDto = new LogDto("apc \u5927\u5c4f \u67e5\u8be2\u5165\u53c2\uff1a" + JsonUtils.objectToString((Object)req));
        SnapShotDTO result = new SnapShotDTO();
        log.info(logDto.toString());
        try {
            AgileAdeApcReqDTO agileAdeApcReqDTO = AgileAdeApcReqDTO.builderReq((AthenaApcMessageReqDTO)req);
            if ("sync-instant".equals(req.getRequestType())) {
                this.instantRequest(agileAdeApcReqDTO, user, resDTO, local);
            } else {
                this.syncRequest(agileAdeApcReqDTO, user, resDTO, local);
            }
        }
        catch (Exception e) {
            log.error("AgileApcDataService processMessage Exception : {}", (Object)e.getMessage());
            resDTO.setSuccess(false);
        }
        log.error("apc \u5927\u5c4f \u67e5\u8be2 \u51fa\u53c2\uff1a{},{},{},{},{},\u8017\u65f6:{}ms", new Object[]{user.getUserId(), user.getUserName(), user.getTenantId(), user.getTenantName(), JsonUtils.objectToString((Object)result), System.currentTimeMillis() - getQuerySchemaTook});
        return resDTO;
    }

    public void instantRequest(AgileAdeApcReqDTO agileAdeApcReqDTO, AuthoredUser user, AthenaApcMessageResDTO resDTO, String local) {
        SnapShotDTO result = this.adeService.reqApcSnapShotDataBySync(agileAdeApcReqDTO, user, local);
        if (Objects.nonNull(result)) {
            this.saveCostDetailByApcData(result, agileAdeApcReqDTO.getScreen().getSceneCode(), user);
            resDTO.setSuccess(true);
            resDTO.setSnapShotDTO(result);
        }
    }

    public void syncRequest(AgileAdeApcReqDTO agileAdeApcReqDTO, AuthoredUser user, AthenaApcMessageResDTO resDTO, String local) {
        resDTO.setSuccess(true);
        CompletableFuture.runAsync(() -> {
            SnapShotDTO result = this.adeService.reqApcSnapShotDataBySync(agileAdeApcReqDTO, user, local);
            this.saveCostDetailByApcData(result, agileAdeApcReqDTO.getScreen().getSceneCode(), user);
        });
    }

    public void saveCostDetailByApcData(SnapShotDTO result, String sceneCode, AuthoredUser user) {
        if (StringUtils.isEmpty((CharSequence)result.getSnapshotId())) {
            return;
        }
        String ptxId = JaMDC.createTraceId();
        MDC.put((String)"traceId", (String)ptxId);
        MDC.put((String)"PtxId", (String)ptxId);
        List apcRes = this.kmService.queryApplicationByCode(user, sceneCode);
        if (CollectionUtils.isNotEmpty((Collection)apcRes)) {
            for (KMApplicationApcResDTO res : apcRes) {
                String appCode = res.getCode();
                String appName = res.getName();
                this.agileDataCostDetailService.saveAgileDataCostDetail(CommonUtil.convertObjectToMap((Object)result), user, ptxId, appCode, appName, "apc\u5927\u5c4f");
            }
        }
    }
}

