/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.calculate;

import com.digiwin.athena.adt.agileReport.dao.AgileDataCalculateConfigMapper;
import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateConfigService;
import com.digiwin.athena.adt.domain.cac.AthenaCacService;
import com.digiwin.athena.adt.domain.dto.cac.CacGoods;
import com.digiwin.athena.adt.domain.dto.km.KMIsBillingGoodsResDTO;
import com.digiwin.athena.adt.domain.dto.km.KMUserAppCodesResDTO;
import com.digiwin.athena.adt.domain.knowledge.KmService;
import com.digiwin.athena.adt.domain.po.AgileDataCalculateConfig;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgileDataCalculateConfigServiceImpl
implements AgileDataCalculateConfigService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataCalculateConfigServiceImpl.class);
    @Resource
    private AgileDataCalculateConfigMapper agileDataCalculateConfigMapper;
    @Autowired
    private AthenaCacService athenaCacService;
    @Autowired
    private KmService kmService;
    @Autowired
    private AgileDataCalculateConfigService agileDataCalculateConfigService;

    public Object insert(AgileDataCalculateConfig agileDataCalculateConfig, AuthoredUser user) {
        agileDataCalculateConfig.setCreateDate(new Date());
        return this.agileDataCalculateConfigMapper.insert((Object)agileDataCalculateConfig);
    }

    public Object update(AgileDataCalculateConfig agileDataCalculateConfig, AuthoredUser user) {
        agileDataCalculateConfig.setModifyDate(new Date());
        return this.agileDataCalculateConfigMapper.updateById((Object)agileDataCalculateConfig);
    }

    public Object delete(AgileDataCalculateConfig agileDataCalculateConfig, AuthoredUser user) {
        long id = agileDataCalculateConfig.getId();
        return this.agileDataCalculateConfigMapper.deleteById((Serializable)Long.valueOf(id));
    }

    public boolean queryCalculateConfigByUser(AuthoredUser user) {
        String userId = user.getUserId();
        AgileDataCalculateConfig config = this.agileDataCalculateConfigMapper.queryCalculateConfigByUser(userId);
        if (Objects.isNull(config)) {
            return true;
        }
        return "1".equals(config.getCalculateType());
    }

    public void updateCalculateTypeByParam(String userId, String type) {
        this.agileDataCalculateConfigMapper.updateCalculateTypeByParam(userId, type);
    }

    public CacGoods queryCalculateCacByConfig(AuthoredUser user) {
        AgileDataCalculateConfig config = this.agileDataCalculateConfigMapper.queryCalculateConfig();
        if (config == null) {
            return new CacGoods();
        }
        return this.athenaCacService.getCacCurrentTenantGoods(user, config.getGoodsCode());
    }

    public void deleteCalculateTypeByParam(String userId) {
        this.agileDataCalculateConfigMapper.deleteCalculateTypeByParam(userId);
    }

    public KMIsBillingGoodsResDTO getIsBilling(AuthoredUser user) {
        KMIsBillingGoodsResDTO res = new KMIsBillingGoodsResDTO();
        AgileDataCalculateConfig config = this.agileDataCalculateConfigService.queryCalculateConfig();
        log.info("\u8ba1\u8d39\u4e1a\u52a1 \u67e5\u8be2\u914d\u7f6e\u6d41\u91cf\u5305id:{}", (Object)JsonUtils.objectToString((Object)config));
        if (Objects.isNull(config) || StringUtils.isEmpty((CharSequence)config.getGoodsCode())) {
            return res;
        }
        String billingId = config.getGoodsCode();
        KMUserAppCodesResDTO userAppCodes = this.kmService.queryKmUserAppCodes(user.getToken(), user.getTenantId(), user.getUserId());
        if (Objects.isNull(userAppCodes) || CollectionUtils.isEmpty((Collection)userAppCodes.getAppCodes())) {
            return res;
        }
        boolean isBillingId = userAppCodes.getAppCodes().stream().anyMatch(billingId::equals);
        res.setBilling(isBillingId);
        res.setApplyCount(Integer.valueOf(userAppCodes.getAppCodes().size()));
        log.info("\u8ba1\u8d39\u4e1a\u52a1 getIsBilling res :{}", (Object)JsonUtils.objectToString((Object)res));
        return res;
    }

    public AgileDataCalculateConfig queryCalculateConfig() {
        return this.agileDataCalculateConfigMapper.queryCalculateConfig();
    }
}

