/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.calculate;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.adt.agileReport.dao.AgileDataConfigMapper;
import com.digiwin.athena.adt.agileReport.service.AgileDataConfigService;
import com.digiwin.athena.adt.domain.po.AgileDataConfig;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AgileDataConfigServiceImpl
implements AgileDataConfigService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataConfigServiceImpl.class);
    private static final String TENANT_ID = "tenant_id";
    private static final String CONFIG_TYPE = "type";
    private static final String ECHO_CHARGING_KEY = "ECHO_CHARGING_KEY";
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private AgileDataConfigMapper agileDataConfigMapper;

    public Object insert(AgileDataConfig agileDataConfig, AuthoredUser user) {
        agileDataConfig.setCreateDate(new Date());
        return this.agileDataConfigMapper.insert((Object)agileDataConfig);
    }

    public Object update(AgileDataConfig agileDataConfig, AuthoredUser user) {
        agileDataConfig.setModifyDate(new Date());
        return this.agileDataConfigMapper.updateById((Object)agileDataConfig);
    }

    public Object delete(AgileDataConfig agileDataConfig, AuthoredUser user) {
        long id = agileDataConfig.getId();
        return this.agileDataConfigMapper.deleteById((Serializable)Long.valueOf(id));
    }

    public Object getUserValue(AuthoredUser user) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)TENANT_ID, (Object)user.getTenantId());
        AgileDataConfig agileDataConfig = (AgileDataConfig)this.agileDataConfigMapper.selectOne((Wrapper)queryWrapper);
        log.info("user agile data value : {}", (Object)agileDataConfig);
        int value = 0;
        if (agileDataConfig != null) {
            value = agileDataConfig.getValue();
        }
        return value;
    }

    public Object getUserValueByType(AuthoredUser user, String type) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)CONFIG_TYPE, (Object)type);
        AgileDataConfig agileDataConfig = (AgileDataConfig)this.agileDataConfigMapper.selectOne((Wrapper)queryWrapper);
        log.info("user agile data value : {}", (Object)agileDataConfig);
        Integer value = null;
        if (agileDataConfig != null) {
            value = agileDataConfig.getValue();
        }
        return value;
    }
}

