/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.dataset;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataTableDataResDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataTableListResDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileTableDataReqDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataTableDataService;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.KMScencDTO;
import com.digiwin.athena.adt.domain.dto.ade.AdeDataSetFieldReqDTO;
import com.digiwin.athena.adt.domain.dto.ade.AdeDatasetReqDTO;
import com.digiwin.athena.adt.domain.dto.km.KMDataSetResDTO;
import com.digiwin.athena.adt.domain.dto.km.KMDatasetCommandIntentionsResDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaDatasetDTO;
import com.digiwin.athena.adt.domain.dto.schema.SchemaMetricShowDefine;
import com.digiwin.athena.adt.domain.knowledge.KmService;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AgileDataTableDataServiceImpl
implements AgileDataTableDataService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataTableDataServiceImpl.class);
    @Autowired
    private KmService kmService;
    @Resource
    private ADEService adeService;
    @Autowired
    private MessageUtil messageUtil;

    public AgileDataTableListResDTO getTableList(AuthoredUser user, AgileTableDataReqDTO reqDTO) {
        AgileDataTableListResDTO result = new AgileDataTableListResDTO();
        ArrayList<AgileDataTableListResDTO.DatasetTableData> tableList = new ArrayList<AgileDataTableListResDTO.DatasetTableData>();
        String appCode = reqDTO.getAppCode();
        String userLang = reqDTO.getLang();
        try {
            KMDatasetCommandIntentionsResDTO cIData = this.kmService.dataSetCommandIntentions(user, appCode, "");
            if (Objects.isNull(cIData)) {
                result.setMsg("\u672a\u67e5\u8be2\u5230\u5e94\u7528");
                result.setTableList(tableList);
                return result;
            }
            Integer appType = cIData.getAppType();
            List dataSetResDTO = this.kmService.queryDataSetsByAppCode(user, appCode, userLang);
            if (CollectionUtils.isEmpty((Collection)dataSetResDTO)) {
                result.setMsg("\u672a\u67e5\u8be2\u5230\u6570\u636e\u96c6");
                result.setTableList(tableList);
                return result;
            }
            for (KMDataSetResDTO dataset : dataSetResDTO) {
                Map datasetMap = this.assembleDatasetMap(dataset);
                AgileDataTableListResDTO.DatasetTableData tableData = new AgileDataTableListResDTO.DatasetTableData();
                String datasetId = dataset.getCode();
                String datasetName = dataset.getName();
                List<Object> sentences = new ArrayList();
                if (Objects.nonNull(dataset.getQuestions())) {
                    sentences = dataset.getQuestions().stream().map(KMDataSetResDTO.question::getQuestion).collect(Collectors.toList());
                }
                tableData.setTableId(datasetId);
                tableData.setTableName(datasetName);
                tableData.setSentences(sentences);
                AdeDataSetFieldReqDTO req = AdeDataSetFieldReqDTO.builderReq((AuthoredUser)user, (String)appCode, (String)datasetId);
                Map snapshotInfo = this.adeService.getDataSetFieldList(user, req, userLang);
                if (Objects.isNull(snapshotInfo) || "-1".equals(snapshotInfo.get("code"))) {
                    if (Objects.isNull(snapshotInfo)) {
                        result.setMsg(this.messageUtil.getMessageByLangName("message.adt.data.dataTable.error", reqDTO.getLang()));
                    } else {
                        result.setMsg(String.valueOf(snapshotInfo.get("msg")));
                    }
                    result.setTableList(tableList);
                    return result;
                }
                Optional.ofNullable(snapshotInfo.get("data")).map(data -> (Map)data).flatMap(dataMap -> Optional.ofNullable(dataMap.get("context")).map(context -> (Map)context)).ifPresent(contextMap -> {
                    Object pullDataObj = contextMap.get("pullData");
                    if (pullDataObj instanceof List) {
                        List pullData = (List)pullDataObj;
                        for (Map pullDataDTO : pullData) {
                            this.parseDataStructure(pullDataDTO, tableData);
                        }
                    } else {
                        log.info("getTableList req : {}", (Object)JsonUtils.objectToString((Object)req));
                        result.setMsg(this.messageUtil.getMessageByLangName("message.adt.data.dataTable.error", reqDTO.getLang()));
                    }
                });
                if (appType != null && 12 == appType) {
                    tableData.setProductVersion("V2");
                } else {
                    tableData.setProductVersion("V1");
                }
                tableData.setDataset(datasetMap);
                tableList.add(tableData);
            }
            result.setTableList(tableList);
        }
        catch (Exception e) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"\u83b7\u53d6\u6570\u636e\u96c6\u5217\u8868\u67e5\u8be2\u89e3\u6790\u5931\u8d25", JSONObject.toJSONString((Object)appCode), e.getMessage()});
        }
        return result;
    }

    public Map<String, Object> assembleDatasetMap(KMDataSetResDTO kmDataSetResDTO) {
        HashMap<String, Object> dataset = new HashMap<String, Object>();
        dataset.put("modelId", kmDataSetResDTO.getModelId());
        dataset.put("modelCode", kmDataSetResDTO.getModelCode());
        dataset.put("datasetName", kmDataSetResDTO.getName());
        dataset.put("datasetId", kmDataSetResDTO.getCode());
        dataset.put("lang", kmDataSetResDTO.getLang());
        dataset.put("fieldSchema", AgileDataTableDataServiceImpl.buildFieldSchemaList((KMDataSetResDTO)kmDataSetResDTO));
        dataset.put("applicationCode", kmDataSetResDTO.getAppCode());
        dataset.put("applicationName", kmDataSetResDTO.getAppName());
        dataset.put("mappingFields", AgileDataTableDataServiceImpl.buildFieldAndTableFieldMap((KMDataSetResDTO)kmDataSetResDTO));
        return dataset;
    }

    public static Object buildFieldSchemaList(KMDataSetResDTO kmDataSetResDTO) {
        HashMap map;
        ArrayList fieldSchema = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)kmDataSetResDTO.getDimensions())) {
            for (Map dimension : kmDataSetResDTO.getDimensions()) {
                if (!AgileDataTableDataServiceImpl.isNonEmptyCollection(dimension.get("enums"))) continue;
                map = new HashMap();
                map.put("name", dimension.get("data_name"));
                map.put("enums", dimension.get("enums"));
                fieldSchema.add(map);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)kmDataSetResDTO.getMeasures())) {
            for (Map measure : kmDataSetResDTO.getMeasures()) {
                if (!AgileDataTableDataServiceImpl.isNonEmptyCollection(measure.get("enums"))) continue;
                map = new HashMap();
                map.put("name", measure.get("data_name"));
                map.put("enums", measure.get("enums"));
                fieldSchema.add(map);
            }
        }
        return fieldSchema;
    }

    public static boolean isNonEmptyCollection(Object obj) {
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            return !collection.isEmpty();
        }
        return false;
    }

    public static Map<String, Object> buildFieldAndTableFieldMap(KMDataSetResDTO kmDataSetResDTO) {
        HashMap<String, Object> mappingFields = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty((Collection)kmDataSetResDTO.getDimensions())) {
            for (Map dimension : kmDataSetResDTO.getDimensions()) {
                mappingFields.put(String.valueOf(dimension.get("data_name")), dimension.get("map_field"));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)kmDataSetResDTO.getMeasures())) {
            for (Map measure : kmDataSetResDTO.getMeasures()) {
                mappingFields.put(String.valueOf(measure.get("data_name")), measure.get("map_field"));
            }
        }
        return mappingFields;
    }

    public void parseDataStructure(Map<String, Object> data, AgileDataTableListResDTO.DatasetTableData tableData) {
        try {
            ArrayList dimensionFields = new ArrayList();
            ArrayList measurementFields = new ArrayList();
            ObjectMapper mapper = new ObjectMapper();
            JsonNode rootNode = mapper.readTree(JSONObject.toJSONString(data));
            Optional<JsonNode> fieldNodeOptional = Optional.ofNullable(rootNode).map(node -> node.path("metadata").path("response").path("data"));
            fieldNodeOptional.ifPresent(dataNode -> {
                JsonNode fieldNode;
                String dataType = dataNode.path("data_type").asText();
                if ("object".equals(dataType) && (fieldNode = dataNode.path("field")).isArray()) {
                    fieldNode.forEach(node -> {
                        AgileDataTableListResDTO.DatasetTableData.Field field = new AgileDataTableListResDTO.DatasetTableData.Field();
                        String dataName = node.path("data_name").asText();
                        String dataTypeName = node.path("data_type").asText();
                        String description = node.path("description").asText();
                        String feature = node.path("feature").asText();
                        field.setName(dataName);
                        field.setDataType(dataTypeName);
                        field.setDescription(description);
                        if ("dimensions".equals(feature)) {
                            dimensionFields.add(field);
                        } else if ("measures".equals(feature)) {
                            measurementFields.add(field);
                        }
                    });
                }
            });
            tableData.setDimensionFields(dimensionFields);
            tableData.setMeasurementFields(measurementFields);
        }
        catch (Exception e) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"\u83b7\u53d6\u6570\u636e\u96c6\u5217\u8868\u67e5\u8be2\u89e3\u6790\u5931\u8d25", JSONObject.toJSONString((Object)tableData), e.getMessage()});
        }
    }

    public AgileDataTableDataResDTO getTablePreviewData(AuthoredUser user, AgileTableDataReqDTO reqDTO) {
        log.error("\u5f00\u59cb\u9884\u89c8\u6570\u636e\u96c6\uff1a{}", (Object)JsonUtils.objectToString((Object)reqDTO));
        AgileDataTableDataResDTO resDTO = new AgileDataTableDataResDTO();
        try {
            String tableId = reqDTO.getTableId();
            String appCode = reqDTO.getAppCode();
            String userLang = reqDTO.getLang();
            AdeDataSetFieldReqDTO datasetFieldReq = AdeDataSetFieldReqDTO.builderReq((AuthoredUser)user, (String)appCode, (String)tableId);
            Map snapshotInfo = this.adeService.getDataSetFieldList(user, datasetFieldReq, userLang);
            if (Objects.isNull(snapshotInfo) || "-1".equals(snapshotInfo.get("code"))) {
                if (Objects.isNull(snapshotInfo)) {
                    resDTO.setMsg(this.messageUtil.getMessageByLangName("message.adt.data.dataTable.error", reqDTO.getLang()));
                } else {
                    resDTO.setMsg(String.valueOf(snapshotInfo.get("msg")));
                }
                return resDTO;
            }
            ArrayList solutionStep = new ArrayList();
            Map data = (Map)snapshotInfo.get("data");
            Map context = (Map)data.get("context");
            List pullData = (List)context.get("pullData");
            for (Map pullDataDTO : pullData) {
                ArrayList selectList = new ArrayList();
                HashMap<String, Object> select = new HashMap<String, Object>();
                ObjectMapper mapper = new ObjectMapper();
                JsonNode rootNode = mapper.readTree(JSONObject.toJSONString((Object)pullDataDTO));
                Optional<JsonNode> fieldNodeOptional = Optional.ofNullable(rootNode).map(node -> node.path("metadata").path("response").path("data"));
                fieldNodeOptional.ifPresent(dataNode -> {
                    JsonNode fieldNode;
                    String dataType = dataNode.path("data_type").asText();
                    if ("object".equals(dataType) && (fieldNode = dataNode.path("field")).isArray()) {
                        fieldNode.forEach(node -> {
                            HashMap dataObjectMap = new HashMap();
                            HashMap<String, String> dataObject = new HashMap<String, String>();
                            String dataName = node.path("data_name").asText();
                            String dataTypeName = node.path("data_type").asText();
                            String description = node.path("description").asText();
                            dataObject.put("dataType", dataTypeName);
                            dataObject.put("alias", dataName);
                            dataObject.put("language", "");
                            dataObject.put("source", tableId);
                            dataObject.put("title", description);
                            dataObject.put("contentType", "field");
                            dataObject.put("content", dataName);
                            dataObjectMap.put("dataObject", dataObject);
                            selectList.add(dataObjectMap);
                        });
                    }
                });
                HashMap<String, String> datasetObject = new HashMap<String, String>();
                datasetObject.put("metric", tableId);
                datasetObject.put("alias", tableId);
                datasetObject.put("datasetType", "dataset");
                HashMap<String, Integer> limit = new HashMap<String, Integer>();
                limit.put("startPos", 0);
                limit.put("endPos", 50);
                select.put("datasetObject", datasetObject);
                select.put("alias", tableId);
                select.put("limit", limit);
                select.put("select", selectList);
                solutionStep.add(select);
            }
            AthenaMessageEvent event = new AthenaMessageEvent();
            String ptxId = JaMDC.createTraceId();
            MDC.put((String)"traceId", (String)ptxId);
            MDC.put((String)"PtxId", (String)ptxId);
            Long generateSerialNo = SnowflakeIdWorker.getInstance().newId();
            event.setUser(user);
            event.setGenerateSerialNo(generateSerialNo);
            event.setPtxId(ptxId);
            event.setLang(reqDTO.getLang());
            event.setProductVersion(reqDTO.getProductVersion());
            event.setAppCode(reqDTO.getAppCode());
            QuerySchemaDatasetDTO dataset = new QuerySchemaDatasetDTO();
            SchemaMetricShowDefine showDefine = new SchemaMetricShowDefine();
            ArrayList<SchemaMetricShowDefine.ShowType> showTypes = new ArrayList<SchemaMetricShowDefine.ShowType>();
            SchemaMetricShowDefine.ShowType showType = new SchemaMetricShowDefine.ShowType();
            showType.setActionId(tableId);
            showType.setType(new ArrayList());
            showTypes.add(showType);
            showDefine.setShowType(showTypes);
            dataset.setShowDefine(showDefine);
            dataset.setSolutionStep(solutionStep);
            KMScencDTO kmScencDTO = this.kmService.getKmSceneInfo(event, tableId, userLang, user.getToken(), user.getTenantId());
            ArrayList<Map> mappingFields = new ArrayList<Map>();
            if (kmScencDTO != null) {
                reqDTO.getDataset().put("queryMode", kmScencDTO.getQueryMode());
            }
            mappingFields.add(reqDTO.getDataset());
            dataset.setDatasetList(mappingFields);
            dataset.setTablePreviewIf(true);
            Map req = CommonUtil.convertObjectToMap((Object)AdeDatasetReqDTO.BuildDatasetAdeReq((AthenaMessageEvent)event, (QuerySchemaDatasetDTO)dataset));
            Map res = this.adeService.reqMetricSnapShotData(req, event);
            if (Objects.isNull(res) || "-1".equals(res.get("code"))) {
                if (Objects.isNull(res)) {
                    resDTO.setMsg(this.messageUtil.getMessageByLangName("message.adt.data.dataTable.error", reqDTO.getLang()));
                } else {
                    resDTO.setMsg(String.valueOf(res.get("msg")));
                }
                return resDTO;
            }
            ArrayList dataList = new ArrayList();
            ArrayList fieldList = new ArrayList();
            Optional.ofNullable((Map)res.get("data")).map(dataTable -> (Map)dataTable.get("context")).map(contextTable -> (List)contextTable.get("pullData")).ifPresent(pullDataTable -> pullDataTable.forEach(pullDataDTO -> {
                Map metadata = Optional.ofNullable((Map)pullDataDTO.get("metadata")).orElse(Collections.emptyMap());
                Map response = Optional.ofNullable((Map)metadata.get("response")).orElse(Collections.emptyMap());
                Map responseData = Optional.ofNullable((Map)response.get("data")).orElse(Collections.emptyMap());
                List fields = Optional.ofNullable((List)responseData.get("field")).orElse(Collections.emptyList());
                Map dataData = Optional.ofNullable((Map)pullDataDTO.get("data")).orElse(Collections.emptyMap());
                List dataArray = Optional.ofNullable((List)dataData.get("data")).orElse(Collections.emptyList());
                dataList.addAll(Optional.of(dataArray).orElse(Collections.emptyList()));
                fieldList.addAll(Optional.of(fields).orElse(Collections.emptyList()));
            }));
            if (dataList.isEmpty() || fieldList.isEmpty()) {
                log.info("getTableList req : {}", (Object)JsonUtils.objectToString((Object)res));
            }
            resDTO.setData(dataList);
            resDTO.setFields(fieldList);
        }
        catch (Exception e) {
            log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"\u83b7\u53d6\u6570\u636e\u96c6\u6570\u636e\u9884\u89c8\u8be6\u60c5\u89e3\u6790\u5931\u8d25", JSONObject.toJSONString((Object)reqDTO), e.getMessage()});
        }
        return resDTO;
    }
}

