/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.hook;

import com.digiwin.athena.adt.agileReport.service.AgileDataPageHooksService;
import com.digiwin.athena.adt.domain.dto.AgileDataPageViewDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AgileDataPageHooksServiceImpl
implements AgileDataPageHooksService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataPageHooksServiceImpl.class);
    @Autowired
    @Qualifier(value="mongoAgileDataPageViewTemplate")
    private MongoTemplate mongoAgileDataPageViewTemplate;
    private static final String MONGODB_COLLECTION_NAME = "agile_data_pageView";
    private static String keyPrefix = "adt:cache:";
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    public Boolean createAgileDataPageHooks(AuthoredUser authoredUser, Map<String, Object> params) {
        String type = MapUtils.getString(params, (Object)"type");
        Integer version = MapUtils.getInteger(params, (Object)"version");
        if (StringUtils.isEmpty((CharSequence)type)) {
            return false;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"type").is((Object)type).and("version").is((Object)version));
        AgileDataPageViewDTO agileDataPageViewDTO = (AgileDataPageViewDTO)this.mongoAgileDataPageViewTemplate.findOne(query, AgileDataPageViewDTO.class, MONGODB_COLLECTION_NAME);
        if (agileDataPageViewDTO == null) {
            AgileDataPageViewDTO pageViewDTO = new AgileDataPageViewDTO();
            pageViewDTO.setType(type);
            pageViewDTO.setVersion(version);
            pageViewDTO.setHooks((List)MapUtils.getObject(params, (Object)"hooks"));
            this.mongoAgileDataPageViewTemplate.insert((Object)pageViewDTO, MONGODB_COLLECTION_NAME);
        } else {
            Update update = new Update();
            update.set("hooks", MapUtils.getObject(params, (Object)"hooks"));
            this.mongoAgileDataPageViewTemplate.upsert(query, (UpdateDefinition)update, AgileDataPageViewDTO.class, MONGODB_COLLECTION_NAME);
            this.stringRedisTemplate.delete((Object)(keyPrefix + type));
        }
        return true;
    }

    public AgileDataPageViewDTO queryAgileDataPageHooks(AuthoredUser authoredUser, String type) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"type").is((Object)type).and("version").is((Object)1));
        AgileDataPageViewDTO agileDataPageViewDTO = (AgileDataPageViewDTO)this.mongoAgileDataPageViewTemplate.findOne(query, AgileDataPageViewDTO.class, MONGODB_COLLECTION_NAME);
        return agileDataPageViewDTO;
    }
}

