/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.log;

import com.digiwin.athena.adt.agileReport.eventbus.AgileDataLogEvent;
import com.digiwin.athena.adt.agileReport.service.AgileReportLogMongoService;
import com.digiwin.athena.adt.domain.dto.AgileDataResultLog;
import com.digiwin.athena.adt.util.DateUtils;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
public class AgileReportLogMongoServiceImpl
implements AgileReportLogMongoService {
    private static final Logger log = LoggerFactory.getLogger(AgileReportLogMongoServiceImpl.class);
    @Autowired
    @Qualifier(value="mongoAgileDataLogTemplate")
    private MongoTemplate mongoAgileDataLogTemplate;
    private static final String MONGODB_COLLECTION_NAME = "agile_data_full_log";

    public Boolean saveLog(AgileDataLogEvent agileDataLogEvent, Map<String, Object> schemaMap) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"generateSerialNo").is((Object)agileDataLogEvent.getGenerateSerialNo()).and("userId").is((Object)agileDataLogEvent.getAuthoredUser().getUserId()).and("tenantId").is((Object)agileDataLogEvent.getAuthoredUser().getTenantId()));
        AgileDataResultLog agileDataResultLog = (AgileDataResultLog)this.mongoAgileDataLogTemplate.findOne(query, AgileDataResultLog.class, MONGODB_COLLECTION_NAME);
        try {
            if (agileDataResultLog == null) {
                agileDataResultLog = AgileDataResultLog.builder().userId(agileDataLogEvent.getAuthoredUser().getUserId()).userName(agileDataLogEvent.getAuthoredUser().getUserName()).tenantId(agileDataLogEvent.getAuthoredUser().getTenantId()).tenantName(agileDataLogEvent.getAuthoredUser().getTenantName()).terminal(agileDataLogEvent.getTerminal()).generateSerialNo(agileDataLogEvent.getGenerateSerialNo()).snapshotId(agileDataLogEvent.getSnapshotId()).success(agileDataLogEvent.getSuccess()).sourceCode(agileDataLogEvent.getSourceCode()).sourceName(agileDataLogEvent.getSourceName()).question(agileDataLogEvent.getQuestion()).errorAnswer(agileDataLogEvent.getErrorAnswer()).answerOpinion(agileDataLogEvent.getAnswerOpinion()).feedbackType(agileDataLogEvent.getFeedbackType()).params(MapUtils.isNotEmpty((Map)agileDataLogEvent.getParams()) ? agileDataLogEvent.getParams() : Maps.newHashMap()).data(MapUtils.isNotEmpty((Map)agileDataLogEvent.getData()) ? agileDataLogEvent.getData() : Maps.newHashMap()).answerOpinion(agileDataLogEvent.getAnswerOpinion()).querySchema(MapUtils.getMap(schemaMap, (Object)"sqlSchemaMaps", (Map)Maps.newHashMap())).backContent(agileDataLogEvent.getBackContent()).checkOpinions(agileDataLogEvent.getCheckOpinions()).extendInfo(MapUtils.isNotEmpty((Map)agileDataLogEvent.getExtendInfo()) ? agileDataLogEvent.getExtendInfo() : Maps.newHashMap()).createTime(agileDataLogEvent.getAskTime()).answerTime(agileDataLogEvent.getAnswerTime()).resSecTime(DateUtils.calculateAndSetDuration((LocalDateTime)agileDataLogEvent.getAskTime(), (LocalDateTime)agileDataLogEvent.getAnswerTime())).applicationCode(agileDataLogEvent.getApplicationCode()).applicationName(agileDataLogEvent.getApplicationName()).logSaveSuccess(agileDataLogEvent.getLogSaveSuccess()).reason(agileDataLogEvent.getReason()).productVersion(agileDataLogEvent.getProductVersion()).build();
                this.mongoAgileDataLogTemplate.insert((Object)agileDataResultLog, MONGODB_COLLECTION_NAME);
            } else {
                this.mongoAgileDataLogTemplate.updateFirst(query, (UpdateDefinition)this.getUpdateInfo(agileDataLogEvent, agileDataResultLog), MONGODB_COLLECTION_NAME);
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u95ee\u9898\u65e5\u5fd7\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            return false;
        }
        return true;
    }

    public Boolean removeLog(AgileDataLogEvent agileDataLogEvent) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"generateSerialNo").is((Object)agileDataLogEvent.getGenerateSerialNo()).and("userId").is((Object)agileDataLogEvent.getAuthoredUser().getUserId()).and("tenantId").is((Object)agileDataLogEvent.getAuthoredUser().getTenantId()));
        this.mongoAgileDataLogTemplate.remove(query, MONGODB_COLLECTION_NAME);
        return true;
    }

    private Update getUpdateInfo(AgileDataLogEvent agileDataLogEvent, AgileDataResultLog agileDataResultLog) {
        Update update = new Update();
        switch (agileDataLogEvent.getType()) {
            case 0: {
                update.set("data", (Object)agileDataLogEvent.getData());
                break;
            }
            case 1: {
                update.set("errorAnswer", (Object)agileDataLogEvent.getErrorAnswer());
                update.set("params", (Object)agileDataLogEvent.getParams());
                update.set("success", (Object)agileDataLogEvent.getSuccess());
                break;
            }
            case 2: {
                update.set("feedbackType", (Object)agileDataLogEvent.getFeedbackType());
                update.set("extendInfo", (Object)agileDataLogEvent.getExtendInfo());
                if (agileDataResultLog.getCreateBackTime() != null) break;
                update.set("createBackTime", (Object)LocalDateTime.now());
                break;
            }
            case 3: {
                update.set("answerOpinion", (Object)agileDataLogEvent.getAnswerOpinion());
                update.set("backContent", (Object)agileDataLogEvent.getBackContent());
                update.set("checkOpinions", (Object)agileDataLogEvent.getCheckOpinions());
                if (agileDataResultLog.getExtendInfo() == null) {
                    update.set("extendInfo", (Object)agileDataLogEvent.getExtendInfo());
                }
                if (agileDataResultLog.getCreateBackTime() != null) break;
                update.set("createBackTime", (Object)LocalDateTime.now());
                break;
            }
            case 4: {
                update.set("feedbackType", null);
                update.set("answerOpinion", (Object)agileDataLogEvent.getAnswerOpinion());
                update.set("backContent", (Object)agileDataLogEvent.getBackContent());
                update.set("checkOpinions", (Object)agileDataLogEvent.getCheckOpinions());
                update.set("createBackTime", null);
                break;
            }
        }
        update.set("modifyTime", (Object)LocalDateTime.now());
        return update;
    }
}

