/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.agileData;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.controller.dto.AthenaMessageDTO;
import com.digiwin.athena.adt.agileReport.dao.AgileDataLogMapper;
import com.digiwin.athena.adt.agileReport.eventbus.AgileDataLogEvent;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataClassificationsService;
import com.digiwin.athena.adt.agileReport.service.AgileDataLogService;
import com.digiwin.athena.adt.app.env.AdtEnvProperties;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.ade.ADEScencDTO;
import com.digiwin.athena.adt.domain.dto.ade.AdeDatasetReqDTO;
import com.digiwin.athena.adt.domain.dto.ade.AdeMetricReqDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.aiBoard.AIBoardDTO;
import com.digiwin.athena.adt.domain.dto.echo.AgileDataFileDTO;
import com.digiwin.athena.adt.domain.dto.echo.EchoSubmitReq;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaDatasetDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaMetricDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.knowledge.KmService;
import com.digiwin.athena.adt.domain.po.AgileDataClassifications;
import com.digiwin.athena.adt.domain.po.AgileDataLog;
import com.digiwin.athena.adt.domain.report.impl.AbsAgileEventProcess;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.sse.domain.EventData;
import com.digiwin.athena.adt.sse.domain.SseAniaEventEnum;
import com.digiwin.athena.adt.sse.utils.SseEmitterUtils;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.DateUtils;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public abstract class AbsAgileDataProcess
extends AbsAgileEventProcess {
    private static final Logger log = LoggerFactory.getLogger(AbsAgileDataProcess.class);
    @Autowired
    private AgileDataLogService agileDataLogService;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private SemcService semcService;
    @Autowired
    private AgileDataClassificationsService agileDataClassificationsService;
    @Autowired
    private AdtEnvProperties adtEnvProperties;
    @Resource
    private ADEService adeService;
    @Autowired
    private KmService kmService;
    @Autowired
    private AgileDataLogMapper agileDataLogMapper;
    @Autowired
    private EchoService echoService;

    public ADEScencDTO buildCommonAdeScene(AthenaMessageEvent event, Map<String, Object> data) {
        ADEScencDTO adeScencDTO = new ADEScencDTO();
        List eocMaps = new ArrayList();
        if (Objects.nonNull(data.get("eocMaps"))) {
            eocMaps = (List)data.get("eocMaps");
        }
        if (event.isSubscribe()) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("type", "2");
            param.put("undeletable", event.isUndeletable());
            param.put("asaCode", event.getAsaCode());
            param.put("ruleId", event.getMsgExt().get("ruleId"));
            adeScencDTO.setParam(param);
        }
        adeScencDTO.setTenantId(event.getUser().getTenantId());
        adeScencDTO.setRequestor(event.getUser().getUserId());
        adeScencDTO.setRequestPersonName(event.getUser().getUserName());
        adeScencDTO.setLocale(LocaleContextHolder.getLocale().toString());
        adeScencDTO.setRequestTime(TimeUtils.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy-MM-dd HH:mm:ss"));
        adeScencDTO.setScene(event.getSceneDTO());
        adeScencDTO.setTemplateCode(MapUtils.getString(data, (Object)"templateCode"));
        adeScencDTO.setTarget(MapUtils.getString(data, (Object)"target"));
        adeScencDTO.setDimension(data.containsKey("dimension") ? MapUtils.getObject(data, (Object)"dimension") : Lists.newArrayList());
        adeScencDTO.setDimensionCnt(MapUtils.getInteger(data, (Object)"dimensionCnt", null));
        adeScencDTO.setEocMaps(eocMaps);
        adeScencDTO.setQuestion(event.getQuestion());
        adeScencDTO.setMessageId(String.valueOf(event.getGenerateSerialNo()));
        adeScencDTO.setMethod("dataflow");
        adeScencDTO.setProductLineInfo(event.getProductLineInfo());
        adeScencDTO.setProductVersion(event.getProductVersion());
        adeScencDTO.setSaveTransResult(event.getSaveTransResult());
        return adeScencDTO;
    }

    public void saveQuerySchemaErrorByCode(AthenaMessageEvent event, List<String> sentences) {
        HashMap<String, String> msgBody = new HashMap<String, String>();
        String sysError = this.messageUtil.getMessageByLangNameWithFormat("message.system.schema.error", event.getLang(), new Object[0]);
        msgBody.put("prompt", sysError);
        this.semcService.sendMessageToGpt(event, msgBody);
        this.saveAbnormalLog(event, sysError, Integer.valueOf(1), Integer.valueOf(0));
    }

    public void saveAbnormalLog(AthenaMessageEvent event, String errorMessage, Integer type, Integer success) {
        AgileDataLogEvent agileDataLogEvent = new AgileDataLogEvent();
        String combinationQuestion = event.getCombinationQuestion();
        String question2 = event.getQuestion();
        Long generateSerialNo = event.getGenerateSerialNo();
        if (StringUtils.isNotEmpty((CharSequence)combinationQuestion)) {
            question2 = combinationQuestion;
        }
        agileDataLogEvent.setQuestion(question2);
        agileDataLogEvent.setGenerateSerialNo(generateSerialNo);
        agileDataLogEvent.setErrorAnswer(errorMessage);
        agileDataLogEvent.setAuthoredUser(event.getUser());
        agileDataLogEvent.setTerminal(event.getTerminal());
        if ("1".equals(event.getMessageType()) || "3".equals(event.getMessageType()) || "5".equals(event.getMessageType()) || "10".equals(event.getMessageType())) {
            agileDataLogEvent.setSuccess(Integer.valueOf(1));
        } else {
            agileDataLogEvent.setSuccess(success);
        }
        agileDataLogEvent.setType(type);
        agileDataLogEvent.setAskTime(event.getAskTime());
        agileDataLogEvent.setAnswerTime(LocalDateTime.now());
        agileDataLogEvent.setAdeScencDTO(event.getAdeScencDTO());
        agileDataLogEvent.setPtxId(event.getPtxId());
        agileDataLogEvent.setSourceCode(event.getSourceCode());
        agileDataLogEvent.setSourceName(event.getSourceName());
        agileDataLogEvent.setApplicationCode(event.getAppCode());
        agileDataLogEvent.setApplicationName(event.getAppName());
        agileDataLogEvent.setLogSaveSuccess("N");
        agileDataLogEvent.setReason("");
        agileDataLogEvent.setProductVersion(event.getProductVersion());
        this.agileDataLogService.saveAgileDataLog(agileDataLogEvent);
    }

    public String getKmCodeByEventOrSchemaData(AthenaMessageEvent event, Map<String, Object> data) {
        if (CollectionUtils.isNotEmpty((Collection)event.getScenes())) {
            return MapUtils.getString((Map)((Map)event.getScenes().get(0)), (Object)"sceneCode");
        }
        return MapUtils.getString(data, (Object)"sceneCode");
    }

    public String getServiceNameByMessageType(AthenaMessageEvent event) {
        String serviceName;
        switch (serviceName = event.getMessageType()) {
            case "0": 
            case "1": 
            case "3": 
            case "5": 
            case "6": {
                serviceName = SchemaDataEnum.DESIGNER.getCode();
                break;
            }
            case "2": {
                serviceName = SchemaDataEnum.DEBUG.getCode();
                break;
            }
            case "4": {
                serviceName = SchemaDataEnum.PARAM.getCode();
                break;
            }
            case "8": {
                serviceName = SchemaDataEnum.MOCK.getCode();
                break;
            }
            case "9": {
                serviceName = SchemaDataEnum.SPECIAL.getCode();
                break;
            }
            case "10": {
                serviceName = SchemaDataEnum.SPECIAL_LITE.getCode();
                break;
            }
            case "11": {
                serviceName = SchemaDataEnum.METRIC_DEBUG.getCode();
                break;
            }
            case "12": {
                serviceName = SchemaDataEnum.PPT_ANALYZE.getCode();
                break;
            }
            case "13": {
                serviceName = SchemaDataEnum.PPT_GENERATE.getCode();
                break;
            }
            case "14": {
                serviceName = SchemaDataEnum.AUTODATA_REPORT.getCode();
                break;
            }
            case "15": {
                serviceName = SchemaDataEnum.AUTO_DATA_QUESTION.getCode();
                break;
            }
            case "16": {
                serviceName = SchemaDataEnum.AI_BOARD_QUESTION.getCode();
                break;
            }
            case "17": {
                serviceName = SchemaDataEnum.ATTRIBUTION_SUMMARY.getCode();
                break;
            }
            default: {
                return SchemaDataEnum.DESIGNER.getCode();
            }
        }
        return serviceName;
    }

    public String getSseSchemaUrl(String schemaEnum) {
        String url = "";
        switch (schemaEnum) {
            case "debug": 
            case "param": 
            case "metric": 
            case "metric_app": 
            case "designer": 
            case "mock": 
            case "metric_debug": {
                url = this.adtEnvProperties.getChatBIUrl() + "/scrumbi/stream/chat";
                break;
            }
            case "special": {
                url = this.adtEnvProperties.getChatBIUrl() + "/scrumbi/chat/demo";
                break;
            }
            case "special_lite": {
                url = this.adtEnvProperties.getChatBIUrl() + "/scrumbi/chat/lite";
                break;
            }
            case "ppt_Analyze": {
                url = this.adtEnvProperties.getChatBIUrl() + "/scrumbi/question/planning";
                break;
            }
            case "ppt_Generate": {
                url = this.adtEnvProperties.getChatBIUrl() + "/scrumbi/ppt/genarate";
                break;
            }
            case "autoData_report": {
                url = this.adtEnvProperties.getChatBIUrl() + "/scrumbi/report/create";
                break;
            }
            case "auto_data_question": {
                url = this.adtEnvProperties.getChatBIUrl() + "";
                break;
            }
            case "ai_board_question": {
                url = this.adtEnvProperties.getChatBIUrl() + "/scrumbi/chart/plan";
                break;
            }
            case "attribution_summary": {
                url = this.adtEnvProperties.getChatBIUrl() + "/scrumbi/dataAttribution/report";
                break;
            }
            default: {
                return this.adtEnvProperties.getChatBIUrl() + "scrumbi/stream/chat";
            }
        }
        return url;
    }

    public String getServiceNameByQuerySchema(String router) {
        String serviceName = AgileDataEnum.DESIGNER.getCode();
        switch (router) {
            case "metric": {
                serviceName = AgileDataEnum.METRIC.getCode();
                break;
            }
            case "dataFlow": {
                serviceName = AgileDataEnum.DESIGNER.getCode();
                break;
            }
            case "mock": {
                serviceName = AgileDataEnum.MOCK.getCode();
                break;
            }
            case "special": {
                serviceName = AgileDataEnum.SPECIAL.getCode();
                break;
            }
            case "dataset": {
                serviceName = AgileDataEnum.DATASET.getCode();
                break;
            }
            case "ppt_Analyze": {
                serviceName = AgileDataEnum.PPT_ANALYZE.getCode();
                break;
            }
            case "ppt_process": {
                serviceName = AgileDataEnum.PPT_PROCESS.getCode();
                break;
            }
            case "autoData_report": {
                serviceName = AgileDataEnum.AUTODATA_REPORT.getCode();
                break;
            }
            case "ai_board_analyze": {
                serviceName = AgileDataEnum.AI_BOARD_ANALYZE.getCode();
                break;
            }
            case "ai_board_question": {
                serviceName = AgileDataEnum.AI_BOARD_QUESTION.getCode();
                break;
            }
            default: {
                return serviceName;
            }
        }
        return serviceName;
    }

    public void saveAbnormal(AthenaMessageEvent event, String tipMessage, Integer success) {
        AgileDataLogEvent agileDataLogEvent = new AgileDataLogEvent();
        String question2 = event.getQuestion();
        String combinationQuestion = event.getCombinationQuestion();
        Long generateSerialNo = event.getGenerateSerialNo();
        if (StringUtils.isNotEmpty((CharSequence)event.getCombinationQuestion())) {
            question2 = combinationQuestion;
        }
        agileDataLogEvent.setQuestion(question2);
        agileDataLogEvent.setGenerateSerialNo(generateSerialNo);
        agileDataLogEvent.setErrorAnswer(tipMessage);
        agileDataLogEvent.setAuthoredUser(event.getUser());
        agileDataLogEvent.setTerminal(event.getTerminal());
        agileDataLogEvent.setSuccess(success);
        agileDataLogEvent.setType(Integer.valueOf(1));
        agileDataLogEvent.setAskTime(event.getAskTime());
        agileDataLogEvent.setAnswerTime(LocalDateTime.now());
        agileDataLogEvent.setAdeScencDTO(event.getAdeScencDTO());
        agileDataLogEvent.setPtxId(event.getPtxId());
        agileDataLogEvent.setSourceCode(event.getSourceCode());
        agileDataLogEvent.setSourceName(event.getSourceName());
        agileDataLogEvent.setApplicationCode(event.getAppCode());
        agileDataLogEvent.setApplicationName(event.getAppName());
        agileDataLogEvent.setLogSaveSuccess("N");
        agileDataLogEvent.setReason("");
        agileDataLogEvent.setProductVersion(event.getProductVersion());
        this.agileDataLogService.saveAgileDataLog(agileDataLogEvent);
    }

    public void saveQuestionData(Map<String, Object> data, AthenaMessageEvent event, String question2, String combinationQuestion, Long generateSerialNo) {
        AgileDataLogEvent agileDataLogEvent = new AgileDataLogEvent();
        agileDataLogEvent.setAuthoredUser(event.getUser());
        if (StringUtils.isNotEmpty((CharSequence)combinationQuestion)) {
            question2 = combinationQuestion;
        }
        agileDataLogEvent.setQuestion(question2);
        agileDataLogEvent.setGenerateSerialNo(generateSerialNo);
        agileDataLogEvent.setTerminal(event.getTerminal());
        agileDataLogEvent.setLocal(event.getLang());
        agileDataLogEvent.setAskTime(event.getAskTime());
        agileDataLogEvent.setAnswerTime(LocalDateTime.now());
        agileDataLogEvent.setAdeScencDTO(event.getAdeScencDTO());
        agileDataLogEvent.setPtxId(event.getPtxId());
        agileDataLogEvent.setSourceCode(event.getSourceCode());
        agileDataLogEvent.setSourceName(event.getSourceName());
        agileDataLogEvent.setApplicationCode(event.getAppCode());
        agileDataLogEvent.setApplicationName(event.getAppName());
        agileDataLogEvent.setLogSaveSuccess("N");
        agileDataLogEvent.setReason("");
        agileDataLogEvent.setProductVersion(event.getProductVersion());
        this.agileDataLogService.saveQuestionData(data, agileDataLogEvent);
    }

    public void saveWarnQuestionData(AthenaMessageEvent event, String msg) {
        AgileDataLog agileDataLog = new AgileDataLog();
        agileDataLog.setUserId(event.getUser().getUserId());
        agileDataLog.setUserName(event.getUser().getUserName());
        agileDataLog.setTenantId(event.getUser().getTenantId());
        agileDataLog.setTenantName(event.getUser().getTenantName());
        agileDataLog.setTerminal(event.getTerminal());
        agileDataLog.setGenerateSerialNo(event.getGenerateSerialNo());
        agileDataLog.setQuestion(event.getQuestion());
        agileDataLog.setSuccess(Integer.valueOf(2));
        agileDataLog.setSourceCode(event.getSourceCode());
        agileDataLog.setSourceName(event.getSourceName());
        agileDataLog.setLogSaveSuccess("N");
        agileDataLog.setErrorAnswer(msg);
        agileDataLog.setCreateTime(event.getAskTime());
        agileDataLog.setAnswerTime(LocalDateTime.now());
        agileDataLog.setResSecTime(DateUtils.calculateAndSetDuration((LocalDateTime)event.getAskTime(), (LocalDateTime)agileDataLog.getAnswerTime()));
        agileDataLog.setProductVersion(event.getProductVersion());
        this.agileDataLogMapper.insert((Object)agileDataLog);
    }

    public void sendMessageAndSaveLogByCost(AthenaMessageEvent event, String businessType) {
        HashMap<String, String> msgBody = new HashMap<String, String>();
        String warnStr = this.messageUtil.getMessageByLangName(businessType, event.getLang());
        msgBody.put("prompt", warnStr);
        this.saveAbnormalLog(event, warnStr, Integer.valueOf(1), Integer.valueOf(2));
        if (event.isSendNana()) {
            this.semcService.sendMessageToGpt(event, msgBody);
        }
    }

    public void saveBuiltClassifications(AthenaMessageEvent event, Map<String, Object> response) {
        Map bizParams;
        Map contextMap;
        Map snapshot = MapUtils.getMap(response, (Object)"data");
        if (snapshot != null && (contextMap = MapUtils.getMap((Map)snapshot, (Object)"context")) != null && (bizParams = MapUtils.getMap((Map)contextMap, (Object)"bizParams")) != null) {
            List classifications;
            List list = classifications = Objects.isNull(bizParams.get("builtClassifications")) ? new ArrayList() : (List)bizParams.get("builtClassifications");
            if (CollectionUtils.isNotEmpty(classifications)) {
                for (int i = 0; i < classifications.size(); ++i) {
                    AgileDataClassifications agileDataClassifications = new AgileDataClassifications();
                    agileDataClassifications.setClassName(String.valueOf(((Map)classifications.get(i)).get("name")));
                    agileDataClassifications.setClassCode(String.valueOf(((Map)classifications.get(i)).get("code")));
                    agileDataClassifications.setCreateDate(new Date());
                    agileDataClassifications.setMessageId(event.getGenerateSerialNo());
                    agileDataClassifications.setUserId(event.getUser().getUserId());
                    agileDataClassifications.setTenantId(event.getUser().getTenantId());
                    agileDataClassifications.setSort(Integer.valueOf(i + 1));
                    this.agileDataClassificationsService.insert(agileDataClassifications, event.getUser());
                }
            }
        }
    }

    public Pair<Boolean, Integer> isDataProcessAction(Map<String, Object> data) {
        SnapShotDTO snapShotDTO = (SnapShotDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString(data), SnapShotDTO.class);
        if (Objects.nonNull(snapShotDTO) && Objects.nonNull(snapShotDTO.getContext()) && Objects.nonNull(snapShotDTO.getContext().getBizParams()) && StringUtils.isNotEmpty((CharSequence)snapShotDTO.getContext().getBizParams().getDataProcessAction()) && "interception".equals(snapShotDTO.getContext().getBizParams().getDataProcessAction()) && Objects.nonNull(snapShotDTO.getContext().getBizParams().getInterceptSize())) {
            return Pair.of((Object)true, (Object)snapShotDTO.getContext().getBizParams().getInterceptSize());
        }
        return Pair.of((Object)false, (Object)0);
    }

    public void getEssentialFactorAndSendSseMessage(AthenaMessageEvent event, Map<String, Object> param, AtomicBoolean state, CountDownLatch returnResultLatch) {
        if (!event.isSseMessage()) {
            returnResultLatch.countDown();
            return;
        }
        String sseProductVersion = event.getSseProductVersion();
        try {
            Map response = this.adeService.getEssentialFactor(event, param);
            if (response == null || Objects.isNull(response.get("msg"))) {
                EventData.EventMessage toolResponse = EventData.EventMessage.builderMessageClose((String)"tool_response", (String)event.getSseCallId(), (String)"fail");
                this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(), event.getSseEmitter(), toolResponse);
                this.sendSseGetSnapshotMessage(event);
                returnResultLatch.countDown();
                return;
            }
            if ("V1".equals(sseProductVersion)) {
                this.essentialFactorSendByV1(event, response, returnResultLatch, state);
            } else {
                this.essentialFactorSendByV2(event, response, returnResultLatch, state);
            }
        }
        catch (Exception e) {
            log.error("ade message getEssentialFactor error: {}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
        }
    }

    private void essentialFactorSendByV1(AthenaMessageEvent event, Map<String, Object> response, CountDownLatch returnResultLatch, AtomicBoolean state) {
        try {
            SseEmitter sseEmitter = event.getSseEmitter();
            Object msg = response.get("data");
            String msgStr = String.valueOf(msg);
            String[] answerSplit = msgStr.split("");
            if (StringUtils.isEmpty((CharSequence)msgStr)) {
                EventData.EventMessage toolResponse = EventData.EventMessage.builderMessageClose((String)"tool_response", (String)event.getSseCallId(), (String)"fail");
                this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(), sseEmitter, toolResponse);
                this.sendSseGetSnapshotMessage(event);
                returnResultLatch.countDown();
                return;
            }
            for (int i = 0; i < msgStr.length(); ++i) {
                EventData.EventMessage toolResponse;
                if (state.get()) {
                    EventData.EventMessage msgSub = EventData.EventMessage.builderMessage((String)"function_answer", (Object)msgStr.substring(i), (String)event.getSseCallId());
                    this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(), sseEmitter, msgSub);
                    toolResponse = EventData.EventMessage.builderMessageClose((String)"tool_response", (String)event.getSseCallId(), (String)"success");
                    this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(), sseEmitter, toolResponse);
                    this.sendSseGetSnapshotMessage(event);
                    returnResultLatch.countDown();
                    break;
                }
                Thread.sleep(30L);
                EventData.EventMessage msgSplit = EventData.EventMessage.builderMessage((String)"function_answer", (Object)answerSplit[i], (String)event.getSseCallId());
                this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(), sseEmitter, msgSplit);
                if (i != msgStr.length() - 1) continue;
                toolResponse = EventData.EventMessage.builderMessageClose((String)"tool_response", (String)event.getSseCallId(), (String)"success");
                this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(), sseEmitter, toolResponse);
                this.sendSseGetSnapshotMessage(event);
                returnResultLatch.countDown();
            }
        }
        catch (Exception e) {
            log.error("ade message getEssentialFactor error: {}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
        }
    }

    private void essentialFactorSendByV2(AthenaMessageEvent event, Map<String, Object> response, CountDownLatch returnResultLatch, AtomicBoolean state) {
        try {
            SseEmitter sseEmitter = event.getSseEmitter();
            Object msg = response.get("data");
            String msgStr = String.valueOf(msg);
            String[] answerSplit = msgStr.split("");
            if (StringUtils.isEmpty((CharSequence)msgStr)) {
                EventData.EventMessage toolResponse = EventData.EventMessage.builderMessageCloseV2((String)"tool_response", (String)event.getSseCallId(), (String)"fail");
                this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(), sseEmitter, toolResponse);
                this.sendSseGetSnapshotMessage(event);
                returnResultLatch.countDown();
                return;
            }
            for (int i = 0; i < msgStr.length(); ++i) {
                EventData.EventMessage toolResponse;
                if (state.get()) {
                    EventData.EventMessage msgSub = EventData.EventMessage.builderMessageV2((String)"function_answer", (Object)msgStr.substring(i), (String)event.getSseCallId());
                    this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(), sseEmitter, msgSub);
                    toolResponse = EventData.EventMessage.builderMessageCloseV2((String)"tool_response", (String)event.getSseCallId(), (String)"success");
                    this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(), sseEmitter, toolResponse);
                    this.sendSseGetSnapshotMessage(event);
                    returnResultLatch.countDown();
                    break;
                }
                Thread.sleep(30L);
                EventData.EventMessage msgSplit = EventData.EventMessage.builderMessageV2((String)"function_answer", (Object)answerSplit[i], (String)event.getSseCallId());
                this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(), sseEmitter, msgSplit);
                if (i != msgStr.length() - 1) continue;
                toolResponse = EventData.EventMessage.builderMessageCloseV2((String)"tool_response", (String)event.getSseCallId(), (String)"success");
                this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(), sseEmitter, toolResponse);
                this.sendSseGetSnapshotMessage(event);
                returnResultLatch.countDown();
            }
        }
        catch (Exception e) {
            log.error("ade message getEssentialFactor error: {}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
        }
    }

    public void sendSseGetSnapshotMessage(AthenaMessageEvent event) {
        log.info("send \u53d6\u6570\u4f1a\u8bdd\u5f00\u59cb");
        HashMap<String, Object> messageObj = new HashMap<String, Object>();
        String messageTitle = this.messageUtil.getMessageByLangNameWithFormat("message.sse.getSnapshotMessage", event.getLang(), new Object[0]);
        messageObj.put("name", messageTitle);
        messageObj.put("arguments ", new HashMap());
        EventData.EventMessage eventMessage = "V1".equals(event.getSseProductVersion()) ? EventData.EventMessage.builderNewEventMessage((String)"function_call", messageObj, (AthenaMessageEvent)event) : EventData.EventMessage.builderNewEventMessageV2((String)"function_call", (Object)messageTitle, (AthenaMessageEvent)event);
        this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(), event.getSseEmitter(), eventMessage);
    }

    public void sendEventDataMessage(String sendEvent, SseEmitter sseEmitter, EventData.EventMessage eventMessage) {
        EventData eventData = new EventData(sendEvent, eventMessage);
        if (Objects.nonNull(sseEmitter)) {
            SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)eventData);
        }
    }

    public boolean checkUserAppPermission(AthenaMessageEvent event, String messageType) {
        if (!"asada".equals(event.getAsaCode()) || SchemaDataEnum.SPECIAL.getCode().equals(messageType) || SchemaDataEnum.SPECIAL_LITE.getCode().equals(messageType)) {
            return false;
        }
        String token = event.getUser().getToken();
        String tenantId = event.getUser().getTenantId();
        String userId = event.getUser().getUserId();
        List apps = this.kmService.queryKmPurchaseList(Integer.valueOf(1), token, tenantId, userId);
        return CollectionUtils.isEmpty((Collection)apps);
    }

    public Map<String, Object> parameterBasedOnVersion(QuerySchemaResDTO responseData, AthenaMessageEvent event) {
        String productVersion = event.getProductVersion();
        QuerySchemaMetricDTO metric = responseData.getData().getMetric();
        QuerySchemaDatasetDTO dataset = responseData.getData().getDataset();
        if ("V1".equals(productVersion)) {
            if (Objects.nonNull(metric)) {
                return CommonUtil.convertObjectToMap((Object)AdeMetricReqDTO.BuildMetricAdeReq((AthenaMessageEvent)event, (QuerySchemaMetricDTO)metric));
            }
            return CommonUtil.convertObjectToMap((Object)AdeDatasetReqDTO.BuildDatasetAdeReq((AthenaMessageEvent)event, (QuerySchemaDatasetDTO)dataset));
        }
        if ("V2".equals(productVersion)) {
            return CommonUtil.convertObjectToMap((Object)AdeDatasetReqDTO.BuildDatasetAdeReq((AthenaMessageEvent)event, (QuerySchemaDatasetDTO)dataset));
        }
        return CommonUtil.convertObjectToMap((Object)AdeMetricReqDTO.BuildMetricAdeReq((AthenaMessageEvent)event, (QuerySchemaMetricDTO)metric));
    }

    public void setDataSummary(Map<String, Object> response, AthenaMessageEvent event) {
        SnapShotDTO snapShotDTO = (SnapShotDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString(response), SnapShotDTO.class);
        Boolean exceedSummarizeSize = snapShotDTO.getContext().getBizParams().getExceedSummarizeSize();
        if (Objects.nonNull(exceedSummarizeSize)) {
            event.setExceedSummarizeSize(exceedSummarizeSize);
        }
    }

    public void executeStepAnalysis(AthenaMessageEvent event, Map<String, Object> response) {
        ArrayList steps = Lists.newArrayList();
        Map contextMap = MapUtils.getMap((Map)MapUtils.getMap(response, (Object)"data"), (Object)"context");
        Object step = contextMap.get("stepAnalysis");
        if (Objects.nonNull(step)) {
            steps.addAll((Collection)step);
        }
        if (CollectionUtils.isNotEmpty((Collection)steps)) {
            this.echoService.echoMongodbSubmit(EchoSubmitReq.builderStepAnalysis((AthenaMessageEvent)event, (List)steps), event.getUser().getToken(), event.getUser().getTenantId());
        }
    }

    public void setDataScreening(AthenaMessageEvent event, Map<String, Object> response) {
        Map contextMap = MapUtils.getMap((Map)MapUtils.getMap(response, (Object)"data"), (Object)"context");
        Optional.ofNullable(contextMap).map(ctx -> ctx.get("stepFilterAnalysis")).filter(obj -> obj instanceof List).map(obj -> (List)obj).filter(CollectionUtils::isNotEmpty).ifPresent(steps -> this.echoService.echoMongodbSubmit(EchoSubmitReq.builderStepFilterAnalysis((AthenaMessageEvent)event, (List)steps), event.getUser().getToken(), event.getUser().getTenantId()));
    }

    public AthenaMessageEvent initEvent(String appCode, String question2, List<String> datasetIds, AuthoredUser user) {
        HashMap athenaMessage = new HashMap();
        HashMap<String, Object> extData = new HashMap<String, Object>();
        extData.put("msg", question2);
        extData.put("asaCode", appCode);
        extData.put("probe", false);
        extData.put("datasetIdList", datasetIds);
        athenaMessage.put("msgExt", extData);
        HashMap<String, String> msgBody = new HashMap<String, String>();
        msgBody.put("text", question2);
        athenaMessage.put("msgBody", msgBody);
        AthenaMessageDTO athenaMessageDTO = (AthenaMessageDTO)CommonUtil.mapToObject(athenaMessage, AthenaMessageDTO.class);
        athenaMessageDTO.setAppCode(appCode);
        return this.init(null, athenaMessageDTO, user);
    }

    public void updatePPTDataByError(AthenaMessageEvent event, Map<String, Object> processStreamData, Map<String, Object> errorQueryData) {
        AgileDataFileDTO agileDataFileDTO = new AgileDataFileDTO();
        agileDataFileDTO.setMessageId(Long.valueOf(event.getMsgExt().get("pptMessageId").toString()));
        ArrayList<AgileDataFileDTO.AgileDataFileQuestionDTO> questionDTOS = new ArrayList<AgileDataFileDTO.AgileDataFileQuestionDTO>();
        AgileDataFileDTO.AgileDataFileQuestionDTO questionDTO = new AgileDataFileDTO.AgileDataFileQuestionDTO();
        questionDTO.setQuestionId(Long.valueOf(event.getMsgExt().get("pptQuestionId").toString()));
        questionDTO.setAnalyzeStatus(Integer.valueOf(1));
        questionDTO.setAnalyzeMessageId(event.getGenerateSerialNo());
        AgileDataFileDTO.AgileDataFileAnalyzeDTO analyzeDTO = new AgileDataFileDTO.AgileDataFileAnalyzeDTO();
        if (MapUtils.isNotEmpty(processStreamData)) {
            analyzeDTO = (AgileDataFileDTO.AgileDataFileAnalyzeDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString(processStreamData), AgileDataFileDTO.AgileDataFileAnalyzeDTO.class);
            if (MapUtils.isNotEmpty(errorQueryData)) {
                analyzeDTO.setQueryData(errorQueryData);
            }
            questionDTO.setAnalyzeResult(analyzeDTO);
        } else {
            analyzeDTO.setQueryData(errorQueryData);
            questionDTO.setAnalyzeResult(analyzeDTO);
        }
        questionDTOS.add(questionDTO);
        agileDataFileDTO.setQuestionInfo(questionDTOS);
        log.info("\u66f4\u65b0ppt\u6267\u884c\u6b65\u9aa4\u548c\u72b6\u6001\u5165\u53c2 eventQuestionId :{},: data:{}", (Object)event.getGenerateSerialNo(), (Object)JsonUtils.objectToString((Object)agileDataFileDTO));
        this.echoService.updateAgileDataFile(agileDataFileDTO, event.getUser().getToken(), event.getUser().getTenantId());
    }

    public void updateAIBoardDataByError(AthenaMessageEvent event, Map<String, Object> processStreamData, Map<String, Object> errorQueryData) {
        AIBoardDTO aiBoardDTO = new AIBoardDTO();
        aiBoardDTO.setMessageId(Long.valueOf(event.getMsgExt().get("aiBoardMessageId").toString()));
        ArrayList<AIBoardDTO.AIBoardQuestionDTO> questionDTOS = new ArrayList<AIBoardDTO.AIBoardQuestionDTO>();
        AIBoardDTO.AIBoardQuestionDTO questionDTO = new AIBoardDTO.AIBoardQuestionDTO();
        questionDTO.setQuestionId(Long.valueOf(event.getMsgExt().get("aiBoardQuestionId").toString()));
        questionDTO.setAnalyzeStatus(Integer.valueOf(1));
        questionDTO.setAnalyzeMessageId(event.getGenerateSerialNo());
        AIBoardDTO.AIBoardAnalyzeDTO analyzeDTO = new AIBoardDTO.AIBoardAnalyzeDTO();
        if (MapUtils.isNotEmpty(processStreamData)) {
            analyzeDTO = (AIBoardDTO.AIBoardAnalyzeDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString(processStreamData), AIBoardDTO.AIBoardAnalyzeDTO.class);
            if (MapUtils.isNotEmpty(errorQueryData)) {
                analyzeDTO.setQueryData(errorQueryData);
            }
            questionDTO.setAnalyzeResult(analyzeDTO);
        } else {
            analyzeDTO.setQueryData(errorQueryData);
            questionDTO.setAnalyzeResult(analyzeDTO);
        }
        questionDTOS.add(questionDTO);
        aiBoardDTO.setQuestionInfo(questionDTOS);
        log.info("\u66f4\u65b0\u5bf9\u8bdd\u770b\u677f\u6267\u884c\u6b65\u9aa4\u548c\u72b6\u6001\u5165\u53c2 eventQuestionId :{},: data:{}", (Object)event.getGenerateSerialNo(), (Object)JsonUtils.objectToString((Object)aiBoardDTO));
        this.echoService.updateAIBoard(aiBoardDTO, event.getUser().getToken(), event.getUser().getTenantId());
    }
}

