/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.agileData;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.controller.dto.ScrumBIBoardDTO;
import com.digiwin.athena.adt.agileReport.event.domain.SendMessageDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.AgileDataType;
import com.digiwin.athena.adt.agileReport.service.AgileDataProcessService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.domain.dto.aiBoard.AIBoardDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaDataDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.sse.domain.EventData;
import com.digiwin.athena.adt.sse.domain.SseAniaEventEnum;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@AgileDataType(value=AgileDataEnum.AI_BOARD_QUESTION)
public class AgileDataProcessAIBoardQuestionServiceImpl
extends AbsAgileDataProcess
implements AgileDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataProcessAIBoardQuestionServiceImpl.class);
    @Autowired
    private SemcService semcService;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private EchoService echoService;

    public void process(AthenaMessageEvent event, QuerySchemaResDTO querySchemaResDTO) {
        HashMap msgBody = Maps.newHashMap();
        QuerySchemaDataDTO querySchemaDataDTO = querySchemaResDTO.getData();
        if (querySchemaDataDTO == null) {
            msgBody.put("prompt", this.messageUtil.getMessageByLangNameWithFormat("message.adt.aiBoard.error", event.getLang(), new Object[0]));
            msgBody.put("answerModel", "replay");
            this.semcService.sendMessageToGpt(event, (Map)msgBody);
            return;
        }
        ScrumBIBoardDTO scrumBIBoardDTO = new ScrumBIBoardDTO();
        scrumBIBoardDTO.setBoardTitle(querySchemaDataDTO.getBoardTitle());
        scrumBIBoardDTO.setBoardDesign(querySchemaDataDTO.getBoardDesign());
        scrumBIBoardDTO.setTips(querySchemaDataDTO.getTips());
        scrumBIBoardDTO.setTitle(querySchemaDataDTO.getTitle());
        this.analyzeAIBoardData(event, scrumBIBoardDTO);
        msgBody.put("analyzeResult", true);
        msgBody.put("dataTipMessage", scrumBIBoardDTO.getTips());
        msgBody.put("boardData", scrumBIBoardDTO);
        msgBody.put("answerModel", "analyzeResult");
        this.semcService.sendMessageToGpt(event, (Map)msgBody);
    }

    private void analyzeAIBoardData(AthenaMessageEvent event, ScrumBIBoardDTO scrumBIBoardDTO) {
        AIBoardDTO aiBoardDTO = new AIBoardDTO();
        if (StringUtils.isNotEmpty((CharSequence)scrumBIBoardDTO.getTitle())) {
            EventData.EventMessage eventMessage = EventData.EventMessage.builderAnswerTextMessage((Object)scrumBIBoardDTO.getTitle());
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(), event.getSseEmitter(), eventMessage);
        }
        aiBoardDTO.setBoardTitle(scrumBIBoardDTO.getBoardTitle());
        StringBuilder markDownTitle = new StringBuilder("\n### **");
        markDownTitle.append(scrumBIBoardDTO.getBoardTitle());
        markDownTitle.append("**");
        markDownTitle.append("\n");
        EventData.EventMessage eventMessage = EventData.EventMessage.builderAnswerTextMessage((Object)markDownTitle.toString());
        this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(), event.getSseEmitter(), eventMessage);
        ArrayList questionInfos = Lists.newArrayList();
        aiBoardDTO.setAppCode(event.getAppCode());
        aiBoardDTO.setMessageId(event.getGenerateSerialNo());
        aiBoardDTO.setQuestionInfo((List)questionInfos);
        aiBoardDTO.setMessageStatus(Integer.valueOf(0));
        if (CollectionUtils.isNotEmpty((Collection)scrumBIBoardDTO.getBoardDesign())) {
            scrumBIBoardDTO.getBoardDesign().stream().forEach(boardDesign -> {
                AIBoardDTO.AIBoardQuestionDTO questionDTO = this.buildAIBoardQuestionDTO(boardDesign);
                questionInfos.add(questionDTO);
                this.contentStream(event, boardDesign.getShowContent());
                HashMap msgBody = Maps.newHashMap();
                msgBody.put("questionId", questionDTO.getQuestionId());
                msgBody.put("answerModel", "questionAnalyze");
                SendMessageDTO sendMessageDTO = this.semcService.getSendMessageDTO(event, (Map)msgBody);
                EventData.EventMessage cardMessage = EventData.EventMessage.builderAnswerMessageV2((Object)sendMessageDTO);
                this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(), event.getSseEmitter(), cardMessage);
            });
        }
        this.echoService.addAIBoard(aiBoardDTO, event.getUser().getToken(), event.getUser().getTenantId());
    }

    private void contentStream(AthenaMessageEvent event, String content) {
        int chunkSize;
        Random random = new Random();
        int totalLength = content.length();
        for (int index = 0; index < totalLength; index += chunkSize) {
            int remaining = totalLength - index;
            if (random == null) break;
            chunkSize = random.nextInt(Math.min(10, remaining)) + 1;
            String chunk = content.substring(index, index + chunkSize);
            EventData.EventMessage eventMessage = EventData.EventMessage.builderAnswerTextMessage((Object)chunk);
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(), event.getSseEmitter(), eventMessage);
            try {
                Thread.sleep(50L + (long)random.nextInt(100));
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    private AIBoardDTO.AIBoardQuestionDTO buildAIBoardQuestionDTO(ScrumBIBoardDTO.BoardDesign boardDesign) {
        AIBoardDTO.AIBoardQuestionDTO aiBoardQuestionDTO = new AIBoardDTO.AIBoardQuestionDTO();
        aiBoardQuestionDTO.setQuestionId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
        aiBoardQuestionDTO.setQuestion(boardDesign.getQuestion());
        aiBoardQuestionDTO.setChartTitle(boardDesign.getChartTitle());
        aiBoardQuestionDTO.setShowType(boardDesign.getChartType());
        aiBoardQuestionDTO.setDatasetIds(boardDesign.getDataSetId());
        return aiBoardQuestionDTO;
    }
}

