/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.agileData;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.AgileDataType;
import com.digiwin.athena.adt.agileReport.service.AgileDataProcessService;
import com.digiwin.athena.adt.domain.dmc.DmcService;
import com.digiwin.athena.adt.domain.dto.UploadAttachmentResp;
import com.digiwin.athena.adt.domain.dto.UploadParamDTO;
import com.digiwin.athena.adt.domain.dto.autoData.AgileDataAutoDataDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.file.FileParsingService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.sse.utils.SseEmitterUtils;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service
@AgileDataType(value=AgileDataEnum.AUTODATA_REPORT)
public class AgileDataProcessAutoDataReportServiceImpl
implements AgileDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataProcessAutoDataReportServiceImpl.class);
    @Autowired
    private EchoService echoService;
    @Autowired
    private SemcService semcService;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private FileParsingService fileParsingService;
    @Autowired
    private DmcService dmcService;

    public void process(AthenaMessageEvent event, QuerySchemaResDTO querySchemaResDTO) {
        AgileDataAutoDataDTO agileDataAutoDataDTO = new AgileDataAutoDataDTO();
        Long messageId = MapUtils.getLong((Map)event.getMsgExt(), (Object)"autoDataMessageId");
        agileDataAutoDataDTO.setMessageId(messageId);
        Map processStreamData = querySchemaResDTO.getProcessStreamData();
        if (MapUtils.isEmpty((Map)processStreamData)) {
            agileDataAutoDataDTO.setStatus("1");
            this.echoService.updateAutoDataReport(event.getUser(), agileDataAutoDataDTO);
            SseEmitterUtils.sendAnswerDone((SseEmitter)event.getSseEmitter(), (boolean)false);
            return;
        }
        UploadParamDTO uploadParamDTO = new UploadParamDTO();
        uploadParamDTO.setFileJson(JsonUtils.objectToString((Object)processStreamData));
        uploadParamDTO.setFileName(String.valueOf(messageId));
        UploadAttachmentResp uploadAttachmentResp = this.dmcService.uploadAgileData(uploadParamDTO, event.getUser());
        if (uploadAttachmentResp == null) {
            agileDataAutoDataDTO.setStatus("1");
            this.echoService.updateAutoDataReport(event.getUser(), agileDataAutoDataDTO);
            SseEmitterUtils.sendAnswerDone((SseEmitter)event.getSseEmitter(), (boolean)false);
            return;
        }
        agileDataAutoDataDTO.setShowDmcId(uploadAttachmentResp.getId());
        agileDataAutoDataDTO.setStatus("0");
        this.echoService.updateAutoDataReport(event.getUser(), agileDataAutoDataDTO);
        SseEmitterUtils.sendAnswerDone((SseEmitter)event.getSseEmitter(), (boolean)true);
    }
}

