/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.agileData;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.AgileDataType;
import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateCostService;
import com.digiwin.athena.adt.agileReport.service.AgileDataCostDetailService;
import com.digiwin.athena.adt.agileReport.service.AgileDataProcessService;
import com.digiwin.athena.adt.agileReport.service.AgileReportService;
import com.digiwin.athena.adt.agileReport.service.SnapShotDataService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.KMScencDTO;
import com.digiwin.athena.adt.domain.dto.SnapDataInfoDTO;
import com.digiwin.athena.adt.domain.dto.ade.ADEScencDTO;
import com.digiwin.athena.adt.domain.dto.echo.EchoSubmitReq;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.knowledge.KmService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.adt.util.agileData.AgileDataAnalysisUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@AgileDataType(value=AgileDataEnum.DESIGNER)
public class AgileDataProcessDesignerServiceImpl
extends AbsAgileDataProcess
implements AgileDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataProcessDesignerServiceImpl.class);
    @Resource
    private ADEService adeService;
    @Autowired
    private SemcService semcService;
    @Autowired
    private KmService kmService;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private AgileDataCalculateCostService agileDataCalculateCostService;
    @Autowired
    private EchoService echoService;
    @Autowired
    private AgileReportService agileReportService;
    @Autowired
    private AgileDataCostDetailService agileDataCostDetailService;
    @Autowired
    private SnapShotDataService snapShotDataService;

    public void process(AthenaMessageEvent event, QuerySchemaResDTO responseData) {
        String snapId = MapUtils.getString((Map)event.getMsgBody(), (Object)"snapshotId", null);
        if (!StringUtils.isEmpty((CharSequence)snapId)) {
            log.info("\u5feb\u7167ID\uff1a{},\u5904\u7406\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)snapId, (Object)TimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss:SSS"));
        }
        String question2 = event.getQuestion();
        long getQuerySchemaTook = System.currentTimeMillis();
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u95ee\u53e5\u5165\u53c2\uff1a{}", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), question2, JsonUtils.objectToString((Object)event.getMsgBody())});
        LogDto logDto = new LogDto("\u83b7\u53d6\u610f\u56fe\u8bc6\u522b\u6570\u636e\uff1a" + JsonUtils.objectToString((Object)responseData));
        log.info(logDto.toString());
        try {
            for (Map data : responseData.getData().getDataflow()) {
                if (Objects.nonNull(data.get("code")) && (Integer)data.get("code") == 1) {
                    String kmCode = this.getKmCodeByEventOrSchemaData(event, data);
                    ADEScencDTO adeScencDTO = this.buildCommonAdeScene(event, data);
                    HashMap sceneMap = Maps.newHashMap();
                    sceneMap.put("templateCode", adeScencDTO.getTemplateCode());
                    sceneMap.put("targetId", adeScencDTO.getTarget());
                    sceneMap.put("dimension", adeScencDTO.getDimension());
                    log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u83b7\u53d6KM\u573a\u666f\uff0c\u5165\u53c2\uff1a{}", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), question2, JsonUtils.objectToString((Object)sceneMap)});
                    log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u83b7\u53d6KM\u573a\u666f\uff0c\u51fa\u53c2\uff1a{}", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), question2, JsonUtils.objectToString((Object)event.getScenes())});
                    if (StringUtils.isEmpty((CharSequence)kmCode)) {
                        HashMap errorMap = Maps.newHashMap();
                        errorMap.put("message", "\u573a\u666f\u4e0d\u5b58\u5728");
                        this.saveQuerySchemaErrorByCode(event, null);
                        continue;
                    }
                    adeScencDTO.setSceneCode(kmCode);
                    HashMap recastData = new HashMap();
                    recastData.put(kmCode, data.get("data"));
                    adeScencDTO.setRecast(recastData);
                    this.sendMessageToAde(event, adeScencDTO);
                    this.agileDataCostDetailService.saveAgileDataCostDetail(data, event.getUser(), event.getPtxId(), event.getAppCode(), event.getAppName(), event.getSourceName());
                    continue;
                }
                HashMap<String, String> msgBody = new HashMap<String, String>();
                msgBody.put("prompt", MapUtils.getString((Map)data, (Object)"data"));
                Object obj = MapUtils.getObject((Map)data, (Object)"sentences", null);
                event.setAnswerResult(Integer.valueOf(2));
                if (obj instanceof Collection) {
                    event.setSentences(CommonUtil.objConvertListString((Object)obj));
                }
                this.saveAbnormalLog(event, MapUtils.getString((Map)data, (Object)"data"), Integer.valueOf(1), Integer.valueOf(0));
                this.semcService.sendMessageToGpt(event, msgBody);
            }
        }
        catch (Exception e) {
            log.error("agiledata_ADT AgileDataProcessDesignerServiceImpl Exception : {}", (Object)e.getMessage());
            HashMap errorMap = Maps.newHashMap();
            errorMap.put("message", JsonUtils.objectToString((Object)e.getMessage()));
            this.saveQuerySchemaErrorByCode(event, null);
        }
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u95ee\u53e5\u51fa\u53c2\uff1a{},\u8017\u65f6:{}ms", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), question2, JsonUtils.objectToString((Object)event.getMsgBody()), System.currentTimeMillis() - getQuerySchemaTook});
    }

    public void sendMessageToAde(AthenaMessageEvent event, ADEScencDTO adeScencDTO) {
        AuthoredUser user = event.getUser();
        String question2 = event.getQuestion();
        String combinationQuestion = event.getCombinationQuestion();
        Long generateSerialNo = event.getGenerateSerialNo();
        Map response = new HashMap();
        try {
            boolean isCheck;
            List<Object> relatedIntentions = new ArrayList();
            String snapId = MapUtils.getString((Map)event.getMsgBody(), (Object)"snapshotId", null);
            if (StringUtils.isNotEmpty((CharSequence)snapId)) {
                adeScencDTO.setSnapshotId(snapId);
            }
            response = this.adeService.getRealtimeSnapShotData(user, adeScencDTO, event);
            LogUtils.buildAgileLog((String)"adt", (String)"getData", (String)"1", (String)JsonUtils.objectToString(response), (String)"", (String)"");
            Map data = MapUtils.getMap(response, (Object)"data");
            HashMap sendMap = Maps.newHashMap();
            if (data != null) {
                SnapDataInfoDTO snapDataInfoDTO;
                Pair interception = this.isDataProcessAction(data);
                if (((Boolean)interception.getLeft()).booleanValue()) {
                    this.echoService.echoMongodbSubmit(EchoSubmitReq.builderInterception((AthenaMessageEvent)event, (MessageUtil)this.messageUtil, (Integer)((Integer)interception.getRight())), event.getUser().getToken(), event.getUser().getTenantId());
                }
                String snapshotId = MapUtils.getString((Map)data, (Object)"snapshotId");
                sendMap.put("snapshotId", snapshotId);
                event.setAdeScencDTO(adeScencDTO);
                Integer defaultShowType = AgileDataAnalysisUtils.getSceneDefaultShowType((Map)data);
                if (defaultShowType == 1 && (snapDataInfoDTO = this.snapShotDataService.getSnapDataInfoBySnapshotId(user.getTenantId(), user.getUserId(), snapshotId)) != null) {
                    defaultShowType = this.echoService.getSceneShowType(snapDataInfoDTO, user.getToken(), user.getTenantId());
                }
                AgileDataAnalysisUtils.getTransShowInfo((Map)data, (Map)sendMap, (Integer)defaultShowType);
            } else {
                String errorMsg = MapUtils.getString(response, (Object)"msg");
                sendMap.put("prompt", errorMsg);
                String tipMessage = this.messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error", event.getLang(), new Object[0]);
                this.saveAbnormal(event, tipMessage, Integer.valueOf(0));
            }
            if (StringUtils.isNotEmpty((CharSequence)adeScencDTO.getSceneCode())) {
                long getKmTookTime = System.currentTimeMillis();
                KMScencDTO kmScencDTO = this.kmService.getKmSceneInfo(event, adeScencDTO.getSceneCode(), event.getLang(), user.getToken(), user.getTenantId());
                long kmTook = System.currentTimeMillis() - getKmTookTime;
                log.info("shouldSentToAde.sendMessageToAde -> getKmSceneInfo took:{}", (Object)kmTook);
                if (kmScencDTO != null && StringUtils.isNotEmpty((CharSequence)kmScencDTO.getRelatedIntentions())) {
                    relatedIntentions = Arrays.asList(kmScencDTO.getRelatedIntentions().split(";"));
                    sendMap.put("intentions", relatedIntentions);
                    event.setAnswerResult(Integer.valueOf(1));
                    event.setSentences(relatedIntentions);
                }
            }
            this.agileReportService.executeAgileDataByTokenSize(user, event, data);
            this.saveBuiltClassifications(event, response);
            this.saveQuestionData(data, event, question2, combinationQuestion, generateSerialNo);
            if (StringUtils.isNotEmpty((CharSequence)snapId)) {
                log.info("\u5feb\u7167ID\uff1a{},\u5904\u7406\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)snapId, (Object)TimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss:SSS"));
            }
            if (!(isCheck = this.agileDataCalculateCostService.combinedBillingCalculation(event, data, (Map)sendMap))) {
                return;
            }
            this.semcService.sendMessageToGpt(event, (Map)sendMap);
        }
        catch (Exception e) {
            HashMap<String, String> msgBody = new HashMap<String, String>();
            log.error("ade message sendMessageToAde error: {}", (Object)e.getMessage());
            String tipMessage = this.messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error", event.getLang(), new Object[0]);
            msgBody.put("prompt", tipMessage);
            this.saveAbnormal(event, tipMessage, Integer.valueOf(0));
            this.semcService.sendMessageToGpt(event, msgBody);
        }
    }
}

