/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.agileData;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.AgileDataType;
import com.digiwin.athena.adt.agileReport.service.AgileDataProcessService;
import com.digiwin.athena.adt.domain.dto.echo.AgileDataFileDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.adt.util.agileData.AgileDataAnalysisUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@AgileDataType(value=AgileDataEnum.PPT_ANALYZE)
public class AgileDataProcessPPTAnalyzeServiceImpl
implements AgileDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataProcessPPTAnalyzeServiceImpl.class);
    @Autowired
    private EchoService echoService;
    @Autowired
    private SemcService semcService;
    @Autowired
    private MessageUtil messageUtil;

    public void process(AthenaMessageEvent event, QuerySchemaResDTO querySchemaResDTO) {
        AgileDataFileDTO agileDataFileDTO = AgileDataAnalysisUtils.buildAgileDataFile((Long)event.getGenerateSerialNo(), (String)event.getAppCode(), (QuerySchemaResDTO)querySchemaResDTO);
        Boolean result = this.echoService.addAgileDataFile(agileDataFileDTO, event.getUser().getToken(), event.getUser().getTenantId());
        HashMap msgBody = Maps.newHashMap();
        if (result.booleanValue()) {
            msgBody.put("analyzeResult", true);
            msgBody.put("measures", event.getQuestionPlanningRes().getMeasures());
        } else {
            msgBody.put("analyzeResult", false);
            String sysError = this.messageUtil.getMessageByLangNameWithFormat("message.system.ppt.schema.error", event.getLang(), new Object[0]);
            msgBody.put("prompt", sysError);
        }
        this.semcService.sendMessageToGpt(event, (Map)msgBody);
    }
}

