/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.agileData;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSummarizeReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSummarizeResDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.AgileDataType;
import com.digiwin.athena.adt.agileReport.service.AgileDataProcessService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.echo.AgileDataFileDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.report.AgileReportDataService;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@AgileDataType(value=AgileDataEnum.PPT_PROCESS)
public class AgileDataProcessPPTServiceImpl
extends AbsAgileDataProcess
implements AgileDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataProcessPPTServiceImpl.class);
    @Resource
    private ADEService adeService;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private EchoService echoService;
    @Autowired
    private AgileReportDataService agileReportDataService;

    public void process(AthenaMessageEvent event, QuerySchemaResDTO responseData) {
        try {
            Map req = this.processBefore(event, responseData);
            this.processAfter(event, req, responseData);
        }
        catch (Exception e) {
            String tipMessage = this.messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error", event.getLang(), new Object[0]);
            HashMap<String, Object> queryData = new HashMap<String, Object>();
            queryData.put("title", "\u53d6\u6570\u5931\u8d25");
            queryData.put("content", tipMessage);
            queryData.put("status", false);
            this.updatePPTDataByError(event, responseData.getData().getDataset().getProcessStreamData(), queryData);
            log.error("ade message sendMessageToAde error: {}", (Object)JsonUtils.objectToString((Object)e));
            this.saveAbnormal(event, tipMessage, Integer.valueOf(0));
            Thread.currentThread().interrupt();
        }
    }

    public Map<String, Object> processBefore(AthenaMessageEvent event, QuerySchemaResDTO responseData) {
        Map req = this.parameterBasedOnVersion(responseData, event);
        this.updateProcessStreamDataByEF(event, req, responseData);
        Map res = this.adeService.reqMetricSnapShotData(req, event);
        HashMap<String, Object> queryData = new HashMap<String, Object>();
        if (res == null || MapUtils.getMap((Map)res, (Object)"data") == null) {
            String errorMsg = MapUtils.getString((Map)res, (Object)"msg");
            queryData.put("title", "\u53d6\u6570\u5931\u8d25");
            queryData.put("content", errorMsg);
            queryData.put("status", false);
            this.updateProcessStreamDataByQD(responseData, queryData);
            String tipMessage = this.messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error", event.getLang(), new Object[0]);
            this.saveAbnormal(event, tipMessage, Integer.valueOf(0));
            return null;
        }
        return res;
    }

    public void processAfter(AthenaMessageEvent event, Map<String, Object> response, QuerySchemaResDTO responseData) {
        if (Objects.isNull(response)) {
            log.info("\u66f4\u65b0ppt\u6267\u884c\u6b65\u9aa4 ADE\u53d6\u6570\u4e3a\u7a7a");
            this.updatePPTDataFile(event, responseData, Integer.valueOf(1), "", "");
            return;
        }
        SnapShotDTO snapShotDTO = (SnapShotDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)response.get("data")), SnapShotDTO.class);
        boolean queryDataFlag = snapShotDTO.getContext().getBizParams().isQueryDataFlag();
        HashMap<String, Object> queryData = new HashMap<String, Object>();
        if (queryDataFlag) {
            queryData.put("title", "\u53d6\u6570\u6210\u529f");
            queryData.put("status", true);
            queryData.put("content", "");
        } else {
            queryData.put("title", "\u53d6\u6570\u5931\u8d25");
            queryData.put("status", false);
            queryData.put("content", "\u65e0\u6570\u636e");
        }
        this.updateProcessStreamDataByQD(responseData, queryData);
        String question2 = event.getQuestion();
        String combinationQuestion = event.getCombinationQuestion();
        Long generateSerialNo = event.getGenerateSerialNo();
        try {
            Map data = MapUtils.getMap(response, (Object)"data");
            String snapshotId = MapUtils.getString((Map)data, (Object)"snapshotId");
            this.setDataSummary(data, event);
            String summarizeData = this.getProcessSummarizeData(event, snapShotDTO);
            this.updatePPTDataFile(event, responseData, Integer.valueOf(queryDataFlag ? 0 : 1), summarizeData, snapshotId);
            this.saveQuestionData(MapUtils.getMap(response, (Object)"data"), event, question2, combinationQuestion, generateSerialNo);
        }
        catch (Exception e) {
            log.info("\u66f4\u65b0ppt\u6267\u884c\u6b65\u9aa4 processAfter error");
            queryData.put("title", "\u53d6\u6570\u5931\u8d25");
            queryData.put("content", "process after error");
            queryData.put("status", false);
            this.updateProcessStreamDataByQD(responseData, queryData);
            this.updatePPTDataFile(event, responseData, Integer.valueOf(1), "", "");
            String tipMessage = this.messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error", event.getLang(), new Object[0]);
            this.saveAbnormal(event, tipMessage, Integer.valueOf(0));
        }
    }

    public void updateProcessStreamDataByQD(QuerySchemaResDTO responseData, Map<String, Object> queryData) {
        Map processStreamData = responseData.getData().getDataset().getProcessStreamData();
        processStreamData.put("queryData", queryData);
        log.info("\u53d6\u6570\u9636\u6bb5\u7684ppt\u6267\u884c\u6b65\u9aa4 processStreamData: {}", (Object)JsonUtils.objectToString((Object)processStreamData));
    }

    public void updateProcessStreamDataByEF(AthenaMessageEvent event, Map<String, Object> req, QuerySchemaResDTO responseData) {
        Map processStreamData = responseData.getData().getDataset().getProcessStreamData();
        log.info("ppt \u66f4\u65b0\u8981\u7d20\u8bc6\u522b\u8bed\u4e49\u5165\u53c2 processStreamData: {}", (Object)JsonUtils.objectToString((Object)processStreamData));
        HashMap<String, Object> essentialFactor = new HashMap<String, Object>();
        essentialFactor.put("title", "\u89e3\u9898\u8981\u7d20\u8bc6\u522b");
        Map response = this.adeService.getEssentialFactor(event, req);
        if (response == null || Objects.isNull(response.get("msg"))) {
            assert (response != null);
            essentialFactor.put("content", response.get("msg"));
            essentialFactor.put("status", false);
        } else {
            essentialFactor.put("content", response.get("data"));
            essentialFactor.put("status", true);
        }
        processStreamData.put("stepAnasisly", essentialFactor);
    }

    public String getProcessSummarizeData(AthenaMessageEvent event, SnapShotDTO snapShotDTO) {
        boolean queryDataFlag = snapShotDTO.getContext().getBizParams().isQueryDataFlag();
        if (!queryDataFlag) {
            return "";
        }
        String snapId = snapShotDTO.getSnapshotId();
        Boolean isSummarize = event.getExceedSummarizeSize();
        String resultMsg = this.messageUtil.getMessageByLangName("message.adt.data.summarize.info", event.getLang());
        if (Objects.isNull(snapId) || Objects.isNull(isSummarize)) {
            return resultMsg;
        }
        if (!isSummarize.booleanValue()) {
            AgileDataSummarizeReqDTO req = new AgileDataSummarizeReqDTO();
            req.setSnapshotId(snapId);
            AgileDataSummarizeResDTO summarizeData = this.agileReportDataService.getAgileDataSummarize(req, event.getUser());
            if (StringUtils.isNotEmpty((CharSequence)summarizeData.getSummarizeData()) && summarizeData.isData()) {
                resultMsg = summarizeData.getSummarizeData();
            } else {
                return resultMsg;
            }
        }
        return resultMsg;
    }

    public void updatePPTDataFile(AthenaMessageEvent event, QuerySchemaResDTO responseData, Integer status, String summarizeData, String snapshotId) {
        AgileDataFileDTO agileDataFileDTO = new AgileDataFileDTO();
        Map processStreamData = responseData.getData().getDataset().getProcessStreamData();
        agileDataFileDTO.setMessageId(Long.valueOf(event.getMsgExt().get("pptMessageId").toString()));
        ArrayList<AgileDataFileDTO.AgileDataFileQuestionDTO> questionDTOS = new ArrayList<AgileDataFileDTO.AgileDataFileQuestionDTO>();
        AgileDataFileDTO.AgileDataFileQuestionDTO questionDTO = new AgileDataFileDTO.AgileDataFileQuestionDTO();
        questionDTO.setQuestionId(Long.valueOf(event.getMsgExt().get("pptQuestionId").toString()));
        AgileDataFileDTO.AgileDataFileAnalyzeDTO analyzeDTO = (AgileDataFileDTO.AgileDataFileAnalyzeDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)processStreamData), AgileDataFileDTO.AgileDataFileAnalyzeDTO.class);
        questionDTO.setAnalyzeResult(analyzeDTO);
        questionDTO.setAnalyzeStatus(status);
        questionDTO.setSnapshotId(snapshotId);
        questionDTO.setSummarizeData(summarizeData);
        questionDTO.setAnalyzeMessageId(event.getGenerateSerialNo());
        questionDTOS.add(questionDTO);
        agileDataFileDTO.setQuestionInfo(questionDTOS);
        log.info("\u66f4\u65b0ppt\u6267\u884c\u6b65\u9aa4\u548c\u72b6\u6001\u5165\u53c2 eventQuestionId :{},: data:{}", (Object)event.getGenerateSerialNo(), (Object)JsonUtils.objectToString((Object)agileDataFileDTO));
        this.echoService.updateAgileDataFile(agileDataFileDTO, event.getUser().getToken(), event.getUser().getTenantId());
    }
}

