/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.agileData;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.AgileDataType;
import com.digiwin.athena.adt.agileReport.service.AgileDataProcessService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.ade.AdeTargetReqDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@AgileDataType(value=AgileDataEnum.TARGET)
public class AgileDataProcessTargetServiceImpl
extends AbsAgileDataProcess
implements AgileDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataProcessTargetServiceImpl.class);
    @Resource
    private ADEService adeService;
    @Autowired
    private SemcService semcService;
    @Autowired
    private MessageUtil messageUtil;

    public void process(AthenaMessageEvent event, QuerySchemaResDTO querySchemaResDTO) {
        long getQuerySchemaTook = System.currentTimeMillis();
        Long generateSerialNo = event.getGenerateSerialNo();
        Map eventMap = CommonUtil.convertObjectToMap((Object)event.getQuerySchemaReqDTO());
        String question2 = MapUtils.getString((Map)event.getMsgBody(), (Object)"text");
        try {
            String snapId = MapUtils.getString((Map)event.getMsgBody(), (Object)"snapshotId", null);
            if (!StringUtils.isEmpty((CharSequence)snapId)) {
                log.info("\u5feb\u7167ID\uff1a{},\u5904\u7406\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)snapId, (Object)TimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss:SSS"));
            }
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u95ee\u53e5\u5165\u53c2\uff1a{}", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), question2, JsonUtils.objectToString((Object)event.getMsgBody())});
            for (Map data : querySchemaResDTO.getData().getDataflow()) {
                if (!Objects.isNull(data.get("data")) && "1".equals(String.valueOf(data.get("code")))) {
                    event.setCombinationQuestion(MapUtils.getString((Map)data, (Object)"combinationQuestion"));
                    AdeTargetReqDTO adeTargetReqDTO = AdeTargetReqDTO.buildAdeReq((Map)MapUtils.getMap((Map)data, (Object)"data"), (AthenaMessageEvent)event);
                    this.sendMessageToAde(adeTargetReqDTO, event);
                    continue;
                }
                Object obj = MapUtils.getObject((Map)data, (Object)"sentences", null);
                List sentences = Lists.newArrayList();
                if (obj instanceof Collection) {
                    sentences = CommonUtil.objConvertListString((Object)obj);
                }
                this.saveQuerySchemaErrorByCode(event, sentences);
            }
        }
        catch (Exception e) {
            this.saveQuerySchemaErrorByCode(event, null);
        }
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u95ee\u53e5\u51fa\u53c2\uff1a{},\u8017\u65f6:{}ms", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), question2, JsonUtils.objectToString((Object)event.getMsgBody()), System.currentTimeMillis() - getQuerySchemaTook});
    }

    public void sendMessageToAde(AdeTargetReqDTO newAdeSceneReqDTO, AthenaMessageEvent event) {
        String combinationQuestion = event.getCombinationQuestion();
        Long generateSerialNo = event.getGenerateSerialNo();
        String question2 = MapUtils.getString((Map)event.getMsgBody(), (Object)"text");
        try {
            Map response = this.adeService.reqTargetSnapShotData(newAdeSceneReqDTO, event);
            HashMap sendMap = Maps.newHashMap();
            if (response == null || MapUtils.getMap((Map)response, (Object)"data") == null) {
                String errorMsg = MapUtils.getString((Map)response, (Object)"msg");
                sendMap.put("prompt", errorMsg);
                String tipMessage = this.messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error", event.getLang(), new Object[0]);
                this.saveAbnormal(event, tipMessage, Integer.valueOf(0));
            } else {
                String snapshotId = MapUtils.getString((Map)MapUtils.getMap((Map)response, (Object)"data"), (Object)"snapshotId");
                sendMap.put("snapshotId", snapshotId);
            }
            this.semcService.sendMessageToGpt(event, (Map)sendMap);
            this.saveQuestionData(MapUtils.getMap((Map)response, (Object)"data"), event, question2, combinationQuestion, generateSerialNo);
        }
        catch (Exception e) {
            HashMap sendMap = Maps.newHashMap();
            sendMap.put("prompt", e.getMessage());
            String tipMessage = this.messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error", event.getLang(), new Object[0]);
            this.saveAbnormal(event, tipMessage, Integer.valueOf(0));
            this.semcService.sendMessageToGpt(event, (Map)sendMap);
        }
    }
}

