/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.cost;

import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateConfigService;
import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateCostService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.domain.cac.AthenaCacService;
import com.digiwin.athena.adt.domain.dto.agileDataProcess.AgileDataProcessResDTO;
import com.digiwin.athena.adt.domain.dto.agileDataProcess.CalculateCostResDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.cac.CacCurrent;
import com.digiwin.athena.adt.domain.dto.cac.CacDecreaseReq;
import com.digiwin.athena.adt.domain.dto.cac.CacGoods;
import com.digiwin.athena.adt.domain.dto.echo.EchoSubmitReq;
import com.digiwin.athena.adt.domain.dto.km.KMIsBillingGoodsResDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.dto.tdd.TddThresholdConfig;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.domain.tdd.TddService;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.restful.iam.UserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AgileDataCalculateCostServiceImpl
extends AbsAgileDataProcess
implements AgileDataCalculateCostService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataCalculateCostServiceImpl.class);
    @Autowired
    private AthenaCacService athenaCacService;
    @Autowired
    private TddService tddService;
    @Autowired
    private AgileDataCalculateConfigService agileDataCalculateConfigService;
    @Autowired
    private EchoService echoService;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private SemcService semcService;
    @Value(value="${cost.calculateCostValue:}")
    private Integer calculateCostValue;
    @Autowired
    private UserService userService;

    public boolean calculateCostByCode(AthenaMessageEvent event, QuerySchemaResDTO querySchemaResDTO) {
        boolean costFlag = true;
        try {
            String userId = event.getUser().getUserId();
            Map scenesMap = this.getCostMap(querySchemaResDTO);
            if (Objects.isNull(scenesMap)) {
                return true;
            }
            Object billingGoodsId = scenesMap.get("billingGoodsId");
            Object appCode = scenesMap.get("appCode");
            LogDto logDto = new LogDto("\u8ba1\u8d39\u4e1a\u52a1\u8ba1\u7b97 \u5165\u53c2 scenesMap :{}", JsonUtils.objectToString((Object)scenesMap));
            log.info(logDto.toString());
            if (userId.contains("@digiwin.com") || Objects.isNull(billingGoodsId) || Objects.isNull(appCode)) {
                return true;
            }
            AuthoredUser user = event.getUser();
            CacGoods cacRes = this.athenaCacService.getCacCurrentTenantGoods(user, billingGoodsId.toString());
            if (Objects.nonNull(cacRes) && (cacRes.getPaymentType() == 0 || cacRes.getPaymentType() == 2)) {
                KMIsBillingGoodsResDTO isBillingDTO = this.agileDataCalculateConfigService.getIsBilling(user);
                if (Objects.isNull(isBillingDTO) || !isBillingDTO.isBilling()) {
                    this.sendMessageAndSaveLogByCost(event, "message.adt.cost.billing.msg");
                    return false;
                }
                event.setAppCode(appCode.toString());
                event.setGoodsCode(billingGoodsId.toString());
                event.setCost(true);
                int reUsage = cacRes.getRemainingUsage();
                if (reUsage <= 0) {
                    this.sendMessageAndSaveLogByCost(event, "message.adt.cost.msg");
                    return false;
                }
            }
        }
        catch (Exception e) {
            log.info("\u8ba1\u8d39\u5f02\u5e38\uff1acalculateCostByCode\uff1a{}", (Object)JsonUtils.objectToString((Object)e.getMessage()));
        }
        return costFlag;
    }

    public boolean designerDecreaseCurrentTenant(AthenaMessageEvent event) {
        boolean isGo = true;
        String goodsCode = event.getGoodsCode();
        String appCode = event.getAppCode();
        String productVersion = event.getProductVersion();
        if (!event.isCost() || StringUtils.isEmpty((CharSequence)goodsCode) || StringUtils.isEmpty((CharSequence)appCode)) {
            return isGo;
        }
        CacDecreaseReq req = CacDecreaseReq.builderCacDecrease((AthenaMessageEvent)event);
        CacCurrent cacCurrent = new CacCurrent();
        try {
            cacCurrent = this.athenaCacService.decreaseCurrentTenant(event.getUser(), req);
            if (Objects.nonNull(cacCurrent) && cacCurrent.isSuccess()) {
                boolean isAlarm;
                LogUtils.buildAgileLog((String)"adt", (String)"trafficDeduction", (String)"1", (String)JsonUtils.objectToString((Object)req), (String)JsonUtils.objectToString((Object)cacCurrent), (String)"");
                int remainingUsage = cacCurrent.getRemainingUsage();
                int thresholdNum = 100;
                if (StringUtils.isEmpty((CharSequence)productVersion) || "V1".equals(productVersion)) {
                    TddThresholdConfig tddThresholdConfig = this.tddService.getTddThresholdConfigByParam(event.getUser().getToken(), event.getUser().getTenantId(), appCode);
                    if (tddThresholdConfig == null) {
                        return isGo;
                    }
                    thresholdNum = tddThresholdConfig.getThreshold();
                } else if ("V2".equals(productVersion)) {
                    thresholdNum = this.calculateCostValue;
                }
                if (remainingUsage >= thresholdNum) {
                    log.info("\u6839\u636e\u9608\u503c\u548c\u5269\u4f59\u6d41\u91cf\u521d\u59cb\u5316\u7528\u6237\u914d\u7f6e remainingUsage:{},thresholdNumL:{} ,userId:{}", new Object[]{remainingUsage, thresholdNum, event.getUser().getUserId()});
                    this.agileDataCalculateConfigService.deleteCalculateTypeByParam(event.getUser().getUserId());
                }
                if ((isAlarm = this.agileDataCalculateConfigService.queryCalculateConfigByUser(event.getUser())) && remainingUsage <= thresholdNum) {
                    this.echoService.echoMongodbSubmit(EchoSubmitReq.builderCostAlarm((AthenaMessageEvent)event, (int)remainingUsage, (int)thresholdNum), event.getUser().getToken(), event.getUser().getTenantId());
                    return false;
                }
            }
            LogUtils.buildAgileLog((String)"adt", (String)"trafficDeduction", (String)"1", (String)JsonUtils.objectToString((Object)req), (String)JsonUtils.objectToString((Object)cacCurrent), (String)"");
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"trafficDeduction", (String)TroubleToolCodeEnum.ADT_901_0117.getErrCode(), (String)JsonUtils.objectToString((Object)req), (String)(TroubleToolCodeEnum.ADT_901_0117.getErrMsg() + JsonUtils.objectToString((Object)cacCurrent)), (String)TroubleToolCodeEnum.ADT_901_0117.getSuggestion());
            log.info("\u8ba1\u8d39\u5f02\u5e38\uff1adesignerDecreaseCurrentTenant\uff1a{}", (Object)JsonUtils.objectToString((Object)e.getMessage()));
        }
        return isGo;
    }

    public AgileDataProcessResDTO calculateCostResult(AthenaMessageEvent event, QuerySchemaResDTO querySchemaResDTO, AgileDataProcessResDTO agileDataProcessResDTO) {
        try {
            String userId = event.getUser().getUserId();
            Map scenesMap = this.getCostMap(querySchemaResDTO);
            if (Objects.isNull(scenesMap)) {
                return agileDataProcessResDTO;
            }
            LogDto logDto = new LogDto("\u8ba1\u8d39\u4e1a\u52a1\u8ba1\u7b97 \u5165\u53c2 scenesMap :{}", JsonUtils.objectToString((Object)scenesMap));
            log.info(logDto.toString());
            Object billingGoodsId = scenesMap.get("billingGoodsId");
            Object appCode = scenesMap.get("appCode");
            if (userId.contains("@digiwin.com") || Objects.isNull(billingGoodsId) || Objects.isNull(appCode)) {
                return agileDataProcessResDTO;
            }
            AuthoredUser user = event.getUser();
            CacGoods cacRes = this.athenaCacService.getCacCurrentTenantGoods(user, billingGoodsId.toString());
            if (Objects.nonNull(cacRes) && (cacRes.getPaymentType() == 0 || cacRes.getPaymentType() == 2)) {
                KMIsBillingGoodsResDTO isBillingDTO = this.agileDataCalculateConfigService.getIsBilling(user);
                if (Objects.isNull(isBillingDTO) || !isBillingDTO.isBilling()) {
                    String warnStr = this.messageUtil.getMessageByLangName("message.adt.cost.billing.msg", event.getLang());
                    this.sendMessageAndSaveLogByCost(event, "message.adt.cost.billing.msg");
                    agileDataProcessResDTO.setAlarm(true);
                    agileDataProcessResDTO.setMsg(warnStr);
                    return agileDataProcessResDTO;
                }
                event.setAppCode(appCode.toString());
                event.setGoodsCode(billingGoodsId.toString());
                event.setCost(true);
                agileDataProcessResDTO.setRemainingUsage(agileDataProcessResDTO.getRemainingUsage());
                agileDataProcessResDTO.setTotalUsage(cacRes.getTotalUsage());
                int reUsage = cacRes.getRemainingUsage();
                if (reUsage <= 0) {
                    String warnStr = this.messageUtil.getMessageByLangName("message.adt.cost.msg", event.getLang());
                    this.sendMessageAndSaveLogByCost(event, "message.adt.cost.msg");
                    agileDataProcessResDTO.setAlarm(true);
                    agileDataProcessResDTO.setMsg(warnStr);
                    return agileDataProcessResDTO;
                }
            }
        }
        catch (Exception e) {
            log.info("\u8ba1\u8d39\u5f02\u5e38\uff1acalculateCostByCode\uff1a{}", (Object)JsonUtils.objectToString((Object)e.getMessage()));
        }
        return agileDataProcessResDTO;
    }

    public boolean secondCalculateCostByCode(AthenaMessageEvent event) {
        boolean costFlag = true;
        try {
            int reUsage;
            String appCode = event.getAppCode();
            String goodsCode = event.getGoodsCode();
            LogDto logDto = new LogDto("\u8ba1\u8d39\u4e8c\u6b21\u8ba1\u7b97\u662f\u5426\u6263\u51cf \u5165\u53c2 appCode :{}, goodsCode :{}", appCode, goodsCode);
            log.info(logDto.toString());
            if (!event.isCost() || StringUtils.isEmpty((CharSequence)goodsCode) || StringUtils.isEmpty((CharSequence)appCode)) {
                return costFlag;
            }
            AuthoredUser user = event.getUser();
            CacGoods cacRes = this.athenaCacService.getCacCurrentTenantGoods(user, goodsCode);
            if (Objects.nonNull(cacRes) && (cacRes.getPaymentType() == 0 || cacRes.getPaymentType() == 2) && (reUsage = cacRes.getRemainingUsage()) <= 0) {
                return false;
            }
        }
        catch (Exception e) {
            log.info("\u8ba1\u8d39\u5f02\u5e38\uff1acalculateCostByCode\uff1a{}", (Object)JsonUtils.objectToString((Object)e.getMessage()));
        }
        return costFlag;
    }

    public Map<String, Object> getCostMap(QuerySchemaResDTO querySchemaResDTO) {
        String method = querySchemaResDTO.getData().getMethod();
        if ("metric".equals(method)) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("appCode", querySchemaResDTO.getData().getMetric().getAppCode());
            result.put("billingGoodsId", querySchemaResDTO.getData().getMetric().getBillingGoodsId());
            return result;
        }
        if ("dataflow".equals(method)) {
            List scenesList = querySchemaResDTO.getData().getDataflow().stream().map(data -> {
                Object scenesObj = MapUtils.getObject((Map)data, (Object)"scenes");
                return scenesObj instanceof List ? (List)scenesObj : null;
            }).filter(Objects::nonNull).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).collect(Collectors.toList());
            return CollectionUtils.isNotEmpty(scenesList) ? (Map)scenesList.get(0) : null;
        }
        if ("dataset".equals(method)) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("appCode", querySchemaResDTO.getData().getDataset().getAppCode());
            result.put("billingGoodsId", querySchemaResDTO.getData().getDataset().getBillingGoodsId());
            return result;
        }
        return null;
    }

    public boolean combinedBillingCalculation(AthenaMessageEvent event, Map<String, Object> data, Map<String, Object> sendMap) {
        boolean isCheck;
        boolean isCostCheck = true;
        List relatedIntentions = new ArrayList();
        if (Objects.nonNull(sendMap.get("intentions"))) {
            relatedIntentions = CommonUtil.objConvertListString((Object)sendMap.get("intentions"));
            event.setAnswerResult(Integer.valueOf(1));
            event.setSentences(relatedIntentions);
        }
        if (!(isCheck = this.secondCalculateCostByCode(event))) {
            if (event.isSendNana()) {
                String msg = this.messageUtil.getMessageByLangName("message.adt.cost.msg", event.getLang());
                HashMap<String, String> msgBody = new HashMap<String, String>();
                msgBody.put("prompt", msg);
                this.saveAbnormalLog(event, msg, Integer.valueOf(1), Integer.valueOf(2));
                this.semcService.sendMessageToGpt(event, msgBody);
            }
            return false;
        }
        boolean isReturn = this.designerDecreaseCurrentTenant(event);
        if (!isReturn && event.isSendNana()) {
            event.getMsgExt().put("isAlarm", true);
            event.getMsgExt().put("messageId", event.getGenerateSerialNo());
            this.semcService.sendMessageToGpt(event, sendMap);
            this.saveQuestionData(data, event, event.getQuestion(), event.getCombinationQuestion(), event.getGenerateSerialNo());
            return false;
        }
        return isCostCheck;
    }

    public AgileDataProcessResDTO combinedBillingCalculationPanel(AthenaMessageEvent event, SnapShotDTO snapShotDTO) {
        AgileDataProcessResDTO result = AgileDataProcessResDTO.init();
        CacDecreaseReq req = new CacDecreaseReq();
        CacCurrent cacCurrent = new CacCurrent();
        try {
            Pair interception;
            String goodsCode = event.getGoodsCode();
            String appCode = event.getAppCode();
            String msg = this.messageUtil.getMessageByLangName("message.adt.cost.msg", event.getLang());
            String cacMsg = this.messageUtil.getMessageByLangName("message.adt.cost.cac.msg", event.getLang());
            boolean isCheck = this.secondCalculateCostByCode(event);
            if (!isCheck) {
                this.saveAbnormalLog(event, msg, Integer.valueOf(1), Integer.valueOf(2));
                result.setAlarm(true);
                result.setMsg(msg);
                return result;
            }
            if (StringUtils.isNotEmpty((CharSequence)goodsCode) && StringUtils.isNotEmpty((CharSequence)appCode)) {
                req = CacDecreaseReq.builderCacDecrease((AthenaMessageEvent)event);
                cacCurrent = this.athenaCacService.decreaseCurrentTenant(event.getUser(), req);
                if (cacCurrent != null && cacCurrent.isSuccess()) {
                    result.setTotalUsage(cacCurrent.getTotalUsage());
                    result.setRemainingUsage(cacCurrent.getRemainingUsage());
                } else {
                    result.setAlarm(true);
                    result.setMsg(cacMsg);
                }
            }
            if (((Boolean)(interception = this.isDataProcessAction(CommonUtil.convertObjectToMap((Object)snapShotDTO))).getLeft()).booleanValue()) {
                String dataTipMessage = this.messageUtil.getMessageByLangNameWithFormat("message.adt.message.page", event.getLang(), new Object[]{interception.getRight()});
                result.setDataTipMessage(dataTipMessage);
            }
            result.setPanelMap(snapShotDTO);
            result.setSnapshotId(snapShotDTO.getSnapshotId());
            result.setRequestTime(snapShotDTO.getContext().getBizParams().getRequestTime());
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"trafficDeduction", (String)TroubleToolCodeEnum.ADT_901_0117.getErrCode(), (String)JsonUtils.objectToString((Object)req), (String)(TroubleToolCodeEnum.ADT_901_0117.getErrMsg() + JsonUtils.objectToString((Object)cacCurrent)), (String)TroubleToolCodeEnum.ADT_901_0117.getSuggestion());
        }
        return result;
    }

    public CalculateCostResDTO calculateCostByUser(AuthoredUser user, String appCode, String billingGoodsId) {
        CalculateCostResDTO calculateCostResDTO = new CalculateCostResDTO();
        calculateCostResDTO.setCostFlag(true);
        try {
            String userId = user.getUserId();
            if (StringUtils.isEmpty((CharSequence)appCode) || StringUtils.isEmpty((CharSequence)billingGoodsId) || userId.contains("@digiwin.com")) {
                return calculateCostResDTO;
            }
            LogDto logDto = new LogDto("\u8ba1\u8d39\u4e1a\u52a1\u8ba1\u7b97 \u5165\u53c2 appCode :{} ,billingGoodsId :{}", appCode, billingGoodsId);
            log.info(logDto.toString());
            String userLocale = this.userService.getUserLangNameByUserId(user.getUserId(), user.getTenantId(), user.getToken());
            CacGoods cacRes = this.athenaCacService.getCacCurrentTenantGoods(user, billingGoodsId);
            if (Objects.nonNull(cacRes) && (cacRes.getPaymentType() == 0 || cacRes.getPaymentType() == 2)) {
                KMIsBillingGoodsResDTO isBillingDTO = this.agileDataCalculateConfigService.getIsBilling(user);
                if (Objects.isNull(isBillingDTO) || !isBillingDTO.isBilling()) {
                    calculateCostResDTO.setMsg(this.messageUtil.getMessageByLangName("message.adt.cost.billing.msg", userLocale));
                    calculateCostResDTO.setCostFlag(false);
                    return calculateCostResDTO;
                }
                int reUsage = cacRes.getRemainingUsage();
                if (reUsage <= 0) {
                    calculateCostResDTO.setMsg(this.messageUtil.getMessageByLangName("message.adt.cost.msg", userLocale));
                    calculateCostResDTO.setCostFlag(false);
                    return calculateCostResDTO;
                }
            }
        }
        catch (Exception e) {
            log.info("\u8ba1\u8d39\u5f02\u5e38\uff1acalculateCostByCode\uff1a{}", (Object)JsonUtils.objectToString((Object)e.getMessage()));
        }
        return calculateCostResDTO;
    }
}

