/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.entrance;

import cn.hutool.json.JSONObject;
import com.digiwin.athena.adt.agileReport.config.AgileDataHandlerProcessor;
import com.digiwin.athena.adt.agileReport.config.SchemaDataHandlerProcessor;
import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.event.domain.EventSubscribeDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateCostService;
import com.digiwin.athena.adt.agileReport.service.AgileDataMessageService;
import com.digiwin.athena.adt.agileReport.service.ModulePermissionService;
import com.digiwin.athena.adt.agileReport.service.SnapShotDataService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.agileReport.service.impl.process.pannel.AgileDataDataFlowPanelServiceImpl;
import com.digiwin.athena.adt.agileReport.service.impl.process.pannel.AgileDataMetricPanelServiceImpl;
import com.digiwin.athena.adt.agileReport.service.impl.process.pannel.AgileDatasetPanelServiceImpl;
import com.digiwin.athena.adt.agileReport.service.impl.process.schema.SchemaDataProcessAIBoardAnalyzeServiceImpl;
import com.digiwin.athena.adt.agileReport.service.impl.process.schema.SchemaDataProcessAutoDataQuestionServiceImpl;
import com.digiwin.athena.adt.agileReport.service.impl.process.schema.SchemaDataProcessPPTServiceImpl;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.ade.AdeDatasetReqDTO;
import com.digiwin.athena.adt.domain.dto.ade.AdeMetricReqDTO;
import com.digiwin.athena.adt.domain.dto.agileDataProcess.AgileDataProcessResDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.BizParamsDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.PullDataDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.aiBoard.AIBoardDTO;
import com.digiwin.athena.adt.domain.dto.echo.AgileDataFileDTO;
import com.digiwin.athena.adt.domain.dto.km.KMCollectStepResDTO;
import com.digiwin.athena.adt.domain.dto.km.ThemeMapBoardDTO;
import com.digiwin.athena.adt.domain.dto.schema.AutoDataQuestionResDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.dto.schema.SchemaMetricShowDefine;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.sse.dto.SSEBaseEvent;
import com.digiwin.athena.adt.sse.listener.SSEScrumListener;
import com.digiwin.athena.adt.sse.service.SSEProcessService;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgileDataMessageServiceImpl
extends AbsAgileDataProcess
implements AgileDataMessageService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataMessageServiceImpl.class);
    @Autowired
    private AgileDataHandlerProcessor agileDataHandlerProcessor;
    @Autowired
    private SchemaDataHandlerProcessor schemaDataHandlerProcessor;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private AgileDataDataFlowPanelServiceImpl agileDataDataFlowPanelService;
    @Autowired
    private AgileDataMetricPanelServiceImpl agileDataMetricPanelService;
    @Autowired
    private AgileDataCalculateCostService agileDataCalculateCostService;
    @Autowired
    private SemcService semcService;
    @Autowired
    private SnapShotDataService snapShotDataService;
    @Resource
    private ADEService adeService;
    @Autowired
    private AgileDatasetPanelServiceImpl agileDatasetPanelService;
    @Autowired
    private SchemaDataProcessPPTServiceImpl schemaPPTService;
    @Autowired
    private SchemaDataProcessAIBoardAnalyzeServiceImpl schemaAIBoardAnalyzeService;
    @Autowired
    private EchoService echoService;
    @Autowired
    private SchemaDataProcessAutoDataQuestionServiceImpl schemaAutoDataQuestionService;
    @Autowired
    private ModulePermissionService modulePermissionService;

    public void process(AthenaMessageEvent event) {
        AppAuthContextHolder.clearContext();
        String schemaEnum = this.getServiceNameByMessageType(event);
        boolean isAppNull = this.checkUserAppPermission(event, schemaEnum);
        if (isAppNull) {
            String errorMsg = this.messageUtil.getMessageByLangNameWithFormat("message.app.warn", event.getLang(), new Object[0]);
            this.saveWarnQuestionData(event, errorMsg);
            HashMap<String, String> msgBody = new HashMap<String, String>();
            msgBody.put("prompt", errorMsg);
            this.semcService.sendMessageToGpt(event, msgBody);
            return;
        }
        boolean isSceneEmpty = this.checkUserScene(event);
        if (event.isSubscribe() && !isSceneEmpty) {
            log.info("processMessage receiveQuestion: \u8be5\u6307\u6807\u6216\u573a\u666f\u7f16\u7801\u4e0d\u5b58\u5728\u5f53\u524d\u79df\u6237");
            return;
        }
        String securityToken = Objects.isNull(AppAuthContextHolder.getContext()) ? null : AppAuthContextHolder.getContext().getSecurityToken();
        log.info("asyncServiceExecutor process messageId:{}, app core securityToken : {}", (Object)event.getGenerateSerialNo(), (Object)securityToken);
        Pair result = this.schemaDataHandlerProcessor.getEnumServiceByType((Enum)SchemaDataEnum.queryTypeEnumByCode((String)schemaEnum)).process(event);
        if (result.getRight() == null || StringUtils.isEmpty((CharSequence)((QuerySchemaResDTO)result.getRight()).getData().getMethod())) {
            this.saveQuerySchemaErrorByCode(event, null);
            return;
        }
        if (!((Boolean)result.getLeft()).booleanValue()) {
            return;
        }
        QuerySchemaResDTO querySchemaResDTO = (QuerySchemaResDTO)result.getRight();
        boolean isGo = this.agileDataCalculateCostService.calculateCostByCode(event, querySchemaResDTO);
        if (!isGo) {
            return;
        }
        String router = String.valueOf(querySchemaResDTO.getRoute());
        String serviceName = this.getServiceNameByQuerySchema(router);
        this.agileDataHandlerProcessor.getEnumServiceByType((Enum)AgileDataEnum.queryTypeEnumByCode((String)serviceName)).process(event, querySchemaResDTO);
    }

    public AgileDataProcessResDTO processRes(AthenaMessageEvent event) {
        String schemaEnum = this.getServiceNameByMessageType(event);
        AgileDataProcessResDTO agileDataProcessResDTO = AgileDataProcessResDTO.init();
        boolean isAppNull = this.checkUserAppPermission(event, schemaEnum);
        if (isAppNull) {
            String errorMsg = this.messageUtil.getMessageByLangNameWithFormat("message.app.warn", event.getLang(), new Object[0]);
            this.saveWarnQuestionData(event, errorMsg);
            agileDataProcessResDTO.setMsg(errorMsg);
            agileDataProcessResDTO.setAlarm(true);
            return agileDataProcessResDTO;
        }
        boolean isSceneEmpty = this.checkUserScene(event);
        if (!isSceneEmpty) {
            return agileDataProcessResDTO;
        }
        Pair result = this.schemaDataHandlerProcessor.getEnumServiceByType((Enum)SchemaDataEnum.queryTypeEnumByCode((String)schemaEnum)).process(event);
        QuerySchemaResDTO schemaData = (QuerySchemaResDTO)result.getRight();
        if (schemaData == null || StringUtils.isEmpty((CharSequence)schemaData.getData().getMethod())) {
            String sysError = this.messageUtil.getMessageByLangNameWithFormat("message.system.schema.error", event.getLang(), new Object[0]);
            this.saveAbnormalLog(event, sysError, Integer.valueOf(1), Integer.valueOf(0));
            return agileDataProcessResDTO;
        }
        if (!((Boolean)result.getLeft()).booleanValue()) {
            agileDataProcessResDTO.setMsg(this.getReply(schemaData));
            return agileDataProcessResDTO;
        }
        AgileDataProcessResDTO resDTO = this.agileDataCalculateCostService.calculateCostResult(event, schemaData, agileDataProcessResDTO);
        if (resDTO.isAlarm()) {
            return resDTO;
        }
        String router = String.valueOf(schemaData.getRoute());
        if ("metric".equals(router)) {
            return this.agileDataMetricPanelService.process(event, schemaData);
        }
        if ("designer".equals(router)) {
            return this.agileDataDataFlowPanelService.process(event, schemaData);
        }
        if ("dataset".equals(router)) {
            return this.agileDatasetPanelService.process(event, schemaData);
        }
        return agileDataProcessResDTO;
    }

    private String getReply(QuerySchemaResDTO schemaData) {
        String method;
        String reply = "";
        switch (method = schemaData.getData().getMethod()) {
            case "dataflow": {
                for (Map data : schemaData.getData().getDataflow()) {
                    reply = MapUtils.getString((Map)data, (Object)"data");
                }
                break;
            }
            case "metric": {
                reply = schemaData.getData().getMetric().getReply();
                break;
            }
            case "dataset": {
                reply = schemaData.getData().getDataset().getReply();
                break;
            }
        }
        return reply;
    }

    public void sseProcess(AthenaMessageEvent event, SSEBaseEvent sseBaseEvent) {
        AppAuthContextHolder.clearContext();
        MDC.put((String)"traceId", (String)event.getPtxId());
        MDC.put((String)"PtxId", (String)event.getPtxId());
        JaMDC.put((String)event.getPtxId());
        log.info("initMdc sseProcess af : mdc traceId : {},mdc get ptxId :{},event PtxId :{},jaMdc get PtxId :{}", new Object[]{MDC.get((String)"traceId"), MDC.get((String)"PtxId"), event.getPtxId(), JaMDC.get()});
        String schemaEnum = this.getServiceNameByMessageType(event);
        boolean isAppNull = this.checkUserAppPermission(event, schemaEnum);
        if (isAppNull) {
            String errorMsg = this.messageUtil.getMessageByLangNameWithFormat("message.app.warn", event.getLang(), new Object[0]);
            this.saveWarnQuestionData(event, errorMsg);
            HashMap<String, String> msgBody = new HashMap<String, String>();
            msgBody.put("prompt", errorMsg);
            this.semcService.sendMessageToGpt(event, msgBody);
            return;
        }
        boolean isSceneEmpty = this.checkUserScene(event);
        if (event.isSubscribe() && !isSceneEmpty) {
            log.info("processMessage receiveQuestion: \u8be5\u6307\u6807\u6216\u573a\u666f\u7f16\u7801\u4e0d\u5b58\u5728\u5f53\u524d\u79df\u6237");
            sseBaseEvent.getAniaEmitter().complete();
            return;
        }
        String url = this.getSseSchemaUrl(schemaEnum);
        Map req = this.schemaDataHandlerProcessor.getEnumServiceByType((Enum)SchemaDataEnum.queryTypeEnumByCode((String)schemaEnum)).getQuerySchemaReq(event);
        SSEBaseEvent.builderSchemaEvent((AthenaMessageEvent)event, (SSEBaseEvent)sseBaseEvent);
        sseBaseEvent.setSchemaEnum(schemaEnum);
        String skillType = event.getSkillType();
        if (StringUtils.isEmpty((CharSequence)skillType)) {
            skillType = "0";
        }
        SSEProcessService sseProcessService = (SSEProcessService)SpringUtil.getBean((String)(skillType + "_sseProcess"), SSEProcessService.class);
        SSEScrumListener sseListener = new SSEScrumListener(sseBaseEvent, this.schemaDataHandlerProcessor, this.agileDataCalculateCostService, this.agileDataHandlerProcessor, (AbsAgileDataProcess)this, this.echoService);
        sseProcessService.process(sseListener, event, url, req, sseBaseEvent);
    }

    public AgileDataProcessResDTO processResV2(AthenaMessageEvent event, SnapShotDTO snapshotInfo, ThemeMapBoardDTO boardQuestion, AdeDatasetReqDTO adeDatasetReqDTO) {
        Map response;
        AgileDataProcessResDTO res = new AgileDataProcessResDTO();
        AdeDatasetReqDTO req = adeDatasetReqDTO;
        if (adeDatasetReqDTO == null) {
            req = this.BuildDatasetAdeReq(event, snapshotInfo, boardQuestion);
        }
        if (Objects.isNull(response = this.adeService.reqMetricSnapShotData(CommonUtil.convertObjectToMap((Object)req), event)) || "-1".equals(response.get("code"))) {
            res.setMsg(MapUtils.getString((Map)response, (Object)"msg"));
            return res;
        }
        res.setPanelMap((SnapShotDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString(response.get("data")), SnapShotDTO.class));
        return res;
    }

    public AgileDataProcessResDTO processResV1(AthenaMessageEvent event, SnapShotDTO snapshotInfo, KMCollectStepResDTO stepResDTO) {
        AgileDataProcessResDTO res = new AgileDataProcessResDTO();
        String method = snapshotInfo.getContext().getBizParams().getMethod();
        ThemeMapBoardDTO boardQuestion = new ThemeMapBoardDTO();
        boardQuestion.setShowType(stepResDTO.getShowType());
        boardQuestion.setSolutionStep(stepResDTO.getSolutionStep());
        boardQuestion.setAppCode(stepResDTO.getAppCode());
        boardQuestion.setStepFilterAnalysis(stepResDTO.getStepFilterAnalysis());
        boardQuestion.setFilterAnalysis(stepResDTO.isFilterAnalysis());
        Map req = new HashMap();
        if (AgileDataEnum.DATASET.getCode().equals(method)) {
            req = CommonUtil.convertObjectToMap((Object)this.BuildDatasetAdeReq(event, snapshotInfo, boardQuestion));
        } else if (AgileDataEnum.METRIC.getCode().equals(method)) {
            req = CommonUtil.convertObjectToMap((Object)this.BuildMetricAdeReq(event, snapshotInfo, stepResDTO));
        }
        Map response = this.adeService.reqMetricSnapShotData(req, event);
        if (Objects.isNull(response) || "-1".equals(response.get("code"))) {
            res.setPanelMap(new SnapShotDTO());
            res.setMsg(MapUtils.getString((Map)response, (Object)"msg"));
            return res;
        }
        res.setPanelMap((SnapShotDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString(response.get("data")), SnapShotDTO.class));
        return res;
    }

    public void processSubscribeV2(AthenaMessageEvent event, EventSubscribeDTO subscribeDTO) {
        Map req;
        AuthoredUser user = event.getUser();
        String snapshotId = String.valueOf(subscribeDTO.getMsgExt().get("snapshotId"));
        SnapShotDTO snapshotInfo = this.snapShotDataService.getSnapShotData(snapshotId, user.getTenantId(), user.getUserId());
        String method = snapshotInfo.getContext().getBizParams().getMethod();
        if (event.isSubscribe() && StringUtils.isNotEmpty((CharSequence)event.getQuestion()) && snapshotInfo != null) {
            snapshotInfo.getContext().getBizParams().setQuestion(event.getQuestion());
        }
        if ("dataflow".equals(method)) {
            this.processRes(event);
            return;
        }
        String showType = String.valueOf(subscribeDTO.getMsgExt().get("showType"));
        Map solutionStep = (Map)subscribeDTO.getMsgExt().get("solutionStep");
        Object stepFilterAnalysisO = subscribeDTO.getMsgExt().get("stepFilterAnalysis");
        List stepFilterAnalysis = new ArrayList();
        if (Objects.nonNull(stepFilterAnalysisO)) {
            stepFilterAnalysis = (List)subscribeDTO.getMsgExt().get("stepFilterAnalysis");
        }
        Boolean filterAnalysisFlag = false;
        Object filterAnalysis = subscribeDTO.getMsgExt().get("filterAnalysis");
        if (Objects.nonNull(filterAnalysis)) {
            filterAnalysisFlag = (Boolean)subscribeDTO.getMsgExt().get("filterAnalysis");
        }
        if (AgileDataEnum.DATASET.getCode().equals(method)) {
            ThemeMapBoardDTO boardQuestion = new ThemeMapBoardDTO();
            boardQuestion.setShowType(Integer.valueOf(Integer.parseInt(showType)));
            boardQuestion.setSolutionStep(solutionStep);
            boardQuestion.setAppCode(event.getAppCode());
            boardQuestion.setStepFilterAnalysis(stepFilterAnalysis);
            boardQuestion.setFilterAnalysis(filterAnalysisFlag.booleanValue());
            req = CommonUtil.convertObjectToMap((Object)this.BuildDatasetAdeReq(event, snapshotInfo, boardQuestion));
        } else if (AgileDataEnum.METRIC.getCode().equals(method)) {
            KMCollectStepResDTO stepResDTO = new KMCollectStepResDTO();
            stepResDTO.setAppCode(event.getAppCode());
            stepResDTO.setShowType(Integer.valueOf(Integer.parseInt(showType)));
            stepResDTO.setSolutionStep(solutionStep);
            stepResDTO.setFilterAnalysis(filterAnalysisFlag.booleanValue());
            stepResDTO.setStepFilterAnalysis(stepFilterAnalysis);
            req = CommonUtil.convertObjectToMap((Object)this.BuildMetricAdeReq(event, snapshotInfo, stepResDTO));
        } else {
            return;
        }
        this.adeService.reqMetricSnapShotData(req, event);
    }

    private Object BuildMetricAdeReq(AthenaMessageEvent event, SnapShotDTO snapshotInfo, KMCollectStepResDTO stepResDTO) {
        AdeMetricReqDTO adeMetricReqDTO = new AdeMetricReqDTO();
        BizParamsDTO bizParamsDTO = snapshotInfo.getContext().getBizParams();
        PullDataDTO pullDataDTO = (PullDataDTO)snapshotInfo.getContext().getPullData().get(0);
        Integer showType = stepResDTO.getShowType();
        Map showDefineDTO = bizParamsDTO.getShowDefine();
        SchemaMetricShowDefine showDefine = (SchemaMetricShowDefine)new JSONObject((Object)showDefineDTO).toBean(SchemaMetricShowDefine.class);
        if (Objects.nonNull(showType)) {
            ((SchemaMetricShowDefine.ShowType.TypeItem)((SchemaMetricShowDefine.ShowType)showDefine.getShowType().get(0)).getType().get(0)).setValue(String.valueOf(showType));
            ((SchemaMetricShowDefine.ShowType.TypeItem)((SchemaMetricShowDefine.ShowType)showDefine.getShowType().get(0)).getType().get(0)).setUserGraph(null);
        }
        if (Objects.isNull(showDefineDTO) || CollectionUtils.isEmpty((Collection)showDefine.getShowType())) {
            throw new IllegalArgumentException("\u8bed\u4e49\u5448\u73b0\u6570\u636e\u672a\u8fd4\u56de,\u672a\u627e\u5230\u5bf9\u5e94actionId");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (event.isSubscribe()) {
            param.put("type", "2");
            param.put("undeletable", event.isUndeletable());
            param.put("asaCode", event.getAsaCode());
            param.put("ruleId", event.getMsgExt().get("ruleId"));
            param.put("chartTitle", event.getMsgExt().get("chartTitle"));
            adeMetricReqDTO.setParam(param);
        }
        adeMetricReqDTO.setEocMaps(bizParamsDTO.getEocMaps());
        adeMetricReqDTO.setMetricList(pullDataDTO.getMetricList());
        adeMetricReqDTO.setAppCode(stepResDTO.getAppCode());
        adeMetricReqDTO.setLocale(event.getLang());
        adeMetricReqDTO.setMessageId(String.valueOf(event.getGenerateSerialNo()));
        adeMetricReqDTO.setParam(param);
        adeMetricReqDTO.setMock(false);
        adeMetricReqDTO.setQuestion(event.getQuestion());
        adeMetricReqDTO.setMethod(SchemaDataEnum.METRIC.getCode());
        adeMetricReqDTO.setScene(event.getSceneDTO());
        adeMetricReqDTO.setMetric(stepResDTO.getSolutionStep());
        adeMetricReqDTO.setDataTag(bizParamsDTO.getDataTagParam());
        adeMetricReqDTO.setShowDefine(showDefine);
        adeMetricReqDTO.setRequestTime(TimeUtils.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy-MM-dd HH:mm:ss"));
        adeMetricReqDTO.setRequestor(event.getUser().getUserId());
        adeMetricReqDTO.setTenantId(event.getUser().getTenantId());
        adeMetricReqDTO.setProductLineInfo(event.getProductLineInfo());
        adeMetricReqDTO.setExplain4Gpt(bizParamsDTO.getExplain4Gpt());
        adeMetricReqDTO.setProductVersion(event.getProductVersion());
        adeMetricReqDTO.setStepFilterAnalysis(stepResDTO.getStepFilterAnalysis());
        adeMetricReqDTO.setFilterAnalysis(stepResDTO.isFilterAnalysis());
        adeMetricReqDTO.setSaveTransResult(event.getSaveTransResult().booleanValue());
        return adeMetricReqDTO;
    }

    private AdeDatasetReqDTO BuildDatasetAdeReq(AthenaMessageEvent event, SnapShotDTO snapShotDTO, ThemeMapBoardDTO boardQuestion) {
        AdeDatasetReqDTO adeDatasetReqDTO = new AdeDatasetReqDTO();
        BizParamsDTO bizParamsDTO = snapShotDTO.getContext().getBizParams();
        Integer showType = boardQuestion.getShowType();
        Map showDefineDTO = bizParamsDTO.getShowDefine();
        SchemaMetricShowDefine showDefine = (SchemaMetricShowDefine)new JSONObject((Object)showDefineDTO).toBean(SchemaMetricShowDefine.class);
        if (Objects.nonNull(showType)) {
            ((SchemaMetricShowDefine.ShowType.TypeItem)((SchemaMetricShowDefine.ShowType)showDefine.getShowType().get(0)).getType().get(0)).setValue(String.valueOf(showType));
            ((SchemaMetricShowDefine.ShowType.TypeItem)((SchemaMetricShowDefine.ShowType)showDefine.getShowType().get(0)).getType().get(0)).setUserGraph(String.valueOf(showType));
        }
        if (Objects.isNull(showDefine) || CollectionUtils.isEmpty((Collection)showDefine.getShowType())) {
            throw new IllegalArgumentException("\u8bed\u4e49\u5448\u73b0\u6570\u636e\u672a\u8fd4\u56de,\u672a\u627e\u5230\u5bf9\u5e94actionId");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (event.isSubscribe()) {
            param.put("type", "2");
            param.put("undeletable", event.isUndeletable());
            param.put("asaCode", event.getAsaCode());
            param.put("ruleId", event.getMsgExt().get("ruleId"));
            param.put("chartTitle", event.getMsgExt().get("chartTitle"));
            adeDatasetReqDTO.setParam(param);
        }
        adeDatasetReqDTO.setEocMaps(bizParamsDTO.getEocMaps());
        adeDatasetReqDTO.setDatasetList(bizParamsDTO.getDatasetList());
        adeDatasetReqDTO.setAppCode(boardQuestion.getAppCode());
        adeDatasetReqDTO.setLocale(event.getLang());
        adeDatasetReqDTO.setMessageId(String.valueOf(event.getGenerateSerialNo()));
        adeDatasetReqDTO.setParam(param);
        adeDatasetReqDTO.setMock(false);
        adeDatasetReqDTO.setQuestion(bizParamsDTO.getQuestion());
        adeDatasetReqDTO.setMethod(SchemaDataEnum.DATASET.getCode());
        adeDatasetReqDTO.setScene(event.getSceneDTO());
        adeDatasetReqDTO.setDataset(boardQuestion.getSolutionStep());
        adeDatasetReqDTO.setDataTag(bizParamsDTO.getDataTagParam());
        adeDatasetReqDTO.setShowDefine(showDefine);
        adeDatasetReqDTO.setRequestTime(TimeUtils.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy-MM-dd HH:mm:ss"));
        adeDatasetReqDTO.setRequestor(event.getUser().getUserId());
        adeDatasetReqDTO.setTenantId(event.getUser().getTenantId());
        adeDatasetReqDTO.setProductLineInfo(event.getProductLineInfo());
        adeDatasetReqDTO.setExplain4Gpt(bizParamsDTO.getExplain4Gpt());
        adeDatasetReqDTO.setProductVersion(event.getProductVersion());
        adeDatasetReqDTO.setTablePreviewIf(false);
        adeDatasetReqDTO.setStepFilterAnalysis(boardQuestion.getStepFilterAnalysis());
        adeDatasetReqDTO.setFilterAnalysis(boardQuestion.isFilterAnalysis());
        adeDatasetReqDTO.setSaveTransResult(event.getSaveTransResult());
        return adeDatasetReqDTO;
    }

    public void processPPT(AthenaMessageEvent event) {
        AppAuthContextHolder.clearContext();
        Pair result = this.schemaPPTService.process(event);
        if (result.getRight() == null || StringUtils.isEmpty((CharSequence)((QuerySchemaResDTO)result.getRight()).getData().getMethod())) {
            String sysError = this.messageUtil.getMessageByLangNameWithFormat("message.system.schema.error", event.getLang(), new Object[0]);
            HashMap<String, Object> queryData = new HashMap<String, Object>();
            queryData.put("title", "\u8bed\u4e49\u8bc6\u522b");
            queryData.put("content", sysError);
            queryData.put("status", false);
            this.updatePPTDataByError(event, null, queryData);
            log.info("ppt\u8bed\u4e49\u8bc6\u522b\u5931\u8d25 right :{}", (Object)JsonUtils.objectToString((Object)result));
            return;
        }
        if (!((Boolean)result.getLeft()).booleanValue()) {
            log.info("ppt\u8bed\u4e49\u8bc6\u522b\u5931\u8d25 left :{}", (Object)JsonUtils.objectToString((Object)result));
            this.updatePPTDataByError(event, ((QuerySchemaResDTO)result.getRight()).getData().getDataset().getProcessStreamData(), new HashMap());
            return;
        }
        QuerySchemaResDTO querySchemaResDTO = (QuerySchemaResDTO)result.getRight();
        String router = String.valueOf(querySchemaResDTO.getRoute());
        String serviceName = this.getServiceNameByQuerySchema(router);
        this.agileDataHandlerProcessor.getEnumServiceByType((Enum)AgileDataEnum.queryTypeEnumByCode((String)serviceName)).process(event, querySchemaResDTO);
    }

    public void processAIBoard(AthenaMessageEvent event) {
        AppAuthContextHolder.clearContext();
        Pair result = this.schemaAIBoardAnalyzeService.process(event);
        if (result.getRight() == null || StringUtils.isEmpty((CharSequence)((QuerySchemaResDTO)result.getRight()).getData().getMethod())) {
            String sysError = this.messageUtil.getMessageByLangNameWithFormat("message.system.schema.error", event.getLang(), new Object[0]);
            HashMap<String, Object> queryData = new HashMap<String, Object>();
            queryData.put("title", "\u8bed\u4e49\u8bc6\u522b");
            queryData.put("content", sysError);
            queryData.put("status", false);
            this.updateAIBoardDataByError(event, null, queryData);
            log.info("\u5bf9\u8bdd\u770b\u677f\u8bed\u4e49\u8bc6\u522b\u5931\u8d25 right :{}", (Object)JsonUtils.objectToString((Object)result));
            return;
        }
        if (!((Boolean)result.getLeft()).booleanValue()) {
            log.info("\u5bf9\u8bdd\u770b\u677f\u8bed\u4e49\u8bc6\u522b\u5931\u8d25 left :{}", (Object)JsonUtils.objectToString((Object)result));
            HashMap<String, Object> queryData = new HashMap<String, Object>();
            queryData.put("title", "\u8bed\u4e49\u8bc6\u522b");
            queryData.put("content", ((QuerySchemaResDTO)result.getRight()).getData().getDataset().getReply());
            queryData.put("status", false);
            this.updateAIBoardDataByError(event, ((QuerySchemaResDTO)result.getRight()).getData().getDataset().getProcessStreamData(), new HashMap());
            return;
        }
        QuerySchemaResDTO querySchemaResDTO = (QuerySchemaResDTO)result.getRight();
        String router = String.valueOf(querySchemaResDTO.getRoute());
        String serviceName = this.getServiceNameByQuerySchema(router);
        this.agileDataHandlerProcessor.getEnumServiceByType((Enum)AgileDataEnum.queryTypeEnumByCode((String)serviceName)).process(event, querySchemaResDTO);
    }

    public void processPPTAfter(AuthoredUser user, Long pptMessageId) {
        AgileDataFileDTO agileDataFileDTO = new AgileDataFileDTO();
        agileDataFileDTO.setMessageId(pptMessageId);
        agileDataFileDTO.setMessageStatus(Integer.valueOf(1));
        this.echoService.updateAgileDataFile(agileDataFileDTO, user.getToken(), user.getTenantId());
    }

    public void processAIBoardAfter(AuthoredUser user, Long aiBoardMessageId) {
        AIBoardDTO aiBoardDTO = new AIBoardDTO();
        aiBoardDTO.setMessageId(aiBoardMessageId);
        aiBoardDTO.setMessageStatus(Integer.valueOf(1));
        this.echoService.updateAIBoard(aiBoardDTO, user.getToken(), user.getTenantId());
    }

    public void processAutoData(AthenaMessageEvent event, String url, Map<String, Object> req, SSEBaseEvent sseBaseEvent) {
        AppAuthContextHolder.clearContext();
        AutoDataQuestionResDTO.AutoDataQuestion.RecognitionResult result = this.schemaAutoDataQuestionService.processAutoData(event, req);
        HashMap<String, AutoDataQuestionResDTO.AutoDataQuestion.RecognitionResult> sendMap = new HashMap<String, AutoDataQuestionResDTO.AutoDataQuestion.RecognitionResult>();
        if (result == null) {
            return;
        }
        sendMap.put("recognitionResult", result);
        this.semcService.sendMessageToGpt(event, sendMap);
    }
}

