/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.pannel;

import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateCostService;
import com.digiwin.athena.adt.agileReport.service.AgileDataCostDetailService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.ade.AdeMetricReqDTO;
import com.digiwin.athena.adt.domain.dto.agileDataProcess.AgileDataProcessResDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaMetricDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.adt.util.agileData.AgileDataAnalysisUtils;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgileDataMetricPanelServiceImpl
extends AbsAgileDataProcess {
    private static final Logger log = LoggerFactory.getLogger(AgileDataMetricPanelServiceImpl.class);
    @Resource
    private ADEService adeService;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private AgileDataCalculateCostService agileDataCalculateCostService;
    @Autowired
    private AgileDataCostDetailService agileDataCostDetailService;

    public AgileDataProcessResDTO process(AthenaMessageEvent event, QuerySchemaResDTO responseData) {
        AgileDataProcessResDTO result = AgileDataProcessResDTO.init();
        String question2 = event.getQuestion();
        long getQuerySchemaTook = System.currentTimeMillis();
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u95ee\u53e5\u5165\u53c2\uff1a{}", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), question2, JsonUtils.objectToString((Object)event.getMsgBody())});
        LogDto logDto = new LogDto("\u83b7\u53d6\u610f\u56fe\u8bc6\u522b\u6570\u636e\uff1a" + JsonUtils.objectToString((Object)responseData));
        log.info(logDto.toString());
        QuerySchemaMetricDTO metric = responseData.getData().getMetric();
        try {
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u95ee\u53e5\u5165\u53c2\uff1a{}", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), question2, JsonUtils.objectToString((Object)event.getMsgBody())});
            AdeMetricReqDTO adeMetricReqDTO = AdeMetricReqDTO.BuildMetricAdeReq((AthenaMessageEvent)event, (QuerySchemaMetricDTO)metric);
            Map map = this.sendMessageToAde(event, adeMetricReqDTO, responseData);
            if (Objects.isNull(map) || MapUtils.getMap((Map)map, (Object)"data") == null) {
                result.setMsg(MapUtils.getString((Map)map, (Object)"msg"));
                return result;
            }
            Map dataMap = MapUtils.getMap((Map)map, (Object)"data");
            SnapShotDTO snapShotDTO = (SnapShotDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)dataMap), SnapShotDTO.class);
            if (snapShotDTO != null) {
                result = this.agileDataCalculateCostService.combinedBillingCalculationPanel(event, snapShotDTO);
                if (StringUtils.isNotEmpty((CharSequence)snapShotDTO.getSnapshotId())) {
                    this.agileDataCostDetailService.saveAgileDataCostDetail(dataMap, event.getUser(), event.getPtxId(), event.getAppCode(), event.getAppName(), event.getSourceName());
                }
            }
        }
        catch (Exception e) {
            String sysError = this.messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error", event.getLang(), new Object[0]);
            this.saveAbnormalLog(event, sysError, Integer.valueOf(1), Integer.valueOf(0));
        }
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u95ee\u53e5\u51fa\u53c2\uff1a{},\u8017\u65f6:{}ms", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), question2, JsonUtils.objectToString((Object)event.getMsgBody()), System.currentTimeMillis() - getQuerySchemaTook});
        return result;
    }

    public Map<String, Object> sendMessageToAde(AthenaMessageEvent event, AdeMetricReqDTO adeMetricReqDTO, QuerySchemaResDTO responseData) {
        String question2 = event.getQuestion();
        String combinationQuestion = event.getCombinationQuestion();
        Long generateSerialNo = event.getGenerateSerialNo();
        HashMap<String, Object> response = new HashMap();
        Map req = this.parameterBasedOnVersion(responseData, event);
        try {
            response = this.adeService.reqMetricSnapShotData(req, event);
            AgileDataAnalysisUtils.transAnalysisParams((QuerySchemaResDTO)responseData, (Object)adeMetricReqDTO, (AthenaMessageEvent)event);
            if (response == null || MapUtils.getMap(response, (Object)"data") == null) {
                String tipMessage = this.messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error", event.getLang(), new Object[0]);
                this.saveAbnormal(event, tipMessage, Integer.valueOf(0));
            }
            this.saveQuestionData(MapUtils.getMap(response, (Object)"data"), event, question2, combinationQuestion, generateSerialNo);
            this.saveBuiltClassifications(event, response);
        }
        catch (Exception e) {
            HashMap sendMap = Maps.newHashMap();
            sendMap.put("prompt", e.getMessage());
            String tipMessage = this.messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error", event.getLang(), new Object[0]);
            this.saveAbnormal(event, tipMessage, Integer.valueOf(0));
        }
        return response;
    }
}

