/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.schema;

import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.agileReport.service.impl.process.schema.SchemaDataProcessDesignerServiceImpl;
import com.digiwin.athena.adt.agileReport.service.impl.process.schema.SchemaDataProcessMetricServiceImpl;
import com.digiwin.athena.adt.domain.dto.echo.EchoSubmitReq;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaDebugDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbsSchemaDataProcess
extends AbsAgileDataProcess {
    private static final Logger log = LoggerFactory.getLogger(AbsSchemaDataProcess.class);
    @Autowired
    private EchoService echoService;
    @Autowired
    private SchemaDataProcessDesignerServiceImpl schemaDataProcessDesignerService;
    @Autowired
    private SchemaDataProcessMetricServiceImpl schemaDataProcessMetricService;

    public QuerySchemaDebugDTO assembleQuestionByMsg(String msg) {
        String[] parts = msg.split("\\*");
        List partList = Arrays.stream(parts).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        return QuerySchemaDebugDTO.builderDebugByParams(partList);
    }

    public QuerySchemaDebugDTO paramQuestionByMsg(String msg) {
        String[] parts = msg.split("\\*");
        List partList = Arrays.stream(parts).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        return QuerySchemaDebugDTO.builderParamByParams(partList);
    }

    public List<Map<String, Object>> getListBySchemaData(QuerySchemaResDTO querySchemaResDTO, String enumStr) {
        return querySchemaResDTO.getData().getDataflow().stream().map(data -> (List)MapUtils.getObject((Map)data, (Object)enumStr)).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public String getStringBySchemaData(QuerySchemaResDTO querySchemaResDTO, String enumStr) {
        return querySchemaResDTO.getData().getDataflow().stream().map(data -> MapUtils.getString((Map)data, (Object)enumStr)).filter(Objects::nonNull).findFirst().orElse("");
    }

    public void sendSpecialMessage(Map<String, Object> data, AthenaMessageEvent event) {
        String specialMode = String.valueOf(data.get("specialMode"));
        try {
            this.setAthenaEventMessageType(event, "1".equals(specialMode) ? "1" : "3");
            this.echoService.echoMongodbSubmit(EchoSubmitReq.builderSchemaGuidance((AthenaMessageEvent)event, (List)("1".equals(specialMode) ? event.getTargets() : event.getScenes())), event.getUser().getToken(), event.getUser().getTenantId());
            if ("1".equals(specialMode)) {
                LogUtils.buildAgileLog((String)"adt", (String)"moreTarget", (String)"1", (String)JsonUtils.objectToString(data), (String)JsonUtils.objectToString((Object)event.getTargets()), (String)"");
            } else {
                LogUtils.buildAgileLog((String)"adt", (String)"moreScene", (String)"1", (String)specialMode, (String)JsonUtils.objectToString((Object)event.getScenes()), (String)"");
            }
        }
        catch (Exception e) {
            if ("1".equals(specialMode)) {
                LogUtils.buildAgileLog((String)"adt", (String)"moreTarget", (String)TroubleToolCodeEnum.ADT_901_0115.getErrCode(), (String)specialMode, (String)TroubleToolCodeEnum.ADT_901_0115.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0115.getSuggestion());
            }
            LogUtils.buildAgileLog((String)"adt", (String)"moreScene", (String)TroubleToolCodeEnum.ADT_901_0116.getErrCode(), (String)specialMode, (String)TroubleToolCodeEnum.ADT_901_0116.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0116.getSuggestion());
        }
    }

    public void setAthenaEventMethod(AthenaMessageEvent event, String schemaMethod) {
        if (StringUtils.isEmpty((CharSequence)schemaMethod)) {
            event.setMethod("dataflow");
        } else {
            event.setMethod(schemaMethod);
        }
    }

    public Pair<Boolean, QuerySchemaResDTO> absCheckSchemaResponseData(AthenaMessageEvent event, QuerySchemaResDTO querySchemaResDTO) {
        Pair result;
        if (querySchemaResDTO == null || StringUtils.isEmpty((CharSequence)querySchemaResDTO.getData().getMethod()) || CollectionUtils.isEmpty((Collection)querySchemaResDTO.getData().getDataflow()) && Objects.isNull(querySchemaResDTO.getData().getMetric()) && Objects.isNull(querySchemaResDTO.getData().getDataset())) {
            return Pair.of((Object)false, null);
        }
        String method = querySchemaResDTO.getData().getMethod();
        this.setAthenaEventMethod(event, method);
        switch (method) {
            case "dataflow": {
                boolean check = this.schemaDataProcessDesignerService.checkDataFlowResponseData(querySchemaResDTO, event);
                result = check ? Pair.of((Object)true, (Object)querySchemaResDTO) : Pair.of((Object)false, (Object)querySchemaResDTO);
                querySchemaResDTO.setRoute(SchemaDataEnum.DESIGNER.getCode());
                LogUtils.buildAgileLog((String)"adt", (String)"sceneAnalysis", (String)"1", (String)JsonUtils.objectToString((Object)querySchemaResDTO), (String)JsonUtils.objectToString((Object)result), (String)"");
                break;
            }
            case "metric": {
                boolean check = this.schemaDataProcessMetricService.checkMetricResponseData(querySchemaResDTO, event);
                result = check ? Pair.of((Object)true, (Object)querySchemaResDTO) : Pair.of((Object)false, (Object)querySchemaResDTO);
                querySchemaResDTO.setRoute(SchemaDataEnum.METRIC.getCode());
                LogUtils.buildAgileLog((String)"adt", (String)"metricAnalysis", (String)"1", (String)JsonUtils.objectToString((Object)querySchemaResDTO), (String)JsonUtils.objectToString((Object)result), (String)"");
                break;
            }
            case "dataset": {
                boolean check = this.schemaDataProcessMetricService.checkDatasetResponseData(querySchemaResDTO, event);
                result = check ? Pair.of((Object)true, (Object)querySchemaResDTO) : Pair.of((Object)false, (Object)querySchemaResDTO);
                querySchemaResDTO.setRoute(SchemaDataEnum.DATASET.getCode());
                LogUtils.buildAgileLog((String)"adt", (String)"datasetAnalysis", (String)"1", (String)JsonUtils.objectToString((Object)querySchemaResDTO), (String)JsonUtils.objectToString((Object)result), (String)"");
                break;
            }
            default: {
                result = Pair.of((Object)false, null);
            }
        }
        return result;
    }
}

