/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.SchemaDataType;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import com.digiwin.athena.adt.agileReport.service.impl.process.schema.AbsSchemaDataProcess;
import com.digiwin.athena.adt.agileReport.service.impl.process.schema.SchemaDataProcessMetricServiceImpl;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaReqDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@SchemaDataType(value=SchemaDataEnum.AI_BOARD_ANALYZE)
public class SchemaDataProcessAIBoardAnalyzeServiceImpl
extends AbsSchemaDataProcess
implements SchemaDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(SchemaDataProcessAIBoardAnalyzeServiceImpl.class);
    @Autowired
    private ChatbiService chatbiService;
    @Autowired
    private SchemaDataProcessMetricServiceImpl schemaDataProcessMetricService;

    public Pair<Boolean, QuerySchemaResDTO> process(AthenaMessageEvent event) {
        QuerySchemaResDTO schema = new QuerySchemaResDTO();
        QuerySchemaReqDTO req = event.getQuerySchemaReqDTO();
        try {
            schema = this.chatbiService.getQuerySchema(req, event);
            LogUtils.buildAgileLog((String)"adt", (String)"AIBoardSchemaPostReq", (String)"1", (String)JsonUtils.objectToString((Object)req), (String)JsonUtils.objectToString((Object)schema), (String)"");
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"AIBoardSchemaPost", (String)TroubleToolCodeEnum.ADT_901_0106.getErrCode(), (String)JsonUtils.objectToString((Object)req), (String)TroubleToolCodeEnum.ADT_901_0106.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0106.getSuggestion());
        }
        return this.checkSchemaResponseData(event, schema);
    }

    public Pair<Boolean, QuerySchemaResDTO> checkSchemaResponseData(AthenaMessageEvent event, QuerySchemaResDTO querySchemaResDTO) {
        Pair result;
        if (querySchemaResDTO == null || StringUtils.isEmpty((CharSequence)querySchemaResDTO.getData().getMethod()) || CollectionUtils.isEmpty((Collection)querySchemaResDTO.getData().getDataflow()) && Objects.isNull(querySchemaResDTO.getData().getMetric()) && Objects.isNull(querySchemaResDTO.getData().getDataset())) {
            return Pair.of((Object)false, null);
        }
        String method = querySchemaResDTO.getData().getMethod();
        this.setAthenaEventMethod(event, method);
        if (method.equals("dataset")) {
            boolean check = this.schemaDataProcessMetricService.checkDatasetResponseData(querySchemaResDTO, event);
            result = check ? Pair.of((Object)true, (Object)querySchemaResDTO) : Pair.of((Object)false, (Object)querySchemaResDTO);
            querySchemaResDTO.setRoute(SchemaDataEnum.AI_BOARD_ANALYZE.getCode());
        } else {
            result = Pair.of((Object)false, null);
        }
        return result;
    }

    public Map<String, Object> getQuerySchemaReq(AthenaMessageEvent event) {
        return null;
    }

    public Pair<Boolean, QuerySchemaResDTO> sseProcess(AthenaMessageEvent event, JSONObject jsonObject) {
        return null;
    }
}

