/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.SchemaDataType;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AgileDataProcessDesignerServiceImpl;
import com.digiwin.athena.adt.agileReport.service.impl.process.schema.AbsSchemaDataProcess;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaDebugDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaReqDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@SchemaDataType(value=SchemaDataEnum.DEBUG)
public class SchemaDataProcessDebugServiceImpl
extends AbsSchemaDataProcess
implements SchemaDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(SchemaDataProcessDebugServiceImpl.class);
    @Autowired
    private ChatbiService chatbiService;
    @Autowired
    private AgileDataProcessDesignerServiceImpl agileDataProcessDesignerServiceImpl;

    public Pair<Boolean, QuerySchemaResDTO> process(AthenaMessageEvent event) {
        String question2 = event.getQuestion();
        QuerySchemaReqDTO req = event.getQuerySchemaReqDTO();
        req.setMultiDialogue(Boolean.valueOf(false));
        QuerySchemaDebugDTO querySchemaDebugDTO = this.assembleQuestionByMsg(question2.trim());
        String debugQuestion = querySchemaDebugDTO.getQuestion();
        if (question2.contains("*debug*")) {
            return this.debugProcess(event, req, querySchemaDebugDTO, debugQuestion);
        }
        if (question2.contains("*test")) {
            return this.testDebugProcess(event, req, querySchemaDebugDTO, debugQuestion);
        }
        if (question2.contains("*pr-debug*")) {
            return Pair.of((Object)true, (Object)QuerySchemaResDTO.builderPrDebug((QuerySchemaDebugDTO)querySchemaDebugDTO));
        }
        return null;
    }

    public Pair<Boolean, QuerySchemaResDTO> debugProcess(AthenaMessageEvent event, QuerySchemaReqDTO req, QuerySchemaDebugDTO querySchemaDebugDTO, String debugQuestion) {
        QuerySchemaResDTO schema = new QuerySchemaResDTO();
        try {
            req.setSceneCode(querySchemaDebugDTO.getSceneCode());
            req.setMessage(debugQuestion);
            req.setDebugMode("3");
            schema = this.chatbiService.getQuerySchema(req, event);
            LogUtils.buildAgileLog((String)"adt", (String)"debug", (String)"1", (String)JsonUtils.objectToString((Object)req), (String)JsonUtils.objectToString((Object)schema), (String)"");
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"debug", (String)TroubleToolCodeEnum.ADT_901_0106.getErrCode(), (String)JsonUtils.objectToString((Object)req), (String)TroubleToolCodeEnum.ADT_901_0106.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0106.getSuggestion());
        }
        return this.absCheckSchemaResponseData(event, schema);
    }

    public Pair<Boolean, QuerySchemaResDTO> testDebugProcess(AthenaMessageEvent event, QuerySchemaReqDTO req, QuerySchemaDebugDTO querySchemaDebugDTO, String debugQuestion) {
        QuerySchemaResDTO schema = new QuerySchemaResDTO();
        try {
            req.setSceneCode(querySchemaDebugDTO.getSceneCode());
            req.setMessage(debugQuestion);
            req.setDebugMode("4");
            schema = this.chatbiService.getQuerySchema(req, event);
            LogUtils.buildAgileLog((String)"adt", (String)"test", (String)"1", (String)JsonUtils.objectToString((Object)req), (String)JsonUtils.objectToString((Object)schema), (String)"");
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"test", (String)TroubleToolCodeEnum.ADT_901_0110.getErrCode(), (String)JsonUtils.objectToString((Object)req), (String)TroubleToolCodeEnum.ADT_901_0110.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0110.getSuggestion());
        }
        return this.absCheckSchemaResponseData(event, schema);
    }

    public Map<String, Object> getQuerySchemaReq(AthenaMessageEvent event) {
        String question2 = event.getQuestion();
        QuerySchemaReqDTO req = event.getQuerySchemaReqDTO();
        req.setMultiDialogue(Boolean.valueOf(false));
        QuerySchemaDebugDTO querySchemaDebugDTO = this.assembleQuestionByMsg(question2.trim());
        String debugQuestion = querySchemaDebugDTO.getQuestion();
        if (question2.contains("*debug*")) {
            return this.debugSseReq(req, querySchemaDebugDTO, debugQuestion);
        }
        if (question2.contains("*test")) {
            return this.testDebugSseReq(req, querySchemaDebugDTO, debugQuestion);
        }
        if (question2.contains("*pr-debug*")) {
            this.agileDataProcessDesignerServiceImpl.process(event, QuerySchemaResDTO.builderPrDebug((QuerySchemaDebugDTO)querySchemaDebugDTO));
        }
        return null;
    }

    private Map<String, Object> debugSseReq(QuerySchemaReqDTO req, QuerySchemaDebugDTO querySchemaDebugDTO, String debugQuestion) {
        QuerySchemaResDTO schema = new QuerySchemaResDTO();
        try {
            req.setSceneCode(querySchemaDebugDTO.getSceneCode());
            req.setMessage(debugQuestion);
            req.setDebugMode("3");
            LogUtils.buildAgileLog((String)"adt", (String)"test", (String)"1", (String)JsonUtils.objectToString((Object)req), (String)JsonUtils.objectToString((Object)schema), (String)"");
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"test", (String)TroubleToolCodeEnum.ADT_901_0110.getErrCode(), (String)JsonUtils.objectToString((Object)req), (String)TroubleToolCodeEnum.ADT_901_0110.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0110.getSuggestion());
        }
        return CommonUtil.convertObjectToMap((Object)req);
    }

    private Map<String, Object> testDebugSseReq(QuerySchemaReqDTO req, QuerySchemaDebugDTO querySchemaDebugDTO, String debugQuestion) {
        QuerySchemaResDTO schema = new QuerySchemaResDTO();
        try {
            req.setSceneCode(querySchemaDebugDTO.getSceneCode());
            req.setMessage(debugQuestion);
            req.setDebugMode("4");
            LogUtils.buildAgileLog((String)"adt", (String)"debug", (String)"1", (String)JsonUtils.objectToString((Object)req), (String)JsonUtils.objectToString((Object)schema), (String)"");
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"debug", (String)TroubleToolCodeEnum.ADT_901_0106.getErrCode(), (String)JsonUtils.objectToString((Object)req), (String)TroubleToolCodeEnum.ADT_901_0106.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0106.getSuggestion());
        }
        return CommonUtil.convertObjectToMap((Object)req);
    }

    public Pair<Boolean, QuerySchemaResDTO> sseProcess(AthenaMessageEvent event, JSONObject jsonObject) {
        QuerySchemaResDTO querySchemaResDTO = (QuerySchemaResDTO)JSONObject.parseObject((String)jsonObject.get((Object)"message").toString()).toJavaObject(QuerySchemaResDTO.class);
        return this.absCheckSchemaResponseData(event, querySchemaResDTO);
    }
}

