/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.SchemaDataType;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import com.digiwin.athena.adt.agileReport.service.impl.process.schema.AbsSchemaDataProcess;
import com.digiwin.athena.adt.domain.dto.echo.EchoSubmitReq;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaDatasetDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaMetricDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@SchemaDataType(value=SchemaDataEnum.METRIC)
public class SchemaDataProcessMetricServiceImpl
extends AbsSchemaDataProcess
implements SchemaDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(SchemaDataProcessMetricServiceImpl.class);
    @Autowired
    private SemcService semcService;
    @Autowired
    private EchoService echoService;

    public Pair<Boolean, QuerySchemaResDTO> process(AthenaMessageEvent event) {
        return Pair.of((Object)false, null);
    }

    public Map<String, Object> getQuerySchemaReq(AthenaMessageEvent event) {
        return new HashMap<String, Object>();
    }

    public boolean checkMetricResponseData(QuerySchemaResDTO querySchemaResDTO, AthenaMessageEvent event) {
        QuerySchemaMetricDTO metric = querySchemaResDTO.getData().getMetric();
        boolean isCheck = false;
        try {
            Integer code = metric.getCode();
            if (Objects.isNull(code)) {
                return false;
            }
            event.setCombinationQuestion(metric.getCombinationQuestion());
            event.setProductLineInfo(metric.getProductLineInfo());
            event.setAnswerResult(metric.getSentenceType());
            event.setSentences(metric.getSentences());
            switch (((Object)code).toString()) {
                case "0": {
                    List metricList = metric.getMetricList();
                    if (CollectionUtils.isNotEmpty((Collection)metricList)) {
                        event.setMetricList(metricList);
                    }
                    this.setAthenaEventAppCodeAndName(event, metric.getApplicationList());
                    this.setAthenaEventMessageType(event, SchemaDataEnum.METRIC.getValue());
                    isCheck = true;
                    break;
                }
                case "1": {
                    this.sendMessageAndSaveLogReply(event, metric);
                    break;
                }
                case "2": {
                    try {
                        this.setAthenaEventMessageType(event, SchemaDataEnum.METRIC_APP.getValue());
                        this.echoService.echoMongodbSubmit(EchoSubmitReq.builderSchemaGuidance((AthenaMessageEvent)event, (List)metric.getApplicationList()), event.getUser().getToken(), event.getUser().getTenantId());
                        this.sendMessageAndSaveLogReply(event, metric);
                        LogUtils.buildAgileLog((String)"adt", (String)"moreApplication", (String)"1", (String)JsonUtils.objectToString((Object)metric.getApplicationList()), (String)"", (String)"");
                    }
                    catch (Exception e) {
                        LogUtils.buildAgileLog((String)"adt", (String)"moreApplication", (String)TroubleToolCodeEnum.ADT_901_0114.getErrCode(), (String)JsonUtils.objectToString((Object)metric.getApplicationList()), (String)TroubleToolCodeEnum.ADT_901_0114.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0114.getSuggestion());
                    }
                    break;
                }
                case "3": {
                    this.setAthenaEventMessageType(event, SchemaDataEnum.METRIC.getValue());
                    break;
                }
            }
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"metricAnalysis", (String)TroubleToolCodeEnum.ADT_901_0112.getErrCode(), (String)JsonUtils.objectToString((Object)querySchemaResDTO), (String)TroubleToolCodeEnum.ADT_901_0112.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0112.getSuggestion());
        }
        return isCheck;
    }

    public void setAthenaEventAppCodeAndName(AthenaMessageEvent event, List<Map<String, Object>> applicationList) {
        if (CollectionUtils.isNotEmpty(applicationList)) {
            Object appCode = applicationList.get(0).get("appCode");
            Object appName = applicationList.get(0).get("appName");
            event.setAppCode(Objects.isNull(appCode) ? "" : String.valueOf(appCode));
            event.setAppName(Objects.isNull(appName) ? "" : String.valueOf(appName));
        }
    }

    public void sendMessageAndSaveLogReply(AthenaMessageEvent event, QuerySchemaMetricDTO schemaData) {
        String reply = schemaData.getReply();
        HashMap<String, String> msgBody = new HashMap<String, String>();
        msgBody.put("prompt", reply);
        msgBody.put("scrumbiQuestion", event.getQuestion());
        if (event.isSendNana()) {
            this.semcService.sendMessageToGpt(event, msgBody);
            this.saveAbnormalLog(event, reply, Integer.valueOf(1), Integer.valueOf(0));
        }
    }

    public Pair<Boolean, QuerySchemaResDTO> sseProcess(AthenaMessageEvent event, JSONObject jsonObject) {
        return Pair.of((Object)false, null);
    }

    public boolean checkDatasetResponseData(QuerySchemaResDTO querySchemaResDTO, AthenaMessageEvent event) {
        QuerySchemaDatasetDTO dataset = querySchemaResDTO.getData().getDataset();
        boolean isCheck = false;
        try {
            Integer code = dataset.getCode();
            if (Objects.isNull(code)) {
                return false;
            }
            event.setCombinationQuestion(dataset.getCombinationQuestion());
            event.setProductLineInfo(dataset.getProductLineInfo());
            event.setAnswerResult(dataset.getSentenceType());
            event.setSentences(dataset.getSentences());
            switch (((Object)code).toString()) {
                case "0": {
                    List datasetList = dataset.getDatasetList();
                    if (CollectionUtils.isNotEmpty((Collection)datasetList)) {
                        event.setDatasetList(datasetList);
                    }
                    this.setAthenaEventAppCodeAndName(event, dataset.getApplicationList());
                    this.setAthenaEventMessageType(event, SchemaDataEnum.DATASET.getValue());
                    event.setProcessStreamData(dataset.getProcessStreamData());
                    event.setOrgOutPutSql(dataset.getOrgOutPutSql());
                    isCheck = true;
                    break;
                }
                case "1": {
                    this.sendMessageAndSaveLogReplyByDataset(event, dataset);
                    break;
                }
                case "2": {
                    try {
                        this.setAthenaEventMessageType(event, SchemaDataEnum.METRIC_APP.getValue());
                        this.echoService.echoMongodbSubmit(EchoSubmitReq.builderSchemaGuidance((AthenaMessageEvent)event, (List)dataset.getApplicationList()), event.getUser().getToken(), event.getUser().getTenantId());
                        this.sendMessageAndSaveLogReplyByDataset(event, dataset);
                        LogUtils.buildAgileLog((String)"adt", (String)"moreApplication", (String)"1", (String)JsonUtils.objectToString((Object)dataset.getApplicationList()), (String)"", (String)"");
                    }
                    catch (Exception e) {
                        LogUtils.buildAgileLog((String)"adt", (String)"moreApplication", (String)TroubleToolCodeEnum.ADT_901_0114.getErrCode(), (String)JsonUtils.objectToString((Object)dataset.getApplicationList()), (String)TroubleToolCodeEnum.ADT_901_0114.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0114.getSuggestion());
                    }
                    break;
                }
                case "3": {
                    this.setAthenaEventMessageType(event, SchemaDataEnum.DATASET.getValue());
                    break;
                }
            }
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"datasetAnalysis", (String)TroubleToolCodeEnum.ADT_901_0129.getErrCode(), (String)JsonUtils.objectToString((Object)querySchemaResDTO), (String)TroubleToolCodeEnum.ADT_901_0129.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0129.getSuggestion());
        }
        return isCheck;
    }

    public void sendMessageAndSaveLogReplyByDataset(AthenaMessageEvent event, QuerySchemaDatasetDTO dataset) {
        String reply = dataset.getReply();
        HashMap<String, String> msgBody = new HashMap<String, String>();
        msgBody.put("prompt", reply);
        msgBody.put("scrumbiQuestion", event.getQuestion());
        if (event.isSendNana()) {
            this.semcService.sendMessageToGpt(event, msgBody);
            this.saveAbnormalLog(event, reply, Integer.valueOf(1), Integer.valueOf(0));
        }
    }
}

