/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.SchemaDataType;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import com.digiwin.athena.adt.agileReport.service.impl.process.schema.AbsSchemaDataProcess;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.ParamBuildWebDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaDebugDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaReqDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@SchemaDataType(value=SchemaDataEnum.PARAM)
public class SchemaDataProcessParamServiceImpl
extends AbsSchemaDataProcess
implements SchemaDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(SchemaDataProcessParamServiceImpl.class);
    @Autowired
    private ChatbiService chatbiService;
    @Autowired
    private SemcService semcService;
    @Autowired
    private MessageUtil messageUtil;

    public Pair<Boolean, QuerySchemaResDTO> process(AthenaMessageEvent event) {
        String question2 = event.getQuestion();
        QuerySchemaDebugDTO querySchemaParamDTO = this.paramQuestionByMsg(question2.trim());
        QuerySchemaReqDTO req = QuerySchemaReqDTO.builderSchemaParamReq((AthenaMessageEvent)event, (QuerySchemaDebugDTO)querySchemaParamDTO);
        LogUtils.buildAgileLog((String)"adt", (String)"param", (String)"1", (String)JsonUtils.objectToString((Object)req), (String)"", (String)"");
        Pair result = this.absCheckSchemaResponseData(event, this.chatbiService.getQuerySchema(req, event));
        return this.schemaDataProcessParam(event, result);
    }

    public Pair<Boolean, QuerySchemaResDTO> schemaDataProcessParam(AthenaMessageEvent event, Pair<Boolean, QuerySchemaResDTO> result) {
        String question2 = event.getQuestion();
        boolean check = (Boolean)result.getLeft();
        if (!check) {
            return Pair.of((Object)false, (Object)result.getRight());
        }
        QuerySchemaResDTO querySchemaResDTO = (QuerySchemaResDTO)result.getRight();
        HashMap<String, String> messageBody = new HashMap<String, String>();
        List paramDataList = this.getSchemaParamDataList(querySchemaResDTO.getData().getDataflow());
        if (CollectionUtils.isEmpty((Collection)paramDataList)) {
            messageBody.put("prompt", this.messageUtil.getMessageByLangNameWithFormat("message.param.noData", event.getLang(), new Object[0]));
            this.semcService.sendMessageToGpt(event, messageBody);
            return Pair.of((Object)false, (Object)querySchemaResDTO);
        }
        String combinationQuestion = this.getStringBySchemaData(querySchemaResDTO, "combinationQuestion");
        String webData = ParamBuildWebDTO.buildParamModel((List)paramDataList, (String)question2);
        messageBody.put("prompt", StringUtils.isNotEmpty((CharSequence)webData) ? webData : "params\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        if (MapUtils.isEmpty((Map)event.getMsgExt())) {
            event.setMsgExt((Map)Maps.newHashMap());
        }
        this.semcService.sendMessageToGpt(event, messageBody);
        this.saveAbnormalLog(event, this.messageUtil.getMessageByLangNameWithFormat("message.param.error", event.getLang(), new Object[0]), Integer.valueOf(1), Integer.valueOf(0));
        return Pair.of((Object)false, (Object)querySchemaResDTO);
    }

    public Pair<Boolean, QuerySchemaResDTO> sseProcess(AthenaMessageEvent event, JSONObject jsonObject) {
        QuerySchemaResDTO querySchemaResDTO = (QuerySchemaResDTO)JSONObject.parseObject((String)jsonObject.get((Object)"message").toString()).toJavaObject(QuerySchemaResDTO.class);
        return this.schemaDataProcessParam(event, this.absCheckSchemaResponseData(event, querySchemaResDTO));
    }

    public Map<String, Object> getQuerySchemaReq(AthenaMessageEvent event) {
        String question2 = event.getQuestion();
        QuerySchemaDebugDTO querySchemaParamDTO = this.paramQuestionByMsg(question2.trim());
        QuerySchemaReqDTO req = QuerySchemaReqDTO.builderSchemaParamReq((AthenaMessageEvent)event, (QuerySchemaDebugDTO)querySchemaParamDTO);
        LogUtils.buildAgileLog((String)"adt", (String)"param", (String)"1", (String)JsonUtils.objectToString((Object)req), (String)"", (String)"");
        return CommonUtil.convertObjectToMap((Object)req);
    }

    public List<Map<String, Object>> getSchemaParamDataList(List<Map<String, Object>> list) {
        if (list.stream().filter(data -> data.get("data") instanceof Collection).findFirst().isPresent()) {
            return null;
        }
        return list.stream().map(data -> (Map)data.get("data")).collect(Collectors.toList());
    }
}

