/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.SchemaDataType;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import com.digiwin.athena.adt.agileReport.service.impl.process.schema.AbsSchemaDataProcess;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaDataDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaLiteResDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@SchemaDataType(value=SchemaDataEnum.SPECIAL)
public class SchemaDataProcessSpecialServiceImpl
extends AbsSchemaDataProcess
implements SchemaDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(SchemaDataProcessSpecialServiceImpl.class);
    @Autowired
    private ChatbiService chatbiService;

    public Pair<Boolean, QuerySchemaResDTO> process(AthenaMessageEvent event) {
        HashMap<String, String> requestParam = new HashMap<String, String>();
        requestParam.put("message", event.getQuestion());
        QuerySchemaLiteResDTO querySchemaResDTO = this.chatbiService.getQuerySchemaSpecial(requestParam, event);
        return this.schemaDataProcessLite(event, querySchemaResDTO);
    }

    public Pair<Boolean, QuerySchemaResDTO> schemaDataProcessLite(AthenaMessageEvent event, QuerySchemaLiteResDTO querySchemaResDTO) {
        QuerySchemaResDTO result = new QuerySchemaResDTO();
        if (querySchemaResDTO == null || CollectionUtils.isEmpty((Collection)querySchemaResDTO.getData())) {
            return Pair.of((Object)false, null);
        }
        if (CollectionUtils.isNotEmpty((Collection)querySchemaResDTO.getData())) {
            querySchemaResDTO.getData().stream().forEach(item -> {
                String code = MapUtils.getString((Map)item, (Object)"code");
                if (StringUtils.equals((CharSequence)"1", (CharSequence)code)) {
                    item.put("code", "0");
                } else {
                    item.put("code", "1");
                }
            });
        }
        QuerySchemaDataDTO res = new QuerySchemaDataDTO();
        res.setDataflow(querySchemaResDTO.getData());
        res.setMethod(SchemaDataEnum.SPECIAL.getCode());
        result.setRoute(SchemaDataEnum.SPECIAL.getCode());
        result.setMsg(querySchemaResDTO.getMsg());
        result.setCode(querySchemaResDTO.getCode());
        result.setData(res);
        return Pair.of((Object)true, (Object)result);
    }

    public Pair<Boolean, QuerySchemaResDTO> sseProcess(AthenaMessageEvent event, JSONObject jsonObject) {
        QuerySchemaLiteResDTO querySchemaResDTO = (QuerySchemaLiteResDTO)JSONObject.parseObject((String)jsonObject.get((Object)"message").toString()).toJavaObject(QuerySchemaLiteResDTO.class);
        return this.schemaDataProcessLite(event, querySchemaResDTO);
    }

    public Map<String, Object> getQuerySchemaReq(AthenaMessageEvent event) {
        HashMap<String, Object> requestParam = new HashMap<String, Object>();
        requestParam.put("message", event.getQuestion());
        return requestParam;
    }
}

