/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.report;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataAbnormalDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AgileDataLogEvent;
import com.digiwin.athena.adt.agileReport.service.AgileReportAbnormalService;
import com.digiwin.athena.adt.domain.dto.AgileDataAnswerData;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.google.common.collect.Maps;
import com.google.common.eventbus.AsyncEventBus;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class AgileReportAbnormalServiceImpl
implements AgileReportAbnormalService {
    private static final Logger log = LoggerFactory.getLogger(AgileReportAbnormalServiceImpl.class);
    @Autowired
    @Qualifier(value="mongoAgileDataLogTemplate")
    private MongoTemplate mongoAgileDataLogTemplate;
    private static final String MONGODB_ANSWER_COLLECTION_NAME = "agile_data_result_log";
    @Autowired
    private AsyncEventBus localEventBus;

    public Boolean saveAbnormal(AuthoredUser authoredUser, AgileDataAbnormalDTO agileDataFeedBackDTO, String clientAgent) {
        AgileDataLogEvent agileDataLogEvent = new AgileDataLogEvent();
        agileDataLogEvent.setAuthoredUser(authoredUser);
        agileDataLogEvent.setGenerateSerialNo(agileDataFeedBackDTO.getGenerateSerialNo());
        agileDataLogEvent.setTerminal(clientAgent);
        agileDataLogEvent.setSnapshotId(agileDataFeedBackDTO.getSnapshotId());
        agileDataLogEvent.setQuestion(agileDataFeedBackDTO.getQuestion());
        agileDataLogEvent.setParams(MapUtils.isEmpty((Map)agileDataFeedBackDTO.getParams()) ? Maps.newHashMap() : agileDataFeedBackDTO.getParams());
        agileDataLogEvent.setType(Integer.valueOf(1));
        agileDataLogEvent.setSuccess(Integer.valueOf(0));
        agileDataLogEvent.setErrorAnswer(agileDataFeedBackDTO.getErrorMsg());
        this.localEventBus.post((Object)agileDataLogEvent);
        return true;
    }

    public Boolean saveAnswerResult(AuthoredUser authoredUser, AgileDataAnswerData agileDataAnswerData) {
        if (agileDataAnswerData != null) {
            this.mongoAgileDataLogTemplate.insert((Object)agileDataAnswerData, MONGODB_ANSWER_COLLECTION_NAME);
        }
        return true;
    }
}

