/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.app.config;

import com.digiwin.athena.adt.app.config.CustomerWebMvcConfigurationSupport;
import com.digiwin.athena.appcore.exception.GlobalExceptionHandler;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import java.util.List;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;

@Configuration
public class CustomerWebMvcConfigurationSupport
extends WebMvcConfigurationSupport {
    protected void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        for (HttpMessageConverter<?> httpMessageConverter : converters) {
            if (!MappingJackson2HttpMessageConverter.class.isInstance(httpMessageConverter)) continue;
            ((MappingJackson2HttpMessageConverter)httpMessageConverter).setObjectMapper(JsonUtils.createObjectMapper());
            break;
        }
    }

    @Bean
    MessageUtils messageUtils(MessageSource messageSource) {
        return new MessageUtils(messageSource);
    }

    @Bean
    GlobalExceptionHandler globalExceptionHandler() {
        return new GlobalExceptionHandler();
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"POST", "GET", "PUT", "OPTIONS", "DELETE", "PATCH", "HEAD"}).allowedHeaders(new String[]{"*"}).maxAge(3600L).allowCredentials(true);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        LocaleChangeInterceptor localeInterceptor = new LocaleChangeInterceptor();
        localeInterceptor.setParamName("lang");
        registry.addInterceptor((HandlerInterceptor)localeInterceptor);
    }

    @Bean
    public LocaleResolver localeResolver() {
        1 localeResolver = new /* Unavailable Anonymous Inner Class!! */;
        localeResolver.setDefaultLocale(Locale.forLanguageTag("zh-CN"));
        return localeResolver;
    }
}

