/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.app.config.executor;

import com.digiwin.athena.adt.app.config.executor.ThreadPoolMonitor;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@EnableAsync
public class ExecutorConfig {
    @Value(value="${async.executor.thread.core_pool_size}")
    private int corePoolSize;
    @Value(value="${async.executor.thread.max_pool_size}")
    private int maxPoolSize;
    @Value(value="${async.executor.thread.queue_capacity}")
    private int queueCapacity;
    @Value(value="${async.executor.thread.keepAliveTime}")
    private long keepAliveTime;
    @Value(value="${async.executor.thread.name.prefix}")
    private String namePrefix;

    @Bean(name={"asyncServiceExecutor"})
    public ExecutorService asyncServiceExecutor() {
        ThreadFactory normalThreadFactory = new ThreadFactoryBuilder().setNameFormat(this.namePrefix + "_%d").build();
        ThreadPoolMonitor executor = new ThreadPoolMonitor(this.corePoolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.SECONDS, new ArrayBlockingQueue(this.queueCapacity), this.queueCapacity, normalThreadFactory, this.namePrefix, (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        return executor;
    }

    @Bean(name={"asyncLogServiceExecutor"})
    public ExecutorService asyncLogServiceExecutor() {
        ThreadFactory normalThreadFactory = new ThreadFactoryBuilder().setNameFormat(this.namePrefix + "_%d").build();
        ThreadPoolMonitor executor = new ThreadPoolMonitor(this.corePoolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.SECONDS, new ArrayBlockingQueue(this.queueCapacity), this.queueCapacity, normalThreadFactory, this.namePrefix, (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        return executor;
    }
}

