/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.domain.aam.impl;

import com.digiwin.athena.adt.agileReport.constant.ErrorCodeEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.domain.aam.AAMService;
import com.digiwin.athena.adt.domain.dto.UploadAttachmentResp;
import com.digiwin.athena.adt.domain.dto.UploadParamDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Service
@Deprecated
public class AAMServiceImpl
implements AAMService {
    private static final Logger log = LoggerFactory.getLogger(AAMServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    private static final String ATMC_LOCAL = "locale";

    public UploadAttachmentResp uploadAgileData(UploadParamDTO uploadParamDTO) {
        String url = this.envProperties.getAamUri() + "/api/aam/v1/uploadAgileReport";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("fileJson", uploadParamDTO.getFileJson());
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (UploadAttachmentResp)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (ResourceAccessException e) {
            LogUtils.buildAgileLog((String)"adt", (String)"snapshotSave", (String)TroubleToolCodeEnum.ADT_901_0128.getErrCode(), (String)JsonUtils.objectToString((Object)uploadParamDTO), (String)TroubleToolCodeEnum.ADT_901_0128.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0128.getSuggestion());
        }
        catch (Exception ex) {
            LogUtils.buildAgileLog((String)"adt", (String)"snapshotSave", (String)TroubleToolCodeEnum.ADT_901_0127.getErrCode(), (String)JsonUtils.objectToString((Object)uploadParamDTO), (String)TroubleToolCodeEnum.ADT_901_0127.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0127.getSuggestion());
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.AAM_UPLOAD_AGILEDATA_FAIL.getErrCode(), JsonUtils.objectToString((Object)uploadParamDTO), ex});
            throw ExceptionUtil.wrap((String)ErrorCodeEnum.AAM_UPLOAD_AGILEDATA_FAIL.getErrCode(), (Exception)ex);
        }
        return null;
    }

    public SnapShotDTO getAgileData(String fileId) {
        String url = this.envProperties.getAamUri() + "/api/aam/v1/getAgileReportInfo?fileId=" + fileId;
        HttpHeaders headers = new HttpHeaders();
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (SnapShotDTO)((BaseResultDTO)responseEntity.getBody()).getResponse();
        }
        catch (Exception ex) {
            log.error("{}, \u8bf7\u6c42fileId\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.AAM_GET_AGILEDATA_FAIL.getErrCode(), fileId, ex});
            throw ExceptionUtil.wrap((String)ErrorCodeEnum.AAM_GET_AGILEDATA_FAIL.getErrCode(), (Exception)ex);
        }
    }

    public SnapShotDTO getAgileDataByToken(String fileId, String token) {
        String url = this.envProperties.getAamUri() + "/api/aam/v1/getAgileReportInfo?fileId=" + fileId;
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", token);
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (SnapShotDTO)((BaseResultDTO)responseEntity.getBody()).getResponse();
        }
        catch (Exception ex) {
            log.error("{}, \u8bf7\u6c42fileId\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.AAM_GET_AGILEDATA_FAIL.getErrCode(), fileId, ex});
            throw ExceptionUtil.wrap((String)ErrorCodeEnum.AAM_GET_AGILEDATA_FAIL.getErrCode(), (Exception)ex);
        }
    }

    public Map<String, Object> deleteAgileData(String fileId) {
        String url = this.envProperties.getAamUri() + "/api/aam/v1/deleteAgileReportInfo?fileId=" + fileId;
        HttpHeaders headers = new HttpHeaders();
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (Map)((BaseResultDTO)responseEntity.getBody()).getResponse();
        }
        catch (Exception ex) {
            log.error("{}, \u8bf7\u6c42fileId\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.AAM_DELETE_AGILEDATA_FAIL.getErrCode(), fileId, ex});
            throw ExceptionUtil.wrap((String)ErrorCodeEnum.AAM_DELETE_AGILEDATA_FAIL.getErrCode(), (Exception)ex);
        }
    }

    public Map<String, Object> deleteBatchAgileData(Collection<String> dirIds, Collection<String> fileIds, String token) {
        String url = this.envProperties.getAamUri() + "/api/aam/v1/batchDeleteAgileData";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", token);
        HashMap<String, Collection<String>> param = new HashMap<String, Collection<String>>();
        param.put("deleteFileList", fileIds);
        param.put("deleteDirList", dirIds);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (Map)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception ex) {
            log.error("\u8bf7\u6c42dirIds\uff1a{}, \u8bf7\u6c42fileIds\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{dirIds, fileIds, ex});
            throw ex;
        }
    }
}

