/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.domain.cac.impl;

import com.digiwin.athena.adt.agileReport.constant.ErrorCodeEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.domain.cac.AthenaCacService;
import com.digiwin.athena.adt.domain.dto.cac.CacCurrent;
import com.digiwin.athena.adt.domain.dto.cac.CacDecreaseReq;
import com.digiwin.athena.adt.domain.dto.cac.CacGoods;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Service
public class AthenaCacServiceImpl
implements AthenaCacService {
    private static final Logger log = LoggerFactory.getLogger(AthenaCacServiceImpl.class);
    @Autowired(required=false)
    private RestTemplate restTemplate;
    @Value(value="${cac.url:}")
    private String cacUrl;
    @Value(value="${athena.auth.appToken}")
    private String appToken;

    public CacGoods getCacCurrentTenantGoods(AuthoredUser user, String goodsCode) {
        long getQuerySchemaTook = System.currentTimeMillis();
        LogDto logDto = new LogDto("\u67e5\u8be2cac\u5546\u54c1\u4fe1\u606f\u5165\u53c2 goodsCode :{} user:{}", goodsCode, JsonUtils.objectToString((Object)user));
        log.info(logDto.toString());
        String url = this.cacUrl + "/api/cac/v4/authorizations/currentTenant/goods/" + goodsCode;
        HttpHeaders headers = new HttpHeaders();
        headers.set("Digi-Middleware-Auth-User", user.getToken());
        headers.set("Digi-Middleware-Auth-App", this.appToken);
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u67e5\u8be2 cac\u5546\u54c1\u4fe1\u606f\u8fd4\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)responseEntity.getBody()));
            return (CacGoods)responseEntity.getBody();
        }
        catch (ResourceAccessException e) {
            log.error("agiledata_ADT_ :\u8017\u65f6:{},\u95ee\u9898\u4f4d\u7f6e:{},\u95ee\u9898\u63cf\u8ff0:{},\u9519\u8bef\u5185\u5bb9:{},\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\u5bfc:{}", new Object[]{System.currentTimeMillis() - getQuerySchemaTook, "\u654f\u6377\u6570\u636e\u52a9\u7406\u5165\u53e3(ADT)->\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6307\u5b9a\u5e94\u7528\u7684\u6388\u6743\u4fe1\u606f(CAC) getCacCurrentTenantGoods", "\u8c03\u7528CAC\u63a5\u53e3\u8d85\u65f6 ResourceAccessException", goodsCode, "\u8bf7\u8054\u7cfb\u5e73\u53f0\u5904\u7406"});
            throw ErrorCodeEnum.CAC_REALTIME_FAIL.getBusinessException();
        }
        catch (Exception e) {
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.CAC_GET_FAIL.getErrCode(), goodsCode, e.getMessage()});
            throw ErrorCodeEnum.CAC_GET_FAIL.getBusinessException();
        }
    }

    public CacCurrent decreaseCurrentTenant(AuthoredUser user, CacDecreaseReq req) {
        long getQuerySchemaTook = System.currentTimeMillis();
        LogDto logDto = new LogDto("\u6839\u636e\u5e94\u7528goodsCode \u6263\u51cfcac \u6b21\u6570 \u5165\u53c2 cacDecreaseReq :{} ", JsonUtils.objectToString((Object)req));
        log.info(logDto.toString());
        String url = this.cacUrl + "/api/cac/v4/counting/decrease/bycurrenttenant";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Digi-Middleware-Auth-User", user.getToken());
        headers.set("Digi-Middleware-Auth-App", this.appToken);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u6263\u51cf cac \u8fd4\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)response));
            return (CacCurrent)response.getBody();
        }
        catch (ResourceAccessException e) {
            LogUtils.buildAgileLog((String)"adt", (String)"trafficDeduction", (String)TroubleToolCodeEnum.ADT_901_0118.getErrCode(), (String)JsonUtils.objectToString((Object)req), (String)TroubleToolCodeEnum.ADT_901_0118.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0118.getSuggestion());
            log.error("agiledata_ADT_ :\u8017\u65f6:{},\u95ee\u9898\u4f4d\u7f6e:{},\u95ee\u9898\u63cf\u8ff0:{},\u9519\u8bef\u5185\u5bb9:{},\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\u5bfc:{}", new Object[]{System.currentTimeMillis() - getQuerySchemaTook, "\u654f\u6377\u6570\u636e\u52a9\u7406\u5165\u53e3(ADT)->\u6263\u51cfcac\u6b21\u6570(CAC) decreaseCurrentTenant", "\u8c03\u7528ADE\u63a5\u53e3\u8d85\u65f6 ResourceAccessException", JsonUtils.objectToString((Object)req), "\u8bf7\u8054\u7cfb\u5e73\u53f0\u5904\u7406"});
            throw ErrorCodeEnum.CAC_REALTIME_DECREASE_FAIL.getBusinessException();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"trafficDeduction", (String)TroubleToolCodeEnum.ADT_901_0119.getErrCode(), (String)JsonUtils.objectToString((Object)req), (String)TroubleToolCodeEnum.ADT_901_0119.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0119.getSuggestion());
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.CAC_DECREASE_FAIL.getErrCode(), JsonUtils.objectToString((Object)req), e.getMessage()});
            throw ErrorCodeEnum.CAC_DECREASE_FAIL.getBusinessException();
        }
    }
}

