/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.domain.chatbi.impl;

import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSpecialUploadReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AnalysisAttributionReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AnalysisFluctuateReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.SchemaPushReportResDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.app.env.AdtEnvProperties;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.ScrumbiGenaratePPTReq;
import com.digiwin.athena.adt.domain.dto.ScrumbiGenaratePPTRes;
import com.digiwin.athena.adt.domain.dto.ScrumbiPPTAnalyzeDTO;
import com.digiwin.athena.adt.domain.dto.echo.EchoSubmitReq;
import com.digiwin.athena.adt.domain.dto.schema.AutoDataQuestionResDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaLiteResDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaReqDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.dto.schema.SchemaAnalysisAttributionResDTO;
import com.digiwin.athena.adt.domain.dto.schema.SchemaFluctuateResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.restful.iam.UserService;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Service
public class ChatbiServiceImpl
implements ChatbiService {
    private static final Logger log = LoggerFactory.getLogger(ChatbiServiceImpl.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private AdtEnvProperties adtEnvProperties;
    @Autowired
    private EchoService echoService;
    @Autowired
    private UserService userService;

    public QuerySchemaResDTO getQuerySchema(QuerySchemaReqDTO querySchemaReqDTO, AthenaMessageEvent event) {
        querySchemaReqDTO.setCloseStream(true);
        String url = this.adtEnvProperties.getChatBIUrl() + "/scrumbi/stream/chat";
        HttpHeaders headers = new HttpHeaders();
        headers.set("locale", event.getLang());
        headers.set("token", event.getUser().getToken());
        headers.set("Routerkey", event.getUser().getTenantId());
        headers.set("userId", event.getUser().getUserId());
        headers.set("messageId", String.valueOf(event.getGenerateSerialNo()));
        headers.set("ptxId", String.valueOf(event.getPtxId()));
        HttpEntity httpEntity = new HttpEntity((Object)querySchemaReqDTO, (MultiValueMap)headers);
        long getQuerySchemaTook = System.currentTimeMillis();
        log.error("agiledata_ADT_{}_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u5165\u53c2\uff1a{}", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), querySchemaReqDTO.getMessage(), JsonUtils.objectToString((Object)querySchemaReqDTO), event.getGenerateSerialNo()});
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, QuerySchemaResDTO.class, new Object[0]);
            log.error("agiledata_ADT_{}_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6\uff1a{}ms", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), querySchemaReqDTO.getMessage(), JsonUtils.objectToString((Object)response), System.currentTimeMillis() - getQuerySchemaTook, event.getGenerateSerialNo()});
            return (QuerySchemaResDTO)response.getBody();
        }
        catch (ResourceAccessException e) {
            log.error("agiledata_ADT_ :\u8017\u65f6:{},\u95ee\u9898\u4f4d\u7f6e:{},\u95ee\u9898\u63cf\u8ff0:{},\u9519\u8bef\u5185\u5bb9:{},\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\u5bfc:{}", new Object[]{System.currentTimeMillis() - getQuerySchemaTook, "\u654f\u6377\u6570\u636e\u52a9\u7406\u5165\u53e3(ADT)->\u8bed\u4e49\u7406\u89e3\u7ec4\u4ef6(SchemaBI)", "\u8bed\u4e49\u7406\u89e3\u8d85\u65f6", event.getQuestion(), "\u7f51\u7edc\u5f02\u5e38\u6216\u8005\u5927\u8bed\u8a00\u6a21\u578b\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8bbf\u95eehttps://dashboard.digiwincloud.com/\u67e5\u770b\u5f53\u524d\u7f51\u7edc\u76d1\u63a7\u72b6\u51b5"});
            this.echoService.echoSubmit(EchoSubmitReq.init((AthenaMessageEvent)event, (String)"\u8bed\u4e49\u7406\u89e3\u8d85\u65f6", (String)event.getQuestion(), (String)"\u7f51\u7edc\u5f02\u5e38\u6216\u8005\u5927\u8bed\u8a00\u6a21\u578b\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8bbf\u95eehttps://dashboard.digiwincloud.com/\u67e5\u770b\u5f53\u524d\u7f51\u7edc\u76d1\u63a7\u72b6\u51b5", (String)"1"), event.getUser().getToken(), event.getUser().getTenantId());
        }
        catch (Exception e) {
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6:{}ms", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), querySchemaReqDTO.getMessage(), JsonUtils.objectToString((Object)e.getMessage()), System.currentTimeMillis() - getQuerySchemaTook});
            this.echoService.echoSubmit(EchoSubmitReq.init((AthenaMessageEvent)event, (String)"\u8bf7\u6c42SCHEMA\u5f02\u5e38", (String)event.getQuestion(), (String)String.valueOf(e), (String)"1"), event.getUser().getToken(), event.getUser().getTenantId());
        }
        return null;
    }

    public QuerySchemaResDTO getQuerySchemaV2(Map<String, Object> msgBody, AthenaMessageEvent event) {
        String url = this.adtEnvProperties.getChatBIUrl() + "/scrumbi/v2/chat";
        msgBody.put("gptModel", this.adtEnvProperties.getChatGptModel());
        msgBody.put("gptProvider", "RH");
        msgBody.put("strategy", this.adtEnvProperties.getChatStrategy());
        HttpHeaders headers = new HttpHeaders();
        headers.set("locale", event.getLang());
        headers.set("token", event.getUser().getToken());
        headers.set("Routerkey", event.getUser().getTenantId());
        headers.set("userId", event.getUser().getUserId());
        headers.set("messageId", String.valueOf(event.getGenerateSerialNo()));
        headers.set("ptxId", String.valueOf(event.getPtxId()));
        HttpEntity httpEntity = new HttpEntity(msgBody, (MultiValueMap)headers);
        long getQuerySchemaTook = System.currentTimeMillis();
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u5165\u53c2\uff1a{}", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), MapUtils.getString(msgBody, (Object)"message"), JsonUtils.objectToString(msgBody)});
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, QuerySchemaResDTO.class, new Object[0]);
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6\uff1a{}ms", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), MapUtils.getString(msgBody, (Object)"message"), JsonUtils.objectToString((Object)response), System.currentTimeMillis() - getQuerySchemaTook});
            return (QuerySchemaResDTO)response.getBody();
        }
        catch (ResourceAccessException e) {
            log.error("agiledata_ADT_ :\u8017\u65f6:{},\u95ee\u9898\u4f4d\u7f6e:{},\u95ee\u9898\u63cf\u8ff0:{},\u9519\u8bef\u5185\u5bb9:{},\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\u5bfc:{}", new Object[]{System.currentTimeMillis() - getQuerySchemaTook, "\u654f\u6377\u6570\u636e\u52a9\u7406\u5165\u53e3(ADT)->\u8bed\u4e49\u7406\u89e3\u7ec4\u4ef6(SchemaBI)", "\u8bed\u4e49\u7406\u89e3\u8d85\u65f6", event.getQuestion(), "\u7f51\u7edc\u5f02\u5e38\u6216\u8005\u5927\u8bed\u8a00\u6a21\u578b\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8bbf\u95eehttps://dashboard.digiwincloud.com/\u67e5\u770b\u5f53\u524d\u7f51\u7edc\u76d1\u63a7\u72b6\u51b5"});
            this.echoService.echoSubmit(EchoSubmitReq.init((AthenaMessageEvent)event, (String)"\u8bed\u4e49\u7406\u89e3\u8d85\u65f6", (String)event.getQuestion(), (String)"\u7f51\u7edc\u5f02\u5e38\u6216\u8005\u5927\u8bed\u8a00\u6a21\u578b\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8bbf\u95eehttps://dashboard.digiwincloud.com/\u67e5\u770b\u5f53\u524d\u7f51\u7edc\u76d1\u63a7\u72b6\u51b5", (String)"1"), event.getUser().getToken(), event.getUser().getTenantId());
        }
        catch (Exception e) {
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6:{}ms", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), MapUtils.getString(msgBody, (Object)"message"), JsonUtils.objectToString((Object)e.getMessage()), System.currentTimeMillis() - getQuerySchemaTook});
            this.echoService.echoSubmit(EchoSubmitReq.init((AthenaMessageEvent)event, (String)"\u8bf7\u6c42SCHEMA\u5f02\u5e38", (String)event.getQuestion(), (String)String.valueOf(e), (String)"1"), event.getUser().getToken(), event.getUser().getTenantId());
        }
        return null;
    }

    public QuerySchemaLiteResDTO getQuerySchemaSpecial(Map<String, Object> requestParam, AthenaMessageEvent event) {
        String url = this.adtEnvProperties.getChatBIUrl() + "/scrumbi/chat/demo";
        requestParam.put("gptModel", this.adtEnvProperties.getChatGptModel());
        requestParam.put("gptProvider", "RH");
        requestParam.put("message", event.getQuestion());
        HttpHeaders headers = new HttpHeaders();
        headers.set("locale", event.getLang());
        headers.set("token", event.getUser().getToken());
        headers.set("Routerkey", event.getUser().getTenantId());
        headers.set("userId", event.getUser().getUserId());
        HttpEntity httpEntity = new HttpEntity(requestParam, (MultiValueMap)headers);
        long getQuerySchemaTook = System.currentTimeMillis();
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u5165\u53c2\uff1a{}", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), MapUtils.getString(requestParam, (Object)"message"), JsonUtils.objectToString(requestParam)});
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, QuerySchemaLiteResDTO.class, new Object[0]);
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6\uff1a{}s", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), MapUtils.getString(requestParam, (Object)"message"), JsonUtils.objectToString((Object)response), System.currentTimeMillis() - getQuerySchemaTook});
            LogUtils.buildAgileLog((String)"adt", (String)"liteModel", (String)"1", (String)JsonUtils.objectToString(requestParam), (String)JsonUtils.objectToString((Object)response), (String)"");
            return (QuerySchemaLiteResDTO)response.getBody();
        }
        catch (ResourceAccessException e) {
            LogUtils.buildAgileLog((String)"adt", (String)"liteModel", (String)TroubleToolCodeEnum.ADT_901_0105.getErrCode(), (String)JsonUtils.objectToString(requestParam), (String)TroubleToolCodeEnum.ADT_901_0105.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0105.getSuggestion());
            log.error("agiledata_ADT_ :\u8017\u65f6:{},\u95ee\u9898\u4f4d\u7f6e:{},\u95ee\u9898\u63cf\u8ff0:{},\u9519\u8bef\u5185\u5bb9:{},\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\u5bfc:{}", new Object[]{System.currentTimeMillis() - getQuerySchemaTook, "\u654f\u6377\u6570\u636e\u52a9\u7406\u5165\u53e3(ADT)->\u8bed\u4e49\u7406\u89e3\u7ec4\u4ef6(getQuerySchemaV2)", "\u8c03\u7528\u8bed\u4e49\u63a5\u53e3\u8d85\u65f6 ResourceAccessException", event.getQuestion(), "\u7f51\u7edc\u5f02\u5e38\u6216\u8005\u5927\u8bed\u8a00\u6a21\u578b\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8bbf\u95eehttp://xxxx.com\u67e5\u770b\u5f53\u524d\u7f51\u7edc\u76d1\u63a7\u72b6\u51b5"});
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"liteModel", (String)TroubleToolCodeEnum.ADT_901_0106.getErrCode(), (String)JsonUtils.objectToString(requestParam), (String)TroubleToolCodeEnum.ADT_901_0106.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0106.getSuggestion());
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6:{}s", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), MapUtils.getString(requestParam, (Object)"message"), JsonUtils.objectToString((Object)e.getMessage()), System.currentTimeMillis() - getQuerySchemaTook});
        }
        return null;
    }

    public QuerySchemaLiteResDTO getQuerySchemaSpecialLite(Map<String, Object> requestParam, AthenaMessageEvent event) {
        String url = this.adtEnvProperties.getChatBIUrl() + "/scrumbi/chat/lite";
        requestParam.put("gptModel", this.adtEnvProperties.getChatGptModel());
        requestParam.put("gptProvider", "RH");
        HttpHeaders headers = new HttpHeaders();
        headers.set("locale", event.getLang());
        headers.set("token", event.getUser().getToken());
        headers.set("Routerkey", event.getUser().getTenantId());
        headers.set("userId", event.getUser().getUserId());
        HttpEntity httpEntity = new HttpEntity(requestParam, (MultiValueMap)headers);
        long getQuerySchemaTook = System.currentTimeMillis();
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u5165\u53c2\uff1a{}", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), MapUtils.getString(requestParam, (Object)"message"), JsonUtils.objectToString(requestParam)});
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, QuerySchemaLiteResDTO.class, new Object[0]);
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6\uff1a{}s", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), MapUtils.getString(requestParam, (Object)"message"), JsonUtils.objectToString((Object)response), System.currentTimeMillis() - getQuerySchemaTook});
            LogUtils.buildAgileLog((String)"adt", (String)"liteModel", (String)"1", (String)JsonUtils.objectToString(requestParam), (String)JsonUtils.objectToString((Object)response), (String)"");
            return (QuerySchemaLiteResDTO)response.getBody();
        }
        catch (ResourceAccessException e) {
            LogUtils.buildAgileLog((String)"adt", (String)"liteModel", (String)TroubleToolCodeEnum.ADT_901_0103.getErrCode(), (String)JsonUtils.objectToString(requestParam), (String)TroubleToolCodeEnum.ADT_901_0103.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0103.getSuggestion());
            log.error("agiledata_ADT_ :\u8017\u65f6:{},\u95ee\u9898\u4f4d\u7f6e:{},\u95ee\u9898\u63cf\u8ff0:{},\u9519\u8bef\u5185\u5bb9:{},\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\u5bfc:{}", new Object[]{System.currentTimeMillis() - getQuerySchemaTook, "\u654f\u6377\u6570\u636e\u52a9\u7406\u5165\u53e3(ADT)->\u8bed\u4e49\u7406\u89e3\u7ec4\u4ef6(getQuerySchemaV2)", "\u8c03\u7528\u8bed\u4e49\u63a5\u53e3\u8d85\u65f6 ResourceAccessException", event.getQuestion(), "\u7f51\u7edc\u5f02\u5e38\u6216\u8005\u5927\u8bed\u8a00\u6a21\u578b\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8bbf\u95eehttp://xxxx.com\u67e5\u770b\u5f53\u524d\u7f51\u7edc\u76d1\u63a7\u72b6\u51b5"});
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"liteModel", (String)TroubleToolCodeEnum.ADT_901_0104.getErrCode(), (String)JsonUtils.objectToString(requestParam), (String)TroubleToolCodeEnum.ADT_901_0104.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0104.getSuggestion());
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6:{}s", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), MapUtils.getString(requestParam, (Object)"message"), JsonUtils.objectToString((Object)e.getMessage()), System.currentTimeMillis() - getQuerySchemaTook});
        }
        return null;
    }

    public SchemaPushReportResDTO schemaPushReport(AuthoredUser user, AgileDataSpecialUploadReqDTO req) {
        String url = this.adtEnvProperties.getFileparsing() + "/fileparsing/pushReport/v2";
        HttpHeaders headers = new HttpHeaders();
        headers.set("token", user.getToken());
        headers.set("Routerkey", user.getTenantId());
        headers.set("tenantId", user.getTenantId());
        headers.set("userId", user.getUserId());
        headers.set("locale", req.getLocale());
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        long getQuerySchemaTook = System.currentTimeMillis();
        log.error("agiledata_ADT_{}_{}_{}_{}:lite\u7248\u6587\u4ef6\u63a8\u9001\u5904\u7406\uff0c\u8bed\u4e49\u5165\u53c2\uff1a{}", new Object[]{user.getUserId(), user.getUserName(), user.getTenantId(), user.getTenantName(), JsonUtils.objectToString((Object)req)});
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.error("agiledata_ADT_{}_{}_{}_{}:lite\u7248\u6587\u4ef6\u63a8\u9001\u5904\u7406\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6\uff1a{}s", new Object[]{user.getUserId(), user.getUserName(), user.getTenantId(), user.getTenantName(), JsonUtils.objectToString((Object)response), System.currentTimeMillis() - getQuerySchemaTook});
            return (SchemaPushReportResDTO)response.getBody();
        }
        catch (ResourceAccessException e) {
            log.error("agiledata_ADT_ :\u8017\u65f6:{},\u95ee\u9898\u4f4d\u7f6e:{},\u95ee\u9898\u63cf\u8ff0:{},\u9519\u8bef\u5185\u5bb9:{},\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\u5bfc:{}", new Object[]{System.currentTimeMillis() - getQuerySchemaTook, "\u654f\u6377\u6570\u636e\u52a9\u7406\u5165\u53e3(ADT)->\u8bed\u4e49\u7406\u89e3\u7ec4\u4ef6(pushReport/v2)", "\u8c03\u7528\u8bed\u4e49\u63a5\u53e3\u8d85\u65f6 ResourceAccessException", req, "\u7f51\u7edc\u5f02\u5e38\u6216\u8005\u5927\u8bed\u8a00\u6a21\u578b\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8bbf\u95eehttp://xxxx.com\u67e5\u770b\u5f53\u524d\u7f51\u7edc\u76d1\u63a7\u72b6\u51b5"});
        }
        catch (Exception e) {
            log.error("agiledata_ADT_{}_{}_{}_{}:lite\u7248\u6587\u4ef6\u63a8\u9001\u5904\u7406\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6:{}s", new Object[]{user.getUserId(), user.getUserName(), user.getTenantId(), user.getTenantName(), JsonUtils.objectToString((Object)e.getMessage()), System.currentTimeMillis() - getQuerySchemaTook});
        }
        return null;
    }

    public Map<String, Object> getResultAnalysis(Map<String, Object> param, AuthoredUser user) {
        String userLocale = this.userService.getUserLangNameByUserId(user.getUserId(), user.getTenantId(), user.getToken());
        log.info("userLocale : {},", (Object)userLocale);
        String url = this.adtEnvProperties.getChatBIUrl() + "/scrumbi/resultAnalysis";
        HttpHeaders headers = new HttpHeaders();
        headers.set("token", user.getToken());
        headers.set("routerkey", user.getTenantId());
        headers.set("userId", user.getUserId());
        headers.set("locale", userLocale);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        log.info("resultAnalysis headers : {},", (Object)JsonUtils.objectToString((Object)headers));
        long getQuerySchemaTook = System.currentTimeMillis();
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u6570\u636e\u603b\u7ed3\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u5165\u53c2\uff1a{}", new Object[]{user.getUserId(), user.getUserName(), user.getTenantId(), user.getTenantName(), "\u6570\u636e\u603b\u7ed3", JsonUtils.objectToString(param)});
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u6570\u636e\u603b\u7ed3\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6\uff1a{}s", new Object[]{user.getUserId(), user.getUserName(), user.getTenantId(), user.getTenantName(), "\u6570\u636e\u603b\u7ed3", JsonUtils.objectToString((Object)response), System.currentTimeMillis() - getQuerySchemaTook});
            LogUtils.buildAgileLog((String)"adt", (String)"getResultAnalysis", (String)"1", (String)JsonUtils.objectToString(param), (String)JsonUtils.objectToString((Object)response), (String)"");
            return (Map)response.getBody();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"getResultAnalysis", (String)TroubleToolCodeEnum.ADT_901_0104.getErrCode(), (String)JsonUtils.objectToString(param), (String)TroubleToolCodeEnum.ADT_901_0104.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0104.getSuggestion());
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u6570\u636e\u603b\u7ed3\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6:{}s", new Object[]{user.getUserId(), user.getUserName(), user.getTenantId(), user.getTenantName(), "\u6570\u636e\u603b\u7ed3", JsonUtils.objectToString((Object)e.getMessage()), System.currentTimeMillis() - getQuerySchemaTook});
            return null;
        }
    }

    public SchemaFluctuateResDTO getFluctuateAnalysis(AthenaMessageEvent event, AnalysisFluctuateReqDTO req) {
        AuthoredUser user = event.getUser();
        String url = this.adtEnvProperties.getChatBIUrl() + "/scrumbi/dataAttribution/fluctuate";
        HttpHeaders headers = new HttpHeaders();
        headers.set("token", user.getToken());
        headers.set("routerkey", user.getTenantId());
        headers.set("userId", user.getUserId());
        headers.set("ptxId", event.getPtxId());
        headers.set("messageId", event.getGenerateSerialNo().toString());
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        long getQuerySchemaTook = System.currentTimeMillis();
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u6570\u636e\u6ce2\u52a8\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u5165\u53c2\uff1a{}", new Object[]{user.getUserId(), user.getUserName(), user.getTenantId(), user.getTenantName(), "\u6570\u636e\u6ce2\u52a8", JsonUtils.objectToString((Object)req)});
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u6570\u636e\u6ce2\u52a8\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6\uff1a{}s", new Object[]{user.getUserId(), user.getUserName(), user.getTenantId(), user.getTenantName(), "\u6570\u636e\u6ce2\u52a8", JsonUtils.objectToString((Object)response), System.currentTimeMillis() - getQuerySchemaTook});
            LogUtils.buildAgileLog((String)"adt", (String)"getFluctuateAnalysis", (String)"1", (String)JsonUtils.objectToString((Object)req), (String)JsonUtils.objectToString((Object)response), (String)"");
            return (SchemaFluctuateResDTO)response.getBody();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"getFluctuateAnalysis", (String)TroubleToolCodeEnum.ADT_901_0104.getErrCode(), (String)JsonUtils.objectToString((Object)req), (String)TroubleToolCodeEnum.ADT_901_0104.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0104.getSuggestion());
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u6570\u636e\u6ce2\u52a8\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6:{}s", new Object[]{user.getUserId(), user.getUserName(), user.getTenantId(), user.getTenantName(), "\u6570\u636e\u6ce2\u52a8", JsonUtils.objectToString((Object)e.getMessage()), System.currentTimeMillis() - getQuerySchemaTook});
            return null;
        }
    }

    public SchemaAnalysisAttributionResDTO getAttributionAnalysis(AthenaMessageEvent event, AnalysisAttributionReqDTO req) {
        AuthoredUser user = event.getUser();
        String url = this.adtEnvProperties.getChatBIUrl() + "/scrumbi/dataAttribution";
        HttpHeaders headers = new HttpHeaders();
        headers.set("token", user.getToken());
        headers.set("routerkey", user.getTenantId());
        headers.set("userId", user.getUserId());
        headers.set("ptxId", event.getPtxId());
        headers.set("messageId", event.getGenerateSerialNo().toString());
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        long getQuerySchemaTook = System.currentTimeMillis();
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u6570\u636e\u5f52\u56e0\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u5165\u53c2\uff1a{}", new Object[]{user.getUserId(), user.getUserName(), user.getTenantId(), user.getTenantName(), "\u6570\u636e\u5f52\u56e0", JsonUtils.objectToString((Object)req)});
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u6570\u636e\u5f52\u56e0\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6\uff1a{}s", new Object[]{user.getUserId(), user.getUserName(), user.getTenantId(), user.getTenantName(), "\u6570\u636e\u5f52\u56e0", JsonUtils.objectToString((Object)response), System.currentTimeMillis() - getQuerySchemaTook});
            LogUtils.buildAgileLog((String)"adt", (String)"getFluctuateAnalysis", (String)"1", (String)JsonUtils.objectToString((Object)req), (String)JsonUtils.objectToString((Object)response), (String)"");
            return (SchemaAnalysisAttributionResDTO)response.getBody();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"getFluctuateAnalysis", (String)TroubleToolCodeEnum.ADT_901_0104.getErrCode(), (String)JsonUtils.objectToString((Object)req), (String)TroubleToolCodeEnum.ADT_901_0104.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0104.getSuggestion());
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u6570\u636e\u5f52\u56e0\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6:{}s", new Object[]{user.getUserId(), user.getUserName(), user.getTenantId(), user.getTenantName(), "\u6570\u636e\u5f52\u56e0", JsonUtils.objectToString((Object)e.getMessage()), System.currentTimeMillis() - getQuerySchemaTook});
            return null;
        }
    }

    public ScrumbiPPTAnalyzeDTO getPPTAnalyze(AuthoredUser user, Map<String, Object> params, String locale) {
        String url = this.adtEnvProperties.getChatBIUrl() + "/scrumbi/question/reGenarate";
        HttpHeaders headers = new HttpHeaders();
        headers.set("token", user.getToken());
        headers.set("routerkey", user.getTenantId());
        headers.set("userId", user.getUserId());
        headers.set("locale", locale);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        long getQuerySchemaTook = System.currentTimeMillis();
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6PPT\u5206\u6790\u89c4\u5212\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u5165\u53c2\uff1a{}", new Object[]{user.getUserId(), user.getUserName(), user.getTenantId(), user.getTenantName(), "\u6570\u636e\u5f52\u56e0", JsonUtils.objectToString(params)});
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6PPT\u5206\u6790\u89c4\u5212\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6\uff1a{}s", new Object[]{user.getUserId(), user.getUserName(), user.getTenantId(), user.getTenantName(), "\u6570\u636e\u5f52\u56e0", JsonUtils.objectToString((Object)response), System.currentTimeMillis() - getQuerySchemaTook});
            LogUtils.buildAgileLog((String)"adt", (String)"getFluctuateAnalysis", (String)"1", (String)JsonUtils.objectToString(params), (String)JsonUtils.objectToString((Object)response), (String)"");
            return (ScrumbiPPTAnalyzeDTO)response.getBody();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"getFluctuateAnalysis", (String)TroubleToolCodeEnum.ADT_901_0104.getErrCode(), (String)JsonUtils.objectToString(params), (String)TroubleToolCodeEnum.ADT_901_0104.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0104.getSuggestion());
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6PPT\u5206\u6790\u89c4\u5212\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6:{}s", new Object[]{user.getUserId(), user.getUserName(), user.getTenantId(), user.getTenantName(), "\u6570\u636e\u5f52\u56e0", JsonUtils.objectToString((Object)e.getMessage()), System.currentTimeMillis() - getQuerySchemaTook});
            return null;
        }
    }

    public ScrumbiGenaratePPTRes generatePPT(AuthoredUser user, ScrumbiGenaratePPTReq req, String locale) {
        String url = this.adtEnvProperties.getChatBIUrl() + "/scrumbi/ppt/genarate";
        HttpHeaders headers = new HttpHeaders();
        headers.set("token", user.getToken());
        headers.set("routerkey", user.getTenantId());
        headers.set("userId", user.getUserId());
        headers.set("locale", locale);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        long getQuerySchemaTook = System.currentTimeMillis();
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6PPT\u751f\u6210\u53ef\u6267\u884c\u4f53\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u5165\u53c2\uff1a{}", new Object[]{user.getUserId(), user.getUserName(), user.getTenantId(), user.getTenantName(), "PPT\u751f\u6210", JsonUtils.objectToString((Object)req)});
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6PPT\u751f\u6210\u53ef\u6267\u884c\u4f53\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6\uff1a{}s", new Object[]{user.getUserId(), user.getUserName(), user.getTenantId(), user.getTenantName(), "PPT\u751f\u6210", JsonUtils.objectToString((Object)response), System.currentTimeMillis() - getQuerySchemaTook});
            LogUtils.buildAgileLog((String)"adt", (String)"getFluctuateAnalysis", (String)"1", (String)JsonUtils.objectToString((Object)req), (String)JsonUtils.objectToString((Object)response), (String)"");
            return (ScrumbiGenaratePPTRes)response.getBody();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"getFluctuateAnalysis", (String)TroubleToolCodeEnum.ADT_901_0104.getErrCode(), (String)JsonUtils.objectToString((Object)req), (String)TroubleToolCodeEnum.ADT_901_0104.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0104.getSuggestion());
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6PPT\u751f\u6210\u53ef\u6267\u884c\u4f53\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6:{}s", new Object[]{user.getUserId(), user.getUserName(), user.getTenantId(), user.getTenantName(), "PPT\u751f\u6210", JsonUtils.objectToString((Object)e.getMessage()), System.currentTimeMillis() - getQuerySchemaTook});
            return null;
        }
    }

    public AutoDataQuestionResDTO getIntentionConfirm(AthenaMessageEvent event, Map<String, Object> req) {
        String url = this.adtEnvProperties.getChatBIUrl() + "/scrumbi/intention/confirm";
        HttpHeaders headers = new HttpHeaders();
        headers.set("locale", event.getLang());
        headers.set("token", event.getUser().getToken());
        headers.set("Routerkey", event.getUser().getTenantId());
        headers.set("userId", event.getUser().getUserId());
        headers.set("messageId", String.valueOf(event.getGenerateSerialNo()));
        headers.set("ptxId", String.valueOf(event.getPtxId()));
        HttpEntity httpEntity = new HttpEntity(req, (MultiValueMap)headers);
        long getQuerySchemaTook = System.currentTimeMillis();
        log.error("agiledata_ADT_{}_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u5165\u53c2\uff1a{}", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), req.get("question"), JsonUtils.objectToString(req), event.getGenerateSerialNo()});
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.error("agiledata_ADT_{}_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6\uff1a{}ms", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), req.get("question"), JsonUtils.objectToString((Object)response), System.currentTimeMillis() - getQuerySchemaTook, event.getGenerateSerialNo()});
            return (AutoDataQuestionResDTO)response.getBody();
        }
        catch (Exception e) {
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6:{}ms", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), req.get("question"), JsonUtils.objectToString((Object)e.getMessage()), System.currentTimeMillis() - getQuerySchemaTook});
            this.echoService.echoSubmit(EchoSubmitReq.init((AthenaMessageEvent)event, (String)"\u8bf7\u6c42SCHEMA\u5f02\u5e38", (String)event.getQuestion(), (String)String.valueOf(e), (String)"1"), event.getUser().getToken(), event.getUser().getTenantId());
            return null;
        }
    }
}

