/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.domain.dmc.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.ErrorCodeEnum;
import com.digiwin.athena.adt.agileReport.service.impl.dmc.CommonInputStreamResource;
import com.digiwin.athena.adt.domain.dmc.DmcService;
import com.digiwin.athena.adt.domain.dto.UploadAttachmentResp;
import com.digiwin.athena.adt.domain.dto.UploadParamDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class DmcServiceImpl
implements DmcService {
    private static final Logger log = LoggerFactory.getLogger(DmcServiceImpl.class);
    @Autowired(required=false)
    private RestTemplate restTemplate;
    @Value(value="${dmc.account}")
    private String account;
    @Value(value="${dmc.password}")
    private String password;
    @Value(value="${dmc.url:}")
    private String dmcUrl;
    @Value(value="${dmc.bucket:}")
    private String bucket;
    @Value(value="${athena.auth.appToken}")
    private String appToken;

    public UploadAttachmentResp uploadAgileData(UploadParamDTO uploadParamDTO, AuthoredUser user) {
        try {
            String dmcToken = this.login(user);
            HttpHeaders headers = new HttpHeaders();
            LinkedMultiValueMap param = new LinkedMultiValueMap();
            String uploadUrl = this.dmcUrl + "/api/dmc/v2/file/" + this.bucket + "/upload";
            HashMap fileMap = Maps.newHashMap();
            fileMap.put("displayName", uploadParamDTO.getFileName());
            fileMap.put("fileName", uploadParamDTO.getDownloadName());
            fileMap.put("tenantId", user.getTenantId());
            fileMap.put("expireDate", uploadParamDTO.getExpireDate());
            ByteArrayInputStream stream = new ByteArrayInputStream(uploadParamDTO.getFileJson().getBytes());
            uploadParamDTO.setInputStream((InputStream)stream);
            if (uploadParamDTO.getInputStream().available() <= 0) {
                throw new RuntimeException();
            }
            uploadParamDTO.setDownloadName(uploadParamDTO.getFileName() + ".json");
            CommonInputStreamResource inputStreamResource = new CommonInputStreamResource((InputStream)stream, uploadParamDTO.getDownloadName());
            param.add((Object)"file", (Object)inputStreamResource);
            param.add((Object)"fileInfo", (Object)fileMap);
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            headers.set("digi-middleware-auth-user", dmcToken);
            HttpEntity uploadHttpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(uploadUrl, HttpMethod.POST, uploadHttpEntity, String.class, new Object[0]);
            if (HttpStatus.OK.value() == responseEntity.getStatusCodeValue()) {
                String uploadResult = (String)responseEntity.getBody();
                JSONObject jsonObject = JSON.parseObject((String)uploadResult);
                return (UploadAttachmentResp)JSONObject.parseObject((String)JSON.toJSONString((Object)jsonObject.getJSONObject("data")), UploadAttachmentResp.class);
            }
        }
        catch (Exception e) {
            throw BusinessException.create((String)ErrorCodeEnum.UPLOAD_DMC_ERROR.getErrCode(), (String)ErrorCodeEnum.UPLOAD_DMC_ERROR.getErrMsg());
        }
        return null;
    }

    public String login(AuthoredUser user) {
        String url = this.dmcUrl + "/api/dmc/v1/auth/login";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", this.account);
        params.put("pwdhash", this.buildPassword(this.password));
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (HttpStatus.OK.value() == respEntity.getStatusCodeValue()) {
                return String.valueOf(((Map)Objects.requireNonNull(respEntity.getBody())).get("userToken"));
            }
            log.error("dmcLogin: login dmc failed, params: {}, response: {}", params, respEntity.getBody());
            throw BusinessException.create((Integer)respEntity.getStatusCodeValue(), (String)("login dmc failed, error: " + JsonUtils.objectToString((Object)respEntity.getBody())));
        }
        catch (Exception ex) {
            if (ex instanceof BusinessException) {
                throw ex;
            }
            log.error("dmcLogin: login dmc failed, params: {}, error: {}", params, (Object)ex);
            throw BusinessException.create((String)("login dmc failed, error: " + ex.getMessage()));
        }
    }

    private String buildPassword(String agileDataPassword) {
        try {
            MessageDigest sha256MessageDigest = MessageDigest.getInstance("SHA-256");
            sha256MessageDigest.update(agileDataPassword.getBytes(StandardCharsets.UTF_8));
            byte[] tempByte = sha256MessageDigest.digest();
            sha256MessageDigest.update(tempByte);
            return new String(Base64.getEncoder().encode(sha256MessageDigest.digest()));
        }
        catch (Exception e) {
            log.error("dmc\u5bc6\u7801\u52a0\u5bc6\u9519\u8bef\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
            return agileDataPassword;
        }
    }

    public SnapShotDTO getAgileData(String fileId) {
        HttpHeaders headers = new HttpHeaders();
        String url = this.dmcUrl + "/api/dmc/v2/file/" + this.bucket + "/preview/" + fileId;
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        log.info("\u67e5\u8be2 dmc\u5feb\u7167\u4fe1\u606f\u8fd4\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)responseEntity.getBody()));
        if (Objects.nonNull(responseEntity.getBody()) && !StringUtils.isEmpty((Object)((SnapShotDTO)responseEntity.getBody()).getSnapshotId())) {
            return (SnapShotDTO)responseEntity.getBody();
        }
        return this.getAthenaAgileData(fileId);
    }

    public Map<String, Object> getDmcAgileData(String fileId) {
        HttpHeaders headers = new HttpHeaders();
        String url = this.dmcUrl + "/api/dmc/v2/file/" + this.bucket + "/preview/" + fileId;
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        log.info("\u67e5\u8be2 dmc\u6587\u4ef6\u4fe1\u606f\u8fd4\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)responseEntity.getBody()));
        if (Objects.nonNull(responseEntity.getBody())) {
            return (Map)responseEntity.getBody();
        }
        return null;
    }

    public SnapShotDTO getAthenaAgileData(String fileId) {
        HttpHeaders headers = new HttpHeaders();
        String url = this.dmcUrl + "/api/dmc/v2/file/Athena/preview/" + fileId;
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        log.info("\u67e5\u8be2 dmc\u5feb\u7167\u4fe1\u606f\u8fd4\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)responseEntity.getBody()));
        return (SnapShotDTO)responseEntity.getBody();
    }

    public Map<String, Object> deleteAgileData(String fileId) {
        String url = this.dmcUrl + "/api/dmc/v2/file/" + this.bucket + "/delete/" + fileId;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.DELETE, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        return (Map)responseEntity.getBody();
    }

    public void deleteBatchAgileData(Collection<String> dirIds, Collection<String> fileIds, String token) {
        String url = this.dmcUrl + "/api/dmc/v2/file/" + this.bucket + "/delete";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("digi-middleware-auth-user", token);
        HashMap<String, Collection<String>> param = new HashMap<String, Collection<String>>();
        param.put("fileIds", fileIds);
        param.put("dirIds", dirIds);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (HttpStatus.OK.value() == respEntity.getStatusCodeValue()) {
                return;
            }
            log.error("deleteAgileData: delete dmc AgileData failed, params: {}, response: {}", param, respEntity.getBody());
            throw BusinessException.create((Integer)respEntity.getStatusCodeValue(), (String)("delete dmc AgileData failed, error: " + JsonUtils.objectToString((Object)respEntity.getBody())));
        }
        catch (Exception ex) {
            if (ex instanceof BusinessException) {
                throw ex;
            }
            log.error("deleteAgileData: delete dmc AgileData failed, params: {}, error: {}", param, (Object)ex);
            throw BusinessException.create((String)("delete dmc AgileData failed, error: " + ex.getMessage()));
        }
    }

    public SnapShotDTO getAgileDataByToken(String fileId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", token);
        String url = this.dmcUrl + "/api/dmc/v2/file/" + this.bucket + "/preview/" + fileId;
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        log.info("\u67e5\u8be2 \u5feb\u7167\u4fe1\u606f\u8fd4\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)responseEntity.getBody()));
        if (Objects.nonNull(responseEntity.getBody()) && !StringUtils.isEmpty((Object)((SnapShotDTO)responseEntity.getBody()).getSnapshotId())) {
            return (SnapShotDTO)responseEntity.getBody();
        }
        return this.getAthenaAgileData(fileId);
    }
}

